/***************************************************************************
                          playlist.h  -  description
                             -------------------
    begin                : 2001-07-24
    copyright            : (C) 2001 by Shaun Jackman (sjackman@debian.org)
    modify by:           : Andres Oton 
    email                : andres.oton@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __playlist_h__
#define __playlist_h__

// libnjb
#include <libnjb.h>

// TQt
#include <tqstringlist.h>


class NjbPlaylist {
    public: 
        NjbPlaylist();
        NjbPlaylist( njb_playlist_t* playlist);
        NjbPlaylist(const NjbPlaylist& _copy);
        ~NjbPlaylist( void);

        TQStringList trackNames( void) const;
        void operator=(const NjbPlaylist& _copy);
        bool operator==(const TQString& name) const;
        bool operator==(const NjbPlaylist& rval) const;
        TQString getName(void) const;

        int setName( const TQString& fileName);
        int addTrack( const TQString& fileName);
        int update( void);

        u_int32_t getId(void) const { return m_playlist->plid; }

    protected:
        void setPlaylist( njb_playlist_t* _newlist );

        static TQString unescapefilename( const TQString& );
        static TQString escapefilename( const TQString& );

    private:
        njb_playlist_t* m_playlist;
};

class playlistValueList: public TQValueList<NjbPlaylist>
{
    public:
        int readFromDevice( void);
};

#endif
