/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_TEMPOCOLOUR_H_
#define _RG_TEMPOCOLOUR_H_

#include <tqcolor.h>




namespace Rosegarden
{



class TempoColour
{

public:
    TempoColour():m_tempo(0) {;}
    TempoColour(double tempo):m_tempo(tempo) {;}

    // Get the colour for a tempo
    //
    TQColor getColour() { return getColour(m_tempo); }
    static TQColor getColour(double tempo);

private:

    double m_tempo;

};


}

#endif
