/* $Id: klearlook.cpp,v 1.25 2006/04/26 18:55:41 jck Exp $

Klearlook (C) Joerg C. Koenig, 2005 jck@gmx.org

----

Based upon TQtCurve (C) Craig Drummond, 2003 Craig.Drummond@lycos.co.uk
    Bernhard Rosenkr�zer <bero@r?dh?t.com>
    Preston Brown <pbrown@r?dh?t.com>
    Than Ngo <than@r?dh?t.com>

Released under the GNU General Public License (GPL) v2.

----

B???Curve is based on the KDE Light style, 2nd revision:
Copyright(c)2000-2001 Trolltech AS (info@trolltech.com)

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files(the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <tdeversion.h>
#include <tqmenubar.h>
#include <tqapplication.h>
#include <tqpainter.h>
#include <tqpalette.h>
#include <tqframe.h>
#include <tqpushbutton.h>
#include <tqdrawutil.h>
#include <tqscrollbar.h>
#include <tqtabbar.h>
#include <tqtabwidget.h>
#include <tqguardedptr.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqlistview.h>
#include <tqbitmap.h>
#include <tqcleanuphandler.h>
#include <tqimage.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqslider.h>
#include <tqstylefactory.h>
#include <tqcleanuphandler.h>
#include <tqcheckbox.h>
#include <tqradiobutton.h>
#include <tqtoolbutton.h>
#include <tqtoolbar.h>
#include <tqprogressbar.h>
#include <tqcursor.h>
#include <tqheader.h>
#include <tqwidgetstack.h>
#include <tqsplitter.h>
#include <math.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include "klearlook.h"
#include <tqsettings.h>

#if TDE_VERSION >= 0x30200
#include <tqfile.h>
#include <tqdir.h>
#endif

// Uncomment the following to enable gradients in toolbars and menubars
// NOTE: Not yet complete!!!
//#define TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

//static int HIGH_LIGHT_FACTORS[]={ 100, 100, 100, 101, 102, 103, 104, 105 /*def*/, 106, 107, 108 };
//#define HIGHLIGHT_FACTOR(X) (X<0||X>10) ? 105 : HIGH_LIGHT_FACTORS[X]
#define TQTC_HIGHLIGHT_FACTOR 105
#define TQTC_BORDERED_FRAME_WIDTH 2
#define TQTC_DEF_FRAME_WIDTH 1 
//#define TQTC_MIN_BTN_SIZE 10
#define TQTC_NO_SECT -1

#define MENU_POPUP_ITEM_HIGH_HI  7
#define MENU_POPUP_ITEM_HIGH_LO  5 
//#define MENU_POPUP_SHADOW

#define POS_DIV(a, b)  ( (a)/(b) +  ( ( (a) % (b) >= (b)/2 ) ? 1 : 0 ) )

static const int itemHMargin = 6;
static const int itemFrame = 2;
static const int arrowHMargin = 6;
static const int rightBorder = 12;

#if TDE_VERSION >= 0x30200 
// Try to read $TDEHOME/share/config/kickerrc to find out if kicker is transparent...

static TQString readEnvPath( const char *env ) {
    TQCString path = getenv( env );

    return path.isEmpty()
           ? TQString()
           : TQFile::decodeName( path );
}

static bool kickerIsTrans() {
    TQString kdeHome( readEnvPath( getuid() ? "TDEHOME" : "TDEROOTHOME" ) ),
    cfgFileName;
    bool trans = false;

    if ( kdeHome.isEmpty() )
        cfgFileName = TQDir::homeDirPath() + "/.trinity/share/config/kickerrc";
    else
        cfgFileName = TQString( kdeHome ) + "/share/config/kickerrc";

    TQFile cfgFile( cfgFileName );

    if ( cfgFile.open( IO_ReadOnly ) ) {
        TQTextStream stream( &cfgFile );
        TQString line;
        bool stop = false,
                    inGen = false;

        while ( !stream.atEnd() && !stop ) {
            line = stream.readLine();

            if ( inGen ) {
                if ( 0 == line.find( "Transparent=" ) )    // Found it!
                {
                    if ( -1 != line.find( "true" ) )
                        trans = true;
                    stop = true;
                } else if ( line[ 0 ] == TQChar( '[' ) )     // Then wasn't in General section...
                    stop = true;
            } else if ( 0 == line.find( "[General]" ) )
                inGen = true;
        }
        cfgFile.close();
    }

    return trans;
}
#endif

inline int limit( double c ) {
    return c < 0.0
           ? 0
           : c > 255.0
           ? 255
           : ( int ) c;
}

inline TQColor midColor( const TQColor &a, const TQColor &b, double factor = 1.0 ) {
    return TQColor( ( a.red() + limit( b.red() * factor ) ) >> 1,
                   ( a.green() + limit( b.green() * factor ) ) >> 1,
                   ( a.blue() + limit( b.blue() * factor ) ) >> 1 );
}

// Copied from Keramik...
static bool isFormWidget( const TQWidget *widget ) {
    //Form widgets are in the TDEHTMLView, but that has 2 further inner levels
    //of widgets - TQClipperWidget, and outside of that, TQViewportWidget
    TQWidget * potentialClipPort = widget->parentWidget();

    if ( !potentialClipPort || potentialClipPort->isTopLevel() )
        return false;

    TQWidget *potentialViewPort = potentialClipPort->parentWidget();

    if ( !potentialViewPort || potentialViewPort->isTopLevel() || qstrcmp( potentialViewPort->name(), "qt_viewport" ) )
        return false;

    TQWidget *potentialTDEHTML = potentialViewPort->parentWidget();

    if ( !potentialTDEHTML || potentialTDEHTML->isTopLevel() || qstrcmp( potentialTDEHTML->className(), "TDEHTMLView" ) )
        return false;

    return true;
}

static void rgb2hls( double *r, double *g, double *b ) 
{
	double min;
	double max;
	double red;
	double green;
	double blue;
	double h, l, s;
	double delta;
	
	red = *r;
	green = *g;
	blue = *b;

	if (red > green)
	{
		if (red > blue)
			max = red;
		else
			max = blue;
	
		if (green < blue)
			min = green;
		else
			min = blue;
	}
	else
	{
		if (green > blue)
			max = green;
		else
			max = blue;
	
		if (red < blue)
			min = red;
		else
			min = blue;
	}

	l = (max + min) / 2;
	s = 0;
	h = 0;

	if (max != min)
	{
		if (l <= 0.5)
			s = (max - min) / (max + min);
		else
			s = (max - min) / (2 - max - min);
	
		delta = max -min;
		if (red == max)
			h = (green - blue) / delta;
		else if (green == max)
			h = 2 + (blue - red) / delta;
		else if (blue == max)
			h = 4 + (red - green) / delta;
	
		h *= 60;
		if (h < 0.0)
			h += 360;
	}

	*r = h;
	*g = l;
	*b = s;
}


static void hls2rgb( double *h, double *l, double *s ) {
	double hue;
	double lightness;
	double saturation;
	double m1, m2;
	double r, g, b;
	lightness = *l;
	saturation = *s;

	if (lightness <= 0.5)
		m2 = lightness * (1 + saturation);
	else
		m2 = lightness + saturation - lightness * saturation;
		
	m1 = 2 * lightness - m2;

	if (saturation == 0)
	{
		*h = lightness;
		*l = lightness;
		*s = lightness;
	}
	else
	{
		hue = *h + 120;
		while (hue > 360)
			hue -= 360;
		while (hue < 0)
			hue += 360;
	
		if (hue < 60)
			r = m1 + (m2 - m1) * hue / 60;
		else if (hue < 180)
			r = m2;
		else if (hue < 240)
			r = m1 + (m2 - m1) * (240 - hue) / 60;
		else
			r = m1;
	
		hue = *h;
		while (hue > 360)
			hue -= 360;
		while (hue < 0)
			hue += 360;
	
		if (hue < 60)
			g = m1 + (m2 - m1) * hue / 60;
		else if (hue < 180)
			g = m2;
		else if (hue < 240)
			g = m1 + (m2 - m1) * (240 - hue) / 60;
		else
			g = m1;
	
		hue = *h - 120;
		while (hue > 360)
			hue -= 360;
		while (hue < 0)
			hue += 360;
	
		if (hue < 60)
			b = m1 + (m2 - m1) * hue / 60;
		else if (hue < 180)
			b = m2;
		else if (hue < 240)
			b = m1 + (m2 - m1) * (240 - hue) / 60;
		else
			b = m1;
	
		*h = r;
		*l = g;
		*s = b;
	}

}

static bool equal( double d1, double d2 ) {
    return ( fabs( d1 - d2 ) < 0.0001 );
}

static void shade( const TQColor &a, TQColor *b, float k ) {

    if ( equal( k, 1.0 ) )
        * b = a;
    else {
        double red = a.red() / 256.0,
               green = a.green() / 256.0,
               blue = a.blue() / 256.0;

        rgb2hls( &red, &green, &blue );

        green *= k;
        if ( green > 1.0 )
            green = 1.0;
        else if ( green < 0.0 )
            green = 0.0;

        blue *= k;
        if ( blue > 1.0 )
            blue = 1.0;
        else if ( blue < 0.0 )
            blue = 0.0;

        hls2rgb( &red, &green, &blue );

        b->setRgb( limit( red * 256 ), limit( green * 256 ), limit( blue * 256 ) );
    }
}

static void shadeGradient( const TQColor &base, TQColor *vals ) {
    vals[ KlearlookStyle::GRADIENT_BASE ] = base;
    
    shade( vals[ KlearlookStyle::GRADIENT_BASE ],
        &( vals[ KlearlookStyle::GRADIENT_TOP ] ), SHADE_GRADIENT_TOP );
        
    shade( vals[ KlearlookStyle::GRADIENT_BASE ],
        &( vals[ KlearlookStyle::GRADIENT_BOTTOM ] ), SHADE_GRADIENT_BOTTOM );
        
    shade( vals[ KlearlookStyle::GRADIENT_BASE ],
        &( vals[ KlearlookStyle::GRADIENT_LIGHT ] ), SHADE_GRADIENT_LIGHT );
    shade( vals[ KlearlookStyle::GRADIENT_BASE ],
        &( vals[ KlearlookStyle::GRADIENT_DARK ] ), SHADE_GRADIENT_DARK );
}

static void drawLines( TQPainter *p, const TQRect &r, bool horiz, int nLines, int offset, const TQColor *cols,
                       int startOffset, bool etched, bool lightGradient ) {
    int space = ( nLines * 2 ) + ( nLines - 1 ),
                x = horiz ? r.x() : r.x() + ( ( r.width() - space ) >> 1 ),
                    y = horiz ? r.y() + ( ( r.height() - space ) >> 1 ) : r.y(),
                        x2 = r.x() + r.width() - 1,
                             y2 = r.y() + r.height() - 1,
                                  i,
                                  displacement = etched ? 1 : 0;

    if ( horiz ) {
        if ( startOffset && y + startOffset > 0 )
            y += startOffset;

	p->setPen( cols[ etched ? lightGradient ? 3 : 4 : 0 ] );
        for ( i = 0; i < space; i += 3 )
            p->drawLine( x + offset, y + i, x2 - ( offset + displacement ), y + i );

        p->setPen( cols[ etched ? 0 : lightGradient ? 3 : 4 ] );
        for ( i = 1; i < space; i += 3 )
            p->drawLine( x + offset + displacement, y + i - 2, x2 - offset, y + i  - 2);
    } else {
        if ( startOffset && x + startOffset > 0 )
            x += startOffset;

	p->setPen( cols[ etched ? lightGradient ? 3 : 4 : 0 ] );
        for ( i = 0; i < space; i += 3 )
            p->drawLine( x + i, y + offset, x + i, y2 - ( offset + displacement ) );

        p->setPen( cols[ etched ? 0 : lightGradient ? 3 : 4 ] );
        for ( i = 1; i < space; i += 3 )
            p->drawLine( x + i -2, y + offset + displacement, x + i -2, y2 - offset );
    }
}

inline TQColor getFill( TQStyle::SFlags flags, const TQColor *use ) {
    return !( flags & TQStyle::Style_Enabled )
           ? use[ 1 ]
           : flags & TQStyle::Style_Down
           ? use[ 3 ]
           : flags & TQStyle::Style_MouseOver
           ? flags & ( TQStyle::Style_On | TQStyle::Style_Sunken )
           ? TQColor(use[ 3 ].light( TQTC_HIGHLIGHT_FACTOR ))
           : TQColor(use[ NUM_SHADES ].light( TQTC_HIGHLIGHT_FACTOR ))
                   : flags & ( TQStyle::Style_On | TQStyle::Style_Sunken )
                   ? use[ 3 ]
                   : use[ NUM_SHADES ];
}

#ifdef USE_SINGLE_STYLE
KlearlookStyle::KlearlookStyle()
#else
KlearlookStyle::KlearlookStyle(
    bool gpm, bool bb, bool bf, bool round, EGroove st, h,
    bool ge, bool va, bool bdt, bool crlh, EDefBtnIndicator dbi, ETBarBorder tbb,
    ELvExpander lve, ELvLines lvl, bool lvd, bool ico, int popuplvl ) )
#endif
: TDEStyle( AllowMenuTransparency, WindowsStyleScrollBar ),
themedApp( APP_OTHER ),
#ifndef USE_SINGLE_STYLE
borderButton( bb ), borderFrame( bf ), rounded( round ), etchedSlider( etched ), appearance( ge ? APPEARANCE_GRADIENT : APPEARANCE_FLAT ),
pmProfile( PROFILE_SUNKEN ), vArrow( va ), boldDefText( bdt ), crLabelHighlight( crlh ), lvDark( lvd ),
defBtnIndicator( dbi ), sliderThumbs( st ), handles( h ), toolbarBorders( tbb ), lvExpander( lve ), lvLines( lvl ), menuIcons( ico ), borderSplitter( true ), popupmenuHighlightLevel(popuplvl)
#endif
#if TDE_VERSION >= 0x30200
isTransKicker( false ),
#endif
hover( HOVER_NONE ),
oldCursor( -1, -1 ),
formMode( false ),
hoverWidget( NULL ),
hoverSect( TQTC_NO_SECT ) {
    TQSettings s;

    contrast = s.readNumEntry( "/TQt/KDE/contrast", 7 );
    if ( contrast < 0 || contrast > 10 )
        contrast = 7;
#ifdef USE_SINGLE_STYLE

    borderButton = borderFrame = s.readBoolEntry( "/klearlookstyle/Settings/border", true );
    rounded = borderButton ? s.readBoolEntry( "/klearlookstyle/Settings/round", true ) : false;
    menuIcons = s.readBoolEntry( "/klearlookstyle/Settings/icons", true );
    darkMenubar = s.readBoolEntry( "/klearlookstyle/Settings/darkMenubar", true );
    popupmenuHighlightLevel = s.readNumEntry( "/klearlookstyle/Settings/popupmenuHighlightLevel", 3);

    TQString tmp = s.readEntry( "/klearlookstyle/Settings/toolbarBorders", TQString() );
    toolbarBorders = tmp.isEmpty()
                     ? TB_LIGHT
                     : qtc_to_tbar_border( tmp.latin1() );

    bool etched = s.readBoolEntry( "/klearlookstyle/Settings/etched", true );

    tmp = s.readEntry( "/klearlookstyle/Settings/sliderThumbs", TQString() );
    sliderThumbs = tmp.isEmpty()
                   ? etched ? GROOVE_SUNKEN : GROOVE_RAISED
               : qtc_to_groove( tmp.latin1() );

    tmp = s.readEntry( "/klearlookstyle/Settings/lvExpander", TQString() );
    lvExpander = tmp.isEmpty()
                 ? LV_EXP_ARR
                 : qtc_to_lv_expander( tmp.latin1() );

    tmp = s.readEntry( "/klearlookstyle/Settings/lvLines", TQString() );
    lvLines = tmp.isEmpty()
              ? LV_LINES_SOLID
              : qtc_to_lv_lines( tmp.latin1() );
              
    
    lvDark = s.readBoolEntry( "/klearlookstyle/Settings/lvDark", false );
    handles = qtc_to_groove( s.readEntry( "/klearlookstyle/Settings/sliderThumbs", DEF_HANDLE_STR ).latin1() );
    
    if ( GROOVE_NONE == handles )
        handles = GROOVE_RAISED;
        
    appearance = qtc_to_appearance(
        s.readEntry( "/klearlookstyle/Settings/appearance", DEF_APPEARANCE_STR ).latin1() );
    pmProfile = qtc_to_profile( s.readEntry( "/klearlookstyle/Settings/pm", DEF_PROFILE_STR ).latin1() );
    vArrow = s.readBoolEntry( "/klearlookstyle/Settings/vArrow", false );
    boldDefText = s.readBoolEntry( "/klearlookstyle/Settings/embolden", false );
    crLabelHighlight = s.readBoolEntry( "/klearlookstyle/Settings/crLabelHighlight", false );
    defBtnIndicator = qtc_to_ind(
        s.readEntry( "/klearlookstyle/Settings/defBtnIndicator", DEF_IND_STR ).latin1() );
        
    //if(!boldDefText && IND_NONE==defBtnIndicator)
    //    defBtnIndicator=IND_CORNER;
    
    borderSplitter = s.readBoolEntry( "/klearlookstyle/Settings/borderSplitter", false );
#endif

    if ( PROFILE_RAISED != pmProfile )
        shadeColors( tqApp->palette().active().highlight(), menuPbar );
    else
        shadeGradient( tqApp->palette().active().highlight(), menuPbar );
    shadeColors( tqApp->palette().active().background(), gray );
    shadeColors( tqApp->palette().active().button(), button );
}

void KlearlookStyle::applicationPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr ) {
    if (ceData.widgetObjectTypes.contains("TQApplication")) {
	TQApplication *app = reinterpret_cast<TQApplication*>(ptr);

	if ( !qstrcmp( app->argv() [ 0 ], "kicker" ) || !qstrcmp( app->argv() [ 0 ], "appletproxy" ) ) {
		themedApp = APP_KICKER;
	#if TDE_VERSION >= 0x30200
	
		isTransKicker = rounded && kickerIsTrans();
	#endif
	
	} else if ( !qstrcmp( app->argv() [ 0 ], "korn" ) ) {
		themedApp = APP_KORN;
	#if TDE_VERSION >= 0x30200
	
		isTransKicker = rounded && kickerIsTrans();
	#endif
	
	} else
		themedApp = qstrcmp( tqApp->argv() [ 0 ], "soffice.bin" ) ? APP_OTHER : APP_OPENOFFICE;
    }
}

void KlearlookStyle::polish( TQPalette &pal ) {
    int c = TQSettings().readNumEntry( "/TQt/KDE/contrast", 7 );
    bool newContrast = false;

    if ( c < 0 || c > 10 )
        c = 7;

    if ( c != contrast ) {
        contrast = c;
        newContrast = true;
    }

    if ( newContrast || gray[ NUM_SHADES ] != tqApp->palette().active().background() )
        shadeColors( tqApp->palette().active().background(), gray );

    if ( newContrast || button[ NUM_SHADES ] != tqApp->palette().active().button() )
        shadeColors( tqApp->palette().active().button(), button );

    if ( PROFILE_RAISED == pmProfile ) {
        if ( newContrast || menuPbar[ NUM_SHADES ] != tqApp->palette().active().highlight() )
            shadeColors( tqApp->palette().active().highlight(), menuPbar );
    } else
        if ( tqApp->palette().active().highlight() != menuPbar[ GRADIENT_BASE ] )
            shadeGradient( tqApp->palette().active().highlight(), menuPbar );

    const TQColorGroup &actGroup = pal.active(),
                                  &inactGroup = pal.inactive();
    const TQColor *use = backgroundColors( actGroup );
    TQColorGroup newAct( actGroup.foreground(), actGroup.button(),
        use[ 0 ], use[ 5 ], actGroup.mid(), actGroup.text(),
        actGroup.brightText(), actGroup.base(), actGroup.background() );

    newAct.setColor( TQColorGroup::Highlight, actGroup.color( TQColorGroup::Highlight ) );
    pal.setActive( newAct );

    use = backgroundColors( inactGroup );

    TQColorGroup newInact( inactGroup.foreground(), inactGroup.button(),
        use[ 0 ], use[ 5 ], inactGroup.mid(), inactGroup.text(),
        inactGroup.brightText(), inactGroup.base(), inactGroup.background() );

    newInact.setColor( TQColorGroup::Highlight, inactGroup.color( TQColorGroup::Highlight ) );
    pal.setInactive( newInact );
}

static const char * kdeToolbarWidget = "tde toolbar widget";

void KlearlookStyle::polish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr ) {
	if (ceData.widgetObjectTypes.contains("TQWidget")) {
		TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

		if ( ::tqt_cast<TQRadioButton *>( widget )
		|| ::tqt_cast<TQCheckBox *>( widget )
		|| ::tqt_cast<TQSpinWidget *>( widget )
		|| widget->inherits( "TQSplitterHandle" ) ) {
			widget->setMouseTracking( true );
		
			installObjectEventHandler(ceData, elementFlags, ptr, this);
		} else if ( ::tqt_cast<TQButton *>( widget ) || ::tqt_cast<TQComboBox *>( widget ) ||
				widget->inherits( "TQToolBarExtensionWidget" ) ) {
			widget->setBackgroundMode( TQWidget::PaletteBackground );
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( ::tqt_cast<TQMenuBar *>( widget )
			|| ::tqt_cast<TQToolBar *>( widget )
			|| ::tqt_cast<TQPopupMenu *>( widget ) )
			widget->setBackgroundMode( TQWidget::PaletteBackground );
			
		else if ( widget->inherits( "TDEToolBarSeparator" ) ) {
			widget->setBackgroundMode( TQWidget::NoBackground );
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( ::tqt_cast<TQScrollBar *>( widget ) ) {
			widget->setMouseTracking( true );
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->setBackgroundMode( TQWidget::NoBackground );
			
		} else if ( ::tqt_cast<TQSlider *>( widget ) || ::tqt_cast<TQHeader *>( widget ) ) {
			widget->setMouseTracking( true );
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( 0 == qstrcmp( widget->name(), kdeToolbarWidget ) ) {
			installObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->setBackgroundMode( TQWidget::NoBackground );  // We paint the whole background.
		}
	}
		
	TDEStyle::polish( ceData, elementFlags, ptr );
}
		
void KlearlookStyle::unPolish( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void *ptr ) {
	if (ceData.widgetObjectTypes.contains("TQWidget")) {
		TQWidget *widget = reinterpret_cast<TQWidget*>(ptr);

		if ( ::tqt_cast<TQRadioButton *>( widget ) ||
			::tqt_cast<TQCheckBox *>( widget ) ||
			::tqt_cast<TQSpinWidget *>( widget ) ||
			widget->inherits( "TQSplitterHandle" ) ) {
			widget->setMouseTracking( false );
		
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
		} else if ( ::tqt_cast<TQButton *>( widget ) || ::tqt_cast<TQComboBox *>( widget ) ||
				widget->inherits( "TQToolBarExtensionWidget" ) ) {
			widget->setBackgroundMode( TQWidget::PaletteButton );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( ::tqt_cast<TQMenuBar *>( widget ) ||
				::tqt_cast<TQToolBar *>( widget ) ||
				::tqt_cast<TQPopupMenu *>( widget ) )
			widget->setBackgroundMode( TQWidget::PaletteBackground );
			
		else if ( widget->inherits( "TDEToolBarSeparator" ) ) {
			widget->setBackgroundMode( PaletteBackground );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( ::tqt_cast<TQScrollBar *>( widget ) ) {
			widget->setMouseTracking( false );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->setBackgroundMode( TQWidget::PaletteButton );
			
		} else if ( ::tqt_cast<TQSlider *>( widget ) ||
				::tqt_cast<TQHeader *>( widget ) ) {
			widget->setMouseTracking( false );
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			
		} else if ( 0 == qstrcmp( widget->name(), kdeToolbarWidget ) ) {
			removeObjectEventHandler(ceData, elementFlags, ptr, this);
			widget->setBackgroundMode( PaletteBackground );
		}
	}

	TDEStyle::unPolish( ceData, elementFlags, ptr );
}

bool KlearlookStyle::objectEventHandler( const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, void* source, TQEvent *event ) {
	if (ceData.widgetObjectTypes.contains("TQObject")) {
		TQObject* object = reinterpret_cast<TQObject*>(source);

		if ( object->parent() && 0 == qstrcmp( object->name(), kdeToolbarWidget ) ) {
			// Draw background for custom widgets in the toolbar that have specified a "tde toolbar widget" name.
			if ( TQEvent::Paint == event->type() ) {
			TQWidget * widget = static_cast<TQWidget*>( object ),
				*parent = static_cast<TQWidget*>( object->parent() );
		#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS
			// Find the top-level toolbar of this widget, since it may be nested in other
			// widgets that are on the toolbar.
			int x_offset = widget->x(),
					y_offset = widget->y();
		
			while ( parent && parent->parent() && !qstrcmp( parent->name(), kdeToolbarWidget ) ) {
				x_offset += parent->x();
				y_offset += parent->y();
				parent = static_cast<TQWidget*>( parent->parent() );
			}
		
			TQRect pr( parent->rect() );
			bool horiz_grad = pr.width() < pr.height();
		
			// Check if the parent is a TQToolbar, and use its orientation, else guess.
			TQToolBar *toolbar = dynamic_cast<TQToolBar*>( parent );
		
			if ( toolbar )
				horiz_grad = toolbar->orientation() == TQt::Vertical;
		
			drawBevelGradient( parent->colorGroup().background(), true, 1, &TQPainter( widget ),
					TQRect( x_offset, y_offset, pr.width(), pr.height() ),
					horiz_grad, SHADE_BAR_LIGHT, SHADE_BAR_DARK );
		#else
		
			TQPainter( widget ).fillRect( widget->rect(), parent->colorGroup().background() );
		#endif
		
			return false;   // Now draw the contents
			}
		} else if ( object->inherits( "TDEToolBarSeparator" ) && TQEvent::Paint == event->type() ) {
			TQFrame * frame = dynamic_cast<TQFrame*>( object );
		
			if ( frame && TQFrame::NoFrame != frame->frameShape() ) {
			TQPainter painter( frame );
			if ( TQFrame::VLine == frame->frameShape() )
				drawPrimitive( PE_DockWindowSeparator, &painter, ceData, elementFlags,
				frame->rect(), frame->colorGroup(), Style_Horizontal );
			else if ( TQFrame::HLine == frame->frameShape() )
				drawPrimitive( PE_DockWindowSeparator, &painter, ceData, elementFlags,
				frame->rect(), frame->colorGroup() );
			else
				return false;
			return true; // been drawn!
			}
		}
		switch ( event->type() ) {
			case TQEvent::Enter:
			if ( object->isWidgetType() ) {
				hoverWidget = ( TQWidget * ) object;
				if ( hoverWidget && hoverWidget->isEnabled() ) {
				if ( redrawHoverWidget() ) {
					hoverWidget->repaint( false );
					if ( APP_KICKER == themedApp )
					hover = HOVER_NONE;
				}
				oldCursor = TQCursor::pos();
				} else
				hoverWidget = NULL;
			}
			break;
			case TQEvent::Leave:
			if ( hoverWidget && object == hoverWidget ) {
				oldCursor.setX( -1 );
				oldCursor.setY( -1 );
				hoverWidget = NULL;
				( ( TQWidget * ) object ) ->repaint( false );
			}
			break;
			case TQEvent::MouseMove:
			if ( hoverWidget && object->isWidgetType() ) {
				if ( redrawHoverWidget() ) {
				hoverWidget->repaint( false );
				if ( APP_KICKER == themedApp )
					hover = HOVER_NONE;
				}
				oldCursor = TQCursor::pos();
			}
			break;
			default:
			break;
		}
	}

	return TDEStyle::objectEventHandler( ceData, elementFlags, source, event );
}

void KlearlookStyle::drawLightBevelButton(
    TQPainter *p,
    const TQRect &r,
    const TQColorGroup &cg,
    TQStyle::SFlags flags,
    bool useGrad,
    ERound round,
    const TQColor &fill,
    const TQColor *custom,
    bool light ) const
{
    TQRect br( r );
    bool sunken = ( flags & ( TQStyle::Style_Down | TQStyle::Style_On | TQStyle::Style_Sunken ) );
    int dark = borderButton ? 4 : 5,
        c1   = sunken       ? dark : light ? 6 : 0;

    p->save();

    if ( !borderButton )
        br.addCoords( -1, -1, 1, 1 );

    if ( ( sunken && !borderButton ) || ( !sunken && flags & TQStyle::Style_Raised ) ) {
        p->setPen( custom ? custom[ c1 ] : gray[ c1 ] );
        if ( APPEARANCE_LIGHT_GRADIENT != appearance ) {
            int c2 = sunken ? 0 : dark;


            p->drawLine( br.x() + 1, br.y() + 2, br.x() + 1, br.y() + br.height() - 3 ); // left
            p->drawLine( br.x() + 1, br.y() + 1, br.x() + br.width() - 2, br.y() + 1 ); // top

            p->setPen( custom ? custom[ c2 ] : gray[ c2 ] );
            p->drawLine( br.x() + br.width() - 2, br.y() + 1,
                br.x() + br.width() - 2, br.y() + br.height() - 3 ); // right
            p->drawLine( br.x() + 1, br.y() + br.height() - 2,
                br.x() + br.width() - 2, br.y() + br.height() - 2 ); // bottom

            br.addCoords( 2, 2, -2, -2 );
        } else {
            p->drawLine( br.x() + 1, br.y() + 2, br.x() + 1, br.y() + br.height() - 2 ); // left
            p->drawLine( br.x() + 1, br.y() + 1, br.x() + br.width() - 2, br.y() + 1 ); // top

            br.addCoords( 2, 2, -1, -1 );
        }
    } else
        br.addCoords( 1, 1, -1, -1 );

    // fill
    if ( useGrad && APPEARANCE_FLAT != appearance ) {
        drawBevelGradient( fill.dark( 100 ), !sunken, 0, p,
            TQRect( br.left() - 1, br.top() - 1, br.width() + 2, br.height() + 2 ), flags & Style_Horizontal,
                sunken ?
                    SHADE_BEVEL_BUTTON_GRAD_LIGHT( appearance ) :
                        SHADE_BEVEL_BUTTON_GRAD_LIGHT( appearance ),
                   sunken ?
                        SHADE_BEVEL_BUTTON_GRAD_DARK( appearance ) :
                    SHADE_BEVEL_BUTTON_GRAD_DARK( appearance ) );
    } else
        p->fillRect( br, fill );

    if ( borderButton )
        if ( rounded && ROUNDED_NONE != round ) {
            bool wide = r.width() >= TQTC_MIN_BTN_SIZE,
                        tall = r.height() >= TQTC_MIN_BTN_SIZE;
            TQColor border( flags & Style_ButtonDefault && IND_FONT_COLOUR == defBtnIndicator & flags & Style_Enabled
                           ? cg.text() : custom ? custom[ 5 ] : gray[ 5 ] );

            p->setPen( border.light(80) );
            switch ( round ) {
                case ROUNDED_ALL:
                    p->drawLine( r.x() + 2, r.y(), r.x() + r.width() - 3, r.y() );
                    p->drawLine( r.x() + 2, r.y() + r.height() - 1, r.x() + r.width() - 3,
                        r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 3 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 2, r.x() + r.width() - 1,
                        r.y() + r.height() - 3 );
                    if ( tall && wide ) {
                        p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !( tall && wide ) ) {
                        p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                        p->drawLine( r.x(), r.y() + r.height() - 2, r.x() + 1, r.y() + r.height() - 1 );
                        p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1,
                            r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( tall && wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                            p->drawPoint( r.x(), r.y() );
                            p->drawPoint( r.x() + r.width() - 1, r.y() );
                            p->drawPoint( r.x(), r.y() + r.height() - 1 );
                            p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;
                case ROUNDED_TOP:
                    p->drawLine( r.x() + 2, r.y(), r.x() + r.width() - 3, r.y() );
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1,
                        r.x() + r.width() - 2, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 1 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 2,
                        r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    if ( wide ) {
                        p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !wide ) {
                        p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                    }
                    if ( !formMode ) {
                        if ( wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() );
                        p->drawPoint( r.x() + r.width() - 1, r.y() );
                    }
                    break;
                case ROUNDED_BOTTOM:
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 2, r.y() );
                    p->drawLine( r.x() + 2, r.y() + r.height() - 1,
                        r.x() + r.width() - 3, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y(), r.x(), r.y() + r.height() - 3 );
                    p->drawLine( r.x() + r.width() - 1, r.y(),
                        r.x() + r.width() - 1, r.y() + r.height() - 3 );
                    if ( wide ) {
                        p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !wide ) {
                        p->drawLine( r.x(), r.y() + r.height() - 2, r.x() + 1, r.y() + r.height() - 1 );
                        p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1,
                            r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() + r.height() - 1 );
                        p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;
                case ROUNDED_LEFT:
                    p->drawLine( r.x() + 2, r.y(), r.x() + r.width() - 2, r.y() );
                    p->drawLine( r.x() + 2, r.y() + r.height() - 1,
                        r.x() + r.width() - 2, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 3 );
                    p->drawLine( r.x() + r.width() - 1, r.y(), r.x() + r.width() - 1,
                        r.y() + r.height() - 1 );
                    if ( tall ) {
                        p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !tall ) {
                        p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        p->drawLine( r.x(), r.y() + r.height() - 2,
                            r.x() + 1, r.y() + r.height() - 1 );
                    }
                    if ( !formMode ) {
                        if ( tall )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() );
                        p->drawPoint( r.x(), r.y() + r.height() - 1 );
                    }
                    break;
                case ROUNDED_RIGHT:
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 3, r.y() );
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1,
                        r.x() + r.width() - 3, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y(), r.x(), r.y() + r.height() - 1 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 2,
                        r.x() + r.width() - 1, r.y() + r.height() - 3 );
                    if ( tall ) {
                        p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !tall ) {
                        p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                        p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1,
                            r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( tall )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x() + r.width() - 1, r.y() );
                        p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;
                default:
                    break;
            }
        } else {
            p->setPen( flags & Style_ButtonDefault &&
                       IND_FONT_COLOUR == defBtnIndicator ?
                       cg.text() : custom ? custom[ 5 ] : gray[ 5 ] );
            p->setBrush( NoBrush );
            p->drawRect( r );
        }

    p->restore();
}
void KlearlookStyle::drawLightBevel(
    TQPainter *p,
    const TQRect &r,
    const TQColorGroup &cg,
    TQStyle::SFlags flags,
    bool useGrad,
    ERound round,
    const TQColor &fill,
    const TQColor *custom,
    bool light ) const
{
    TQRect br( r );
    bool sunken = ( flags & ( TQStyle::Style_Down | TQStyle::Style_On | TQStyle::Style_Sunken ) );
    int dark = borderButton ? 4 : 5, c1 = sunken ? dark : light ? 6 : 0;

    p->save();

    if ( !borderButton )
        br.addCoords( -1, -1, 1, 1 );

    if ( ( sunken && !borderButton ) || ( !sunken && flags & TQStyle::Style_Raised ) ) {
        p->setPen( custom ? custom[ c1 ] : gray[ c1 ] );
        if ( APPEARANCE_LIGHT_GRADIENT != appearance ) {
            int c2 = sunken ? 0 : dark;

            p->drawLine( br.x() + 1, br.y() + 2, br.x() + 1, br.y() + br.height() - 3 ); // left
            p->drawLine( br.x() + 1, br.y() + 1, br.x() + br.width() - 2, br.y() + 1 ); // top

            p->setPen( custom ? custom[ c2 ] : gray[ c2 ] );
            p->drawLine( br.x() + br.width() - 2, br.y() + 1,
                br.x() + br.width() - 2, br.y() + br.height() - 3 ); // right
            p->drawLine( br.x() + 1, br.y() + br.height() - 2,
                br.x() + br.width() - 2, br.y() + br.height() - 2 ); // bottom

            br.addCoords( 2, 2, -2, -2 );
        } else {
            p->drawLine( br.x() + 1, br.y() + 2, br.x() + 1, br.y() + br.height() - 2 ); // left
            p->drawLine( br.x() + 1, br.y() + 1, br.x() + br.width() - 2, br.y() + 1 ); // top

            br.addCoords( 2, 2, -1, -1 );
        }
    } else
        br.addCoords( 1, 1, -1, -1 );

    // fill
    if ( useGrad && APPEARANCE_FLAT != appearance ) {
        drawBevelGradient( fill, !sunken, 0, p,
            TQRect( br.left() - 1, br.top() - 1, br.width() + 2, br.height() + 2 ),
                flags & Style_Horizontal,
                sunken ?
                    SHADE_BEVEL_GRAD_SEL_LIGHT( appearance ) :
                    SHADE_BEVEL_GRAD_LIGHT( appearance ),
                sunken ?
                    SHADE_BEVEL_GRAD_SEL_DARK( appearance ) :
                    SHADE_BEVEL_GRAD_DARK( appearance ) );
    } else {
        p->fillRect( br, fill );
    }

    if ( borderButton )
        if ( rounded && ROUNDED_NONE != round ) {
            bool wide = r.width() >= TQTC_MIN_BTN_SIZE,
                        tall = r.height() >= TQTC_MIN_BTN_SIZE;

            TQColor border = menuPbar[ GRADIENT_BASE ].dark( 130 );
            
            p->setPen( border );

            switch ( round ) {
                case ROUNDED_ALL:
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 2, r.y() ); // top
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1, r.x() + r.width() - 2, r.y() + r.height() - 1 ); // bottom
                    p->drawLine( r.x(),r.y() + 1, r.x(),r.y() + r.height() - 2 ); // left
                    p->drawLine( r.x() + r.width() - 1, r.y() + 1, r.x() + r.width() - 1, r.y() + r.height() - 2 ); // right

                    //p->drawLine( r.x() + 2, r.y() + r.height() - 1, r.x() + r.width() - 3, r.y() + r.height() - 1 );

                    //p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 3 );
                    //p->drawLine( r.x() + r.width() - 1, r.y() + 2, r.x() + r.width() - 1, r.y() + r.height() - 3 );

                    if ( tall && wide ) {
                        //p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        //p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        //p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        //p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !( tall && wide ) ) {
                        //p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        //p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                        //p->drawLine( r.x(), r.y() + r.height() - 2, r.x() + 1, r.y() + r.height() - 1 );
                        //p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1, r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( tall && wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );

                        //p->drawPoint( r.x(), r.y() );
                        //p->drawPoint( r.x() + r.width() - 1, r.y() );
                        //p->drawPoint( r.x(), r.y() + r.height() - 1 );
                        //p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;

                case ROUNDED_TOP:
                    p->drawLine( r.x() + 2, r.y(), r.x() + r.width() - 3, r.y() );
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1, r.x() + r.width() - 2, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 1 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 2, r.x() + r.width() - 1, r.y() + r.height() - 1 );

                    if ( wide ) {
                        p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !wide ) {
                        p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                    }
                    if ( !formMode ) {
                        if ( wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() );
                        p->drawPoint( r.x() + r.width() - 1, r.y() );
                    }
                    break;
                case ROUNDED_BOTTOM:
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 2, r.y() );
                    p->drawLine( r.x() + 2, r.y() + r.height() - 1, r.x() + r.width() - 3, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y(), r.x(), r.y() + r.height() - 3 );
                    p->drawLine( r.x() + r.width() - 1, r.y(), r.x() + r.width() - 1, r.y() + r.height() - 3 );
                    if ( wide ) {
                        p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !wide ) {
                        p->drawLine( r.x(), r.y() + r.height() - 2, r.x() + 1, r.y() + r.height() - 1 );
                        p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1,
                            r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( wide )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() + r.height() - 1 );
                        p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;
                case ROUNDED_LEFT:
                    p->drawLine( r.x() + 2, r.y(), r.x() + r.width() - 2, r.y() );
                    p->drawLine( r.x() + 2, r.y() + r.height() - 1,
                        r.x() + r.width() - 2, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 2, r.x(), r.y() + r.height() - 3 );
                    p->drawLine( r.x() + r.width() - 1, r.y(), r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    if ( tall ) {
                        p->drawPoint( r.x() + 1, r.y() + r.height() - 2 );
                        p->drawPoint( r.x() + 1, r.y() + 1 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !tall ) {
                        p->drawLine( r.x(), r.y() + 1, r.x() + 1, r.y() );
                        p->drawLine( r.x(), r.y() + r.height() - 2, r.x() + 1, r.y() + r.height() - 1 );
                    }
                    if ( !formMode ) {
                        if ( tall )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x(), r.y() );
                        p->drawPoint( r.x(), r.y() + r.height() - 1 );
                    }
                    break;
                case ROUNDED_RIGHT:
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 3, r.y() );
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1,
                        r.x() + r.width() - 3, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y(), r.x(), r.y() + r.height() - 1 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 2, r.x() + r.width() - 1,
                        r.y() + r.height() - 3 );
                    if ( tall ) {
                        p->drawPoint( r.x() + r.width() - 2, r.y() + 1 );
                        p->drawPoint( r.x() + r.width() - 2, r.y() + r.height() - 2 );
                        p->setPen( midColor( border, cg.background() ) );
                    }
                    if ( !formMode || !tall ) {
                        p->drawLine( r.x() + r.width() - 2, r.y(), r.x() + r.width() - 1, r.y() + 1 );
                        p->drawLine( r.x() + r.width() - 2, r.y() + r.height() - 1,
                            r.x() + r.width() - 1, r.y() + r.height() - 2 );
                    }
                    if ( !formMode ) {
                        if ( tall )
                            p->setPen( cg.background() );
                        else
                            p->setPen( midColor( custom ? custom[ 3 ] : gray[ 3 ], cg.background() ) );
                        p->drawPoint( r.x() + r.width() - 1, r.y() );
                        p->drawPoint( r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    }
                    break;
                default:
                    break;
            }
        } else {
            p->setPen( flags & Style_ButtonDefault &&
                IND_FONT_COLOUR == defBtnIndicator ? cg.text() : custom ? custom[ 5 ] : gray[ 5 ] );
            p->setBrush( NoBrush );
            p->drawRect( r );
        }

    p->restore();
}

void KlearlookStyle::drawArrow( TQPainter *p, const TQRect &r, const TQColorGroup &cg, TQStyle::SFlags flags,
                                TQStyle::PrimitiveElement pe, bool small, bool checkActive ) const {
    TQPointArray a;
    const TQColor &col = flags & Style_Enabled
                        ? checkActive && flags & Style_Active
                        ? cg.highlightedText()
                        : cg.text()
                                : cg.mid();

    if ( vArrow )
        if ( small )
            switch ( pe ) {
                case TQStyle::PE_ArrowUp:
                    a.setPoints( 7, 2, 1, 2, 0, 0, -2, -2, 0, -2, 1, -2, 0, 2, 0 );
                    break;
                case TQStyle::PE_ArrowDown:
                    a.setPoints( 7, 2, -1, 2, 0, 0, 2, -2, 0, -2, -1, -2, 0, 2, 0 );
                    break;
                case TQStyle::PE_ArrowRight:
                    a.setPoints( 7, 1, -2, 0, -2, -2, 0, 0, 2, 1, 2, 0, 2, 0, -2 );
                    break;
                case TQStyle::PE_ArrowLeft:
                    a.setPoints( 7, -1, -2, 0, -2, 2, 0, 0, 2, -1, 2, 0, 2, 0, -2 );
                    break;
                default:
                    return ;
            }
        else
            switch ( pe ) {
                case TQStyle::PE_ArrowUp:
                    a.setPoints( 7, 3, 1, 0, -2, -3, 1, -2, 2, -1, 1, 1, 1, 2, 2 );
                    break;
                case TQStyle::PE_ArrowDown:
                    a.setPoints( 7, 3, -1, 0, 2, -3, -1, -2, -2, -1, -1, 1, -1, 2, -2 );
                    break;
                case TQStyle::PE_ArrowRight:
                    a.setPoints( 7, -1, -3, 2, 0, -1, 3, -2, 2, -1, 1, -1, -1, -2, -2 );
                    break;
                case TQStyle::PE_ArrowLeft:
                    a.setPoints( 7, 1, -3, -2, 0, 1, 3, 2, 2, 1, 1, 1, -1, 2, -2 );
                    break;
                default:
                    return ;
            }
    else
        if ( small )
            switch ( pe ) {
                case TQStyle::PE_ArrowUp:
                    a.setPoints( 4, 2, 0, 0, -2, -2, 0, 2, 0 );
                    break;
                case TQStyle::PE_ArrowDown:
                    a.setPoints( 4, 2, 0, 0, 2, -2, 0, 2, 0 );
                    break;
                case TQStyle::PE_ArrowRight:
                    a.setPoints( 4, 0, -2, -2, 0, 0, 2, 0, -2 );
                    break;
                case TQStyle::PE_ArrowLeft:
                    a.setPoints( 4, 0, -2, 2, 0, 0, 2, 0, -2 );
                    break;
                default:
                    return ;
            }
        else
            switch ( pe ) {
                case TQStyle::PE_ArrowUp:
                    a.setPoints( 4, 3, 1, 0, -2, -3, 1, 3, 1 );
                    break;
                case TQStyle::PE_ArrowDown:
                    a.setPoints( 4, 3, -1, 0, 2, -3, -1, 3, -1 );
                    break;
                case TQStyle::PE_ArrowRight:
                    a.setPoints( 4, -1, -3, 2, 0, -1, 3, -1, -3 );
                    break;
                case TQStyle::PE_ArrowLeft:
                    a.setPoints( 4, 1, -3, -2, 0, 1, 3, 1, -3 );
                    break;
                default:
                    return ;
            }

    if ( a.isNull() )
        return ;

    p->save();
    a.translate( ( r.x() + ( r.width() >> 1 ) ), ( r.y() + ( r.height() >> 1 ) ) );
    p->setBrush( col );
    p->setPen( col );
    p->drawPolygon( a );
    p->restore();
}

void KlearlookStyle::drawPrimitiveMenu( PrimitiveElement pe, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r, const TQColorGroup &cg,
                                        SFlags flags, const TQStyleOption &data ) const {
    switch ( pe ) {
        case PE_CheckMark:
            if ( flags & Style_On || !( flags & Style_Off ) )      // !(flags&Style_Off) is for tri-state
            {
                TQPointArray check;
                int x = r.center().x() - 3,
                        y = r.center().y() - 3;

                check.setPoints( 6,
                                 x, y + 2,
                                 x + 2, y + 4,
                                 x + 6, y,
                                 x + 6, y + 2,
                                 x + 2, y + 6,
                                 x, y + 4 );

                if ( flags & Style_On ) {
                    if ( flags & Style_Active ) {
                        p->setBrush( cg.highlightedText() );
                        p->setPen( cg.highlightedText() );
                    } else {
                        p->setBrush( cg.text() );
                        p->setPen( cg.text() );
                    }
                } else {
                    p->setBrush( cg.text() );
                    p->setPen( cg.text() );
                }
                p->drawPolygon( check );
            }
            break;

        default:
            TDEStyle::drawPrimitive( pe, p, ceData, elementFlags, r, cg, flags, data );
    }
}

void KlearlookStyle::drawPrimitive( PrimitiveElement pe, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r, const TQColorGroup &cg,
                                    SFlags flags, const TQStyleOption &data ) const {
    int x, y, w, h;

    r.rect(&x, &y, &w, &h);
                                    
    switch ( pe ) {
        case PE_HeaderSection: {
                const TQColor * use = buttonColors( cg );


                if ( APP_KICKER == themedApp ) {
                    if ( flags & Style_Down )
                        flags = ( ( flags | Style_Down ) ^ Style_Down ) | Style_Sunken;
                    flags |= Style_Enabled;
#if TDE_VERSION >= 0x30200
#if TDE_VERSION >= 0x30400

                    if ( HOVER_KICKER == hover && hoverWidget )   //  && hoverWidget==p->device())
                        flags |= Style_MouseOver;
#endif

                    formMode = isTransKicker;
#endif

                    drawLightBevelButton( p, r, cg, flags | Style_Horizontal,
                        true, ROUNDED_ALL, getFill( flags, use ), use );
#if TDE_VERSION >= 0x30200

                    formMode = false;
#endif

                } else {
                    flags = ( ( flags | Style_Sunken ) ^ Style_Sunken ) | Style_Raised;

                    if ( TQTC_NO_SECT != hoverSect && HOVER_HEADER == hover && hoverWidget ) {
                        TQHeader * hd = dynamic_cast<TQHeader *>( hoverWidget );

                        if ( hd && hd->isClickEnabled( hoverSect ) && r == hd->sectionRect( hoverSect ) )
                            flags |= Style_MouseOver;
                    }
                    drawLightBevelButton( p, r, cg, flags | Style_Horizontal,
                        true, ROUNDED_NONE, getFill( flags, use ), use );
                }
                break;
            }
        case PE_HeaderArrow:
            drawArrow( p, r, cg, flags, flags & Style_Up ? PE_ArrowUp : PE_ArrowDown );
            break;
        case PE_ButtonCommand:
        case PE_ButtonBevel:
        case PE_ButtonTool:
        case PE_ButtonDropDown: {
                const TQColor *use = buttonColors( cg );

                if ( !( flags & TQStyle::Style_Sunken ) )   // If its not sunken, its raised-don't want flat buttons.
                    flags |= TQStyle::Style_Raised;

                drawLightBevelButton( p, r, cg, flags | Style_Horizontal, true,
                                      r.width() < 16 || r.height() < 16
#if TDE_VERSION >= 0x30200
                                      || ( APP_KORN == themedApp && isTransKicker && PE_ButtonTool == pe )
#endif
                                      ? ROUNDED_NONE : ROUNDED_ALL,
                                      getFill( flags, use ), use );
                break;
            }
        case PE_ButtonDefault:
            switch ( defBtnIndicator ) {
                case IND_BORDER:
                    p->setBrush( NoBrush );
                    if ( rounded )   // borderButton)      CPD Only use color[4] for rounded def buttons!
                    {
                        const TQColor * use = buttonColors( cg );

                        p->setPen( use[ 4 ] );
                        int offset = r.width() >= TQTC_MIN_BTN_SIZE && r.height() >= TQTC_MIN_BTN_SIZE ? 4 : 3;

                        p->drawLine( r.x() + offset, r.y(), r.x() + r.width() - ( 1 + offset ), r.y() );
                        p->drawLine( r.x() + offset, r.y() + r.height() - 1,
                            r.x() + r.width() - ( 1 + offset ), r.y() + r.height() - 1 );
                        p->drawLine( r.x(), r.y() + offset, r.x(), r.y() + r.height() - ( 1 + offset ) );
                        p->drawLine( r.x() + r.width() - 1, r.y() + offset,
                            r.x() + r.width() - 1, r.y() + r.height() - ( 1 + offset ) );
                    } else {
                        p->setPen( cg.text() );
                        p->drawRect( r );
                    }
                    break;
                case IND_CORNER: {
                        const TQColor *use = buttonColors( cg );
                        TQPointArray points;
                        bool sunken = flags & Style_Down || flags & TQStyle::Style_Sunken;
                        int offset = sunken ? 4 : 3;

                        points.setPoints( 3, r.x() + offset, r.y() + offset, r.x() + offset + 6, r.y() + offset,
                                          r.x() + offset, r.y() + offset + 6 );

                        p->setBrush( use[ sunken ? 0 : borderButton ? 4 : 5 ] );
                        p->setPen( use[ sunken ? 0 : borderButton ? 4 : 5 ] );
                        p->drawPolygon( points );
                        break;
                    }
                default:
                    break;
            }
            break;
        case PE_IndicatorMask:
            if ( rounded ) {
                p->fillRect( r, color0 );
                p->fillRect( r.x() + 1, r.y() + 1, r.width() - 2, r.height() - 2, color1 );
                p->setPen( color1 );
                p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 2, r.y() );
                p->drawLine( r.x() + 1, r.y() + r.height() - 1, r.x() + r.width() - 2, r.y() + r.height() - 1 );
                p->drawLine( r.x(), r.y() + 1, r.x(), r.y() + r.height() - 2 );
                p->drawLine( r.x() + r.width() - 1, r.y() + 1, r.x() + r.width() - 1, r.y() + r.height() - 2 );
            } else
                p->fillRect( r, color1 );
            break;
        case PE_CheckMark:
            if ( flags & Style_On || !( flags & Style_Off ) )      // !(flags&Style_Off) is for tri-state
            {
                TQPointArray check;
                int x = r.center().x() - 3,
                        y = r.center().y() - 3;

                check.setPoints( 6,
                                 x, y + 2,
                                 x + 2, y + 4,
                                 x + 6, y,
                                 x + 6, y + 2,
                                 x + 2, y + 6,
                                 x, y + 4 );
                p->setBrush( flags & Style_On
                             ? flags & Style_Enabled
                             ? flags & Style_Selected
                             ? cg.highlightedText()
                             : cg.text()
                                     : cg.mid()
                                     : cg.light() );
                p->setPen( flags & Style_Enabled
                           ? flags & Style_Selected
                           ? cg.highlightedText()
                           : cg.text()
                                   : cg.mid() );
                p->drawPolygon( check );
            }
            break;
        case PE_CheckListController: {
                TQCheckListItem *item = data.checkListItem();

                if ( item ) {
                    TQListView * lv = item->listView();
                    int x = r.x(), y = r.y(), w = r.width(), h = r.height(), marg = lv->itemMargin();

                    p->setPen( TQPen( flags & Style_Enabled ? cg.text()
                                     : lv->palette().color( TQPalette::Disabled, TQColorGroup::Text ) ) );

                    if ( flags & Style_Selected && !lv->rootIsDecorated() &&
                         !( ( item->parent() && 1 == item->parent() ->rtti() &&
                         TQCheckListItem::Controller == ( ( TQCheckListItem* ) item->parent() ) ->type() ) )) {
                            p->fillRect( 0, 0, x + marg + w + 4, item->height(),
                                cg.brush( TQColorGroup::Highlight ) );
                            if ( item->isEnabled() )
                                p->setPen( TQPen( cg.highlightedText() ) );
                    }

                    if ( flags & Style_NoChange )
                        p->setBrush( cg.brush( TQColorGroup::Button ) );
                    p->drawRect( x + marg + 2, y + 4 + 2, w - 7, h - 8 );
                    p->drawRect( x + marg, y + 4, w - 7, h - 8 );
                }
                break;
            }
        case PE_CheckListIndicator: {
                TQCheckListItem *item = data.checkListItem();

                if ( item ) {
                    TQListView * lv = item->listView();

                    p->setPen( TQPen( flags & Style_Enabled ? cg.text()
                                     : lv->palette().color( TQPalette::Disabled, TQColorGroup::Text ), 2 ) );
                    if ( flags & Style_Selected ) {
                        flags -= Style_Selected;
                        if ( !lv->rootIsDecorated() &&
                             !( ( item->parent() && 1 == item->parent() ->rtti() &&
                             TQCheckListItem::Controller ==
                             ( ( TQCheckListItem* ) item->parent() ) ->type() ) ) ) {
                            p->fillRect( 0, 0, r.x() + lv->itemMargin() + r.width() + 4, item->height(),
                                         cg.brush( TQColorGroup::Highlight ) );
                            if ( item->isEnabled() ) {
                                p->setPen( TQPen( cg.highlightedText(), 2 ) );
                                flags += Style_Selected;
                            }
                        }
                    }

                    if ( flags & Style_NoChange )
                        p->setBrush( cg.brush( TQColorGroup::Button ) );
                    p->drawRect( r.x() + lv->itemMargin(), r.y() + 2, r.width() - 4, r.width() - 4 );
                    if ( flags & TQStyle::Style_On || !( flags & Style_Off ) )
                        drawPrimitive( PE_CheckMark, p, ceData, elementFlags, TQRect( r.x() + lv->itemMargin(),
                            r.y() + 2, r.width() - 4, r.width() - 4 ), cg, flags );
                }
                break;
            }
        case PE_Indicator: {
                const TQColor *use = buttonColors( cg );
                bool on = flags & TQStyle::Style_On || !( flags & Style_Off );

                if ( APPEARANCE_FLAT != appearance )
                    drawPrimitive( PE_ButtonTool, p, ceData, elementFlags, r, cg, flags );
                else {
                    p->fillRect( r.x() + 1, r.y() + 2, TQTC_CHECK_SIZE - 2, TQTC_CHECK_SIZE - 2,
                                 flags & Style_Enabled ? cg.base() : cg.background() );
                    p->setPen( use[ 4 ] );
                    p->drawLine( r.x() + 1, r.y() + TQTC_CHECK_SIZE - 1, r.x() + 1, r.y() + 1 );
                    p->drawLine( r.x() + 1, r.y() + 1, r.x() + TQTC_CHECK_SIZE - 2, r.y() + 1 );
                }
                p->setPen( use[ 5 ] );
                p->setBrush( NoBrush );
                if ( rounded ) {
                    p->drawLine( r.x() + 1, r.y(), r.x() + r.width() - 2, r.y() );
                    p->drawLine( r.x() + 1, r.y() + r.height() - 1, r.x() + r.width() - 2, r.y() + r.height() - 1 );
                    p->drawLine( r.x(), r.y() + 1, r.x(), r.y() + r.height() - 2 );
                    p->drawLine( r.x() + r.width() - 1, r.y() + 1, r.x() + r.width() - 1, r.y() + r.height() - 2 );

                    p->setPen( midColor( use[ 3 ], cg.background() ) );
                    p->drawPoint( r.x(), r.y() );
                    p->drawPoint( r.x(), r.y() + r.width() - 1 );
                    p->drawPoint( r.x() + r.height() - 1, r.y() );
                    p->drawPoint( r.x() + r.height() - 1, r.y() + r.width() - 1 );
                } else if ( APPEARANCE_FLAT == appearance || borderButton )
                    p->drawRect( r.x(), r.y(), TQTC_CHECK_SIZE, TQTC_CHECK_SIZE );

                if ( on )
                    drawPrimitive( PE_CheckMark, p, ceData, elementFlags, r, cg, flags );
                break;
            }
        case PE_CheckListExclusiveIndicator: {
                TQCheckListItem *item = data.checkListItem();

                if ( item ) {
                    const TQColor & bgnd = cg.background(),
                                          &on = flags & Style_Enabled
                                                ? cg.text()
                                                : cg.mid();
                    bool set
                        = flags & TQStyle::Style_On;
                    TQPointArray outer,
                    inner,
                    aa;
                    int x = r.x(), y = r.y() + 2;

                    outer.setPoints( 24, x, y + 8, x, y + 4, x + 1, y + 3, x + 1, y + 2,
                                     x + 2, y + 1, x + 3, y + 1, x + 4, y, x + 8, y,
                                     x + 9, y + 1, x + 10, y + 1, x + 11, y + 2, x + 11, y + 3,
                                     x + 12, y + 4, x + 12, y + 8, x + 11, y + 9, x + 11, y + 10,
                                     x + 10, y + 11, x + 9, y + 11, x + 8, y + 12, x + 4, y + 12,
                                     x + 3, y + 11, x + 2, y + 11, x + 1, y + 10, x + 1, y + 9 );
                    inner.setPoints( 20, x + 1, y + 8, x + 1, y + 4, x + 2, y + 3, x + 2, y + 2,
                                     x + 3, y + 2, x + 4, y + 1, x + 8, y + 1, x + 9, y + 2,
                                     x + 10, y + 2, x + 10, y + 3, x + 11, y + 4, x + 11, y + 8,
                                     x + 10, y + 9, x + 10, y + 10, x + 9, y + 10, x + 8, y + 11,
                                     x + 4, y + 11, x + 3, y + 10, x + 2, y + 10, x + 2, y + 9 );
                    aa.setPoints( 16, x + 2, y + 4, x + 4, y + 2, x + 8, y + 2, x + 10, y + 4,
                                  x + 10, y + 8, x + 8, y + 10, x + 4, y + 10, x + 2, y + 8,
                                  x, y + 3, x + 3, y, x + 9, y, x + 12, y + 3,
                                  x + 12, y + 9, x + 9, y + 12, x + 3, y + 12, x, y + 9 );
                    p->setBrush( on );
                    p->drawPolyline( outer );
                    p->drawPolyline( inner );
                    p->setPen( midColor( on, bgnd, 1.5 ) );
                    p->drawPoints( aa );

                    if ( set
                           ) {
                            p->setPen( midColor( on, bgnd ) );
                            p->drawLine( x + 5, y + 4, x + 7, y + 4 );
                            p->drawLine( x + 5, y + 8, x + 7, y + 8 );
                            p->drawLine( x + 4, y + 5, x + 4, y + 7 );
                            p->drawLine( x + 8, y + 5, x + 8, y + 7 );
                            p->setBrush( on );
                            p->setPen( NoPen );
                            p->drawRect( x + 5, y + 5, 3, 3 );
                        }
                }
                break;
            }
        case PE_ExclusiveIndicator:
        case PE_ExclusiveIndicatorMask: {
                int x = r.x(), y = r.y();
                TQPointArray outer;
                outer.setPoints( 24, x, y + 8, x, y + 4, x + 1, y + 3, x + 1, y + 2,
                                 x + 2, y + 1, x + 3, y + 1, x + 4, y, x + 8, y,
                                 x + 9, y + 1, x + 10, y + 1, x + 11, y + 2, x + 11, y + 3,
                                 x + 12, y + 4, x + 12, y + 8, x + 11, y + 9, x + 11, y + 10,
                                 x + 10, y + 11, x + 9, y + 11, x + 8, y + 12, x + 4, y + 12,
                                 x + 3, y + 11, x + 2, y + 11, x + 1, y + 10, x + 1, y + 9 );

                if ( PE_ExclusiveIndicatorMask == pe ) {
                    p->fillRect( r, color0 );
                    p->setPen( TQt::color1 );
                    p->setBrush( TQt::color1 );
                    p->drawPolygon( outer );
                } else {
                    TQPointArray shadow;
                    const TQColor &bgnd = flags & Style_Enabled ? cg.base() : cg.background(),
                                         &on = flags & Style_Enabled
                                               ? flags & Style_Selected
                                               ? cg.highlightedText()
                                               : cg.text()
                                                       : cg.mid();
                    TQColor indBgnd = bgnd;
                    const TQColor *use = buttonColors( cg );
                    TQColor leftShadowColor,
                    rightShadowColor,
                    outerLeftColor,
                    outerRightColor;
                    bool set
                        = flags & TQStyle::Style_On;

                    if ( APPEARANCE_FLAT != appearance && !borderButton )
                        shadow.setPoints( 14, x + 1, y + 10, x + 1, y + 9, x, y + 8, x, y + 4,
                                          x + 1, y + 3, x + 1, y + 2, x + 2, y + 1, x + 3, y + 1,
                                          x + 4, y, x + 8, y, x + 9, y + 1, x + 10, y + 1,
                                          x + 11, y + 2, x + 11, y + 3 );
                    else
                        shadow.setPoints( 9, x + 2, y + 11, x + 2, y + 9, x + 1, y + 8, x + 1, y + 4,
                                          x + 2, y + 3, x + 2, y + 2, x + 3, y + 2, x + 4, y + 1,
                                          x + 8, y + 1 );

                    p->fillRect( r, crLabelHighlight && flags & Style_MouseOver
                                 ? TQColor(cg.background().light( TQTC_HIGHLIGHT_FACTOR )) : cg.background() );

                    if ( APPEARANCE_FLAT != appearance ) {
                        indBgnd = getFill( flags, use );
                        p->setClipRegion( TQRegion( outer ) );
                        drawBevelGradient( indBgnd, !set, 0, p,
                            TQRect( x + 1, y + 1, r.width() - 2, r.height() - 2 ), true,
                            set ? SHADE_BEVEL_GRAD_SEL_LIGHT( appearance ) : SHADE_BEVEL_GRAD_LIGHT( appearance ),
                            set ? SHADE_BEVEL_GRAD_SEL_DARK( appearance ) : SHADE_BEVEL_GRAD_DARK( appearance ) );

                        p->setClipping( false );

                        if ( ( !set
                                && !( flags & Style_Down ) ) || !borderButton ) {
                            leftShadowColor = set
                                              ? !borderButton ? use[ 5 ] : use[ 4 ] : use[ 0 ];
                            p->setPen( leftShadowColor );
                            p->drawPolyline( shadow );

                            if ( APPEARANCE_LIGHT_GRADIENT == appearance )
                                rightShadowColor = indBgnd;
                            else {
                                if ( !borderButton )
                                    shadow.setPoints( 10, x + 12, y + 4, x + 12, y + 8, x + 11, y + 9,
                                                      x + 11, y + 10, x + 10, y + 11, x + 9, y + 11,
                                                      x + 8, y + 12, x + 4, y + 12, x + 3, y + 11,
                                                      x + 2, y + 11 );
                                else
                                    shadow.setPoints( 9, x + 10, y + 2, x + 10, y + 3, x + 11, y + 4,
                                                      x + 11, y + 8, x + 10, y + 9, x + 10, y + 10,
                                                      x + 9, y + 10, x + 8, y + 11, x + 4, y + 11 );
                                rightShadowColor = set
                                                       ? use[ 0 ] : !borderButton ? use[ 5 ] : use[ 4 ];
                                p->setPen( rightShadowColor );
                                p->drawPolyline( shadow );
                            }
                        }
                        else
                            leftShadowColor = rightShadowColor = indBgnd;
                    } else {
                        rightShadowColor = bgnd;
                        p->setBrush( bgnd );
                        p->setPen( bgnd );
                        p->drawEllipse( x, y, TQTC_RADIO_SIZE, TQTC_RADIO_SIZE );
                        p->setPen( use[ 4 ] );
                        leftShadowColor = use[ 4 ];
                        p->drawPolyline( shadow );
                    }

                    if ( APPEARANCE_FLAT == appearance || borderButton ) {
                        p->setPen( use[ 5 ] );
                        p->drawPolyline( outer );
                        shade( use[ 5 ], &outerRightColor, 1.1 );
                    } else {
                        shade( leftShadowColor, &outerLeftColor, 1.1 );
                        shade( rightShadowColor, &outerRightColor, 1.1 );
                    }
                    if ( set
                           ) {
                            p->setPen( midColor( on, indBgnd ) );
                            p->drawLine( x + 5, y + 4, x + 7, y + 4 );
                            p->drawLine( x + 5, y + 8, x + 7, y + 8 );
                            p->drawLine( x + 4, y + 5, x + 4, y + 7 );
                            p->drawLine( x + 8, y + 5, x + 8, y + 7 );
                            p->setBrush( on );
                            p->setPen( NoPen );
                            p->drawRect( x + 5, y + 5, 3, 3 );
                        }

                    if ( !formMode ) {
                        TQPointArray outerAaLeft,
                        outerAaRight;

                        outerAaLeft.setPoints( 8, x, y + 3, x + 1, y + 1, x + 3, y,
                                               x + 9, y, x + 11, y + 1, x + 12, y + 3,
                                               x + 1, y + 11, x, y + 9 );
                        outerAaRight.setPoints( 4, x + 12, y + 9, x + 11, y + 11, x + 9, y + 12,
                                                x + 3, y + 12 );

                        p->setPen( midColor( outerRightColor, cg.background() ) );
                        p->drawPoints( outerAaRight );
                        if ( APPEARANCE_FLAT != appearance && !borderButton )
                            p->setPen( midColor( outerLeftColor, cg.background() ) );
                        p->drawPoints( outerAaLeft );
                        if ( APPEARANCE_LIGHT_GRADIENT == appearance )
                            p->setPen( midColor( indBgnd, use[ 5 ], 1.75 ) );
                        else
                            p->setPen( midColor( use[ 5 ], indBgnd, 1.5 ) );

                        if ( APPEARANCE_FLAT != appearance ) {
                            TQPointArray innerAa;

                            if ( !set
                                    && !( flags & Style_Down ) ) {
                                if ( borderButton ) {
                                    innerAa.setPoints( 3, x + 1, y + 4, x + 2, y + 2, x + 4, y + 1 );
                                    p->drawPoints( innerAa );
                                    p->setPen( midColor( outerRightColor, cg.background() ) );
                                    p->drawPoint( x + 2, y + 10 );
                                } else {
                                    innerAa.setPoints( 4, x + 4, y + 11, x + 8, y + 11, x + 10, y + 10,
                                                       x + 11, y + 8 );
                                    p->drawPoints( innerAa );
                                }
                            }
                        } else {
                            TQPointArray innerAa;

                            innerAa.setPoints( 6, x + 4, y + 11, x + 8, y + 11, x + 10, y + 10,
                                               x + 11, y + 8, x + 11, y + 4, x + 10, y + 2 );
                            p->drawPoints( innerAa );
                        }
                    }
                }
                break;
            }
        case PE_DockWindowSeparator: {
                TQPoint p1,
                p2;
                //const TQColor *use=backgroundColors(cg);

                if ( flags & Style_Horizontal ) {
                    int offset = r.height() > 18 ? 6 : r.height() > 12 ? 4 : r.height() > 6 ? 2 : 0;

                    p1 = TQPoint( r.width() >> 1, 0 + offset );
                    p2 = TQPoint( p1.x(), r.height() - offset );
                } else {
                    int offset = r.width() > 18 ? 6 : r.width() > 12 ? 4 : r.width() > 6 ? 2 : 0;

                    p1 = TQPoint( 0 + offset, r.height() >> 1 );
                    p2 = TQPoint( r.width() - offset, p1.y() );
                }
                p->fillRect( r, cg.background() );
                p->setPen( cg.background().dark( 111 ) );
                p->drawLine( p1, p2 );

                break;
            }
        case PE_Splitter: {
                const TQColor *use = buttonColors( cg );

                if ( hoverWidget && hoverWidget == p->device() )
                    flags |= Style_MouseOver;

                if ( borderSplitter )
                    drawLightBevelButton( p, r, cg, TQStyle::Style_Raised, false,
                        ROUNDED_NONE, getFill( flags, use ), use );
                else {
                    p->fillRect( r,
                        TQColor( flags & Style_MouseOver ?
                        TQColor(cg.background().light( TQTC_HIGHLIGHT_FACTOR )) :
                        cg.background() ) );
                    drawLines( p, r, flags & Style_Horizontal, 70, 1, use, 0, true,
                        APPEARANCE_LIGHT_GRADIENT == appearance );
                }
                break;
            }
        case PE_DockWindowResizeHandle:
            p->fillRect( r, cg.background() );
            if ( flags & Style_Horizontal ) {
                p->setPen( cg.highlight().light() );
                p->drawLine( r.left() + 1, r.top() + 1, r.right() - 1, r.top() + 1 );
                p->setPen( cg.highlight() );
                p->drawLine( r.left() + 1, r.top() + 2, r.right() - 1, r.top() + 2 );
                p->setPen( cg.highlight().dark() );
                p->drawLine( r.left() + 1, r.top() + 3, r.right() - 1, r.top() + 3 );
            } else {
                p->setPen( cg.highlight().light() );
                p->drawLine( r.left() + 1, r.top() + 1, r.left() + 1, r.bottom() - 1 );
                p->setPen( cg.highlight() );
                p->drawLine( r.left() + 2, r.top() + 1, r.left() + 2, r.bottom() - 1 );
                p->setPen( cg.highlight().dark() );
                p->drawLine( r.left() + 3, r.top() + 1, r.left() + 3, r.bottom() - 1 );
            }
            break;
            
        case PE_StatusBarSection: {
                p->setPen( cg.background().dark(120) );
                p->drawRect(x-2, y-2, r.width()+3, r.height()+3);
                break;
        }
            
	case PE_PanelLineEdit: {
                const TQColor *use = backgroundColors( cg );
		p->setPen( use[ 4 ].light(80) );
		p->drawRect( r );
		break;
	}
            
        case PE_PanelPopup: {
                const TQColor *use = backgroundColors( cg );

                if ( borderFrame && ( data.isDefault() || data.lineWidth() > 1 ) ) {
                    p->setPen( use[ 4 ].light(70) );
                    p->setBrush( NoBrush );
		    drawPopupRect (p, r, cg);
                    //p->drawRect( r );
#ifdef MENU_POPUP_SHADOW

                    qDrawShadePanel( p, r.x() + 1, r.y() + 1, r.width() - 2, r.height() - 2,
                                     TQColorGroup( use[ 4 ], use[ NUM_SHADES ], use[ 0 ], use[ 4 ], use[ 2 ],
                                     cg.text(), use[ NUM_SHADES ] ),
                                     flags & Style_Sunken,
                                     data.isDefault() ? TQTC_BORDERED_FRAME_WIDTH - 1 : data.lineWidth() - 1 );
#endif

                } else
                    qDrawShadePanel( p, r,
                        TQColorGroup(
                            use[ 5 ], use[ NUM_SHADES ], use[ 0 ], use[ 5 ], use[ 2 ],
                            cg.text(), use[ NUM_SHADES ]
                        ),
                        flags & Style_Sunken, data.isDefault() ? TQTC_DEF_FRAME_WIDTH : data.lineWidth() );
                break;
            }
        case PE_PanelTabWidget: {
                const TQColor *use = backgroundColors( cg );

                if ( borderFrame && ( data.isDefault() || data.lineWidth() > 1 ) ) {
                    p->setPen( use[ 4 ] );
                    p->setBrush( NoBrush );
                    p->drawRect( r );
#ifdef MENU_POPUP_SHADOW

                    qDrawShadePanel( p, r.x() + 1, r.y() + 1, r.width() - 2, r.height() - 2,
                                     TQColorGroup( use[ 4 ], use[ NUM_SHADES ], use[ 0 ], use[ 4 ], use[ 2 ],
                                     cg.text(), use[ NUM_SHADES ] ),
                                     flags & Style_Sunken,
                                     data.isDefault() ? TQTC_BORDERED_FRAME_WIDTH - 1 : data.lineWidth() - 1 );
#endif

                } else
                    qDrawShadePanel( p, r,
                        TQColorGroup(
                            use[ 5 ], use[ NUM_SHADES ], use[ 0 ], use[ 5 ], use[ 2 ],
                            cg.text(), use[ NUM_SHADES ]
                        ),
                        flags & Style_Sunken, data.isDefault() ? TQTC_DEF_FRAME_WIDTH : data.lineWidth() );
                break;
            }
        case PE_PanelDockWindow:
        case PE_PanelMenuBar: {
                const TQColor *use = backgroundColors( cg );
                switch ( toolbarBorders ) {
                    case TB_DARK:
                        qDrawShadePanel( p, 
                            r.x(), r.y(), r.width(), r.height(),
                            TQColorGroup(
                                use[ 5 ].dark( 120 ), use[ NUM_SHADES ], use[ 0 ],
                                use[ 5 ].dark( 120 ), use[ 2 ],
                                cg.text(), use[ NUM_SHADES ] ),
                            flags & Style_Sunken, 1
                        );
                            
#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

                        if ( APPEARANCE_FLAT != appearance )
                            drawBevelGradient( use[ NUM_SHADES ],
                                               true, 1, p, r, true,
                                               SHADE_BAR_LIGHT, SHADE_BAR_DARK
                            );
#endif

                        break;
                    case TB_LIGHT:
                        qDrawShadePanel( p,
                            r.x(), r.y(), r.width(), r.height(),
                            TQColorGroup(
                                use[ 3 ], use[ NUM_SHADES ], use[ 0 ],
                                use[ 3 ], use[ 2 ],
                                cg.text(), use[ NUM_SHADES ]
                            ),
                            flags & Style_Sunken, 1
                        );
                        
#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

                        if ( APPEARANCE_FLAT != appearance )
                            drawBevelGradient( use[ NUM_SHADES ],
                                               true, 1, p, r, true,
                                               SHADE_BAR_LIGHT, SHADE_BAR_DARK );
#endif

                        break;
                    case TB_NONE:
                        break;

                } /* switch */

                break;
            }
        case PE_ScrollBarAddLine:
        case PE_ScrollBarSubLine: {
                bool down = ( flags & ( TQStyle::Style_Down | TQStyle::Style_On | TQStyle::Style_Sunken ) );
                const TQColor *use = buttonColors( cg );

                pe = flags & Style_Horizontal
                     ? PE_ScrollBarAddLine == pe
                     ? PE_ArrowRight
                     : PE_ArrowLeft
                 : PE_ScrollBarAddLine == pe
                     ? PE_ArrowDown
                     : PE_ArrowUp;

                drawLightBevelButton( p, r, cg,
                    down ? flags : flags | ( ( ( flags & Style_Enabled ) ? Style_Raised : Style_Default ) ),
                                      true,
                                      PE_ArrowRight == pe ? ROUNDED_RIGHT :
                                      PE_ArrowLeft == pe ? ROUNDED_LEFT :
                                      PE_ArrowDown == pe ? ROUNDED_BOTTOM :
                                      PE_ArrowUp == pe ? ROUNDED_TOP : ROUNDED_NONE,
                                      getFill( flags, use ), use );
                drawPrimitive( pe, p, ceData, elementFlags, r, cg, flags );
                break;
            }
        case PE_ScrollBarSubPage:
        case PE_ScrollBarAddPage: {
                const TQColor *use = backgroundColors( cg );

                if ( borderButton ) {
                    if ( flags & Style_Horizontal ) {
                        p->fillRect( r.x(), r.y() + 1, r.width(), r.height() - 2, use[ 2 ] );
                        p->setPen( use[ 5 ] );
                        p->drawLine( r.left(), r.top(), r.right(), r.top() );
                        p->drawLine( r.left(), r.bottom(), r.right(), r.bottom() );
                    } else {
                        p->fillRect( r.x() + 1, r.y(), r.width() - 2, r.height(), use[ 2 ] );
                        p->setPen( use[ 5 ] );
                        p->drawLine( r.left(), r.top(), r.left(), r.bottom() );
                        p->drawLine( r.right(), r.top(), r.right(), r.bottom() );
                    }
                } else
                    p->fillRect( r.x(), r.y(), r.width(), r.height(), use[ 2 ] );
                break;
            }
        case PE_ScrollBarSlider: {
                const TQColor *use = buttonColors( cg );



                if ( flags & Style_Down )
                    flags -= Style_Down;
                flags |= flags & Style_Enabled ? Style_Raised : Style_Default;

                drawLightBevelButton( p, r, cg, flags, true, ROUNDED_NONE, getFill( flags, use ), use );

                if ( GROOVE_NONE != sliderThumbs &&
                   ( ( flags & Style_Horizontal && r.width() >= 20 ) || r.height() >= 20 ) )
                    drawLines( p, r, !( flags & Style_Horizontal ), 3, 4, use, 0, GROOVE_SUNKEN == sliderThumbs,
                               APPEARANCE_LIGHT_GRADIENT == appearance );
                break;
            }
        case PE_FocusRect: {
                p->drawWinFocusRect( r, cg.background() );
                break;
            }
        case PE_ArrowUp:
        case PE_ArrowDown:
        case PE_ArrowRight:
        case PE_ArrowLeft:
            drawArrow( p, r, cg, flags, pe );
            break;
        case PE_SpinWidgetUp:
        case PE_SpinWidgetDown: {
                TQRect sr( r );
                const TQColor *use = buttonColors( cg );

                drawLightBevelButton( p, sr, cg,
                    flags | Style_Horizontal, true, PE_SpinWidgetDown == pe ? ROUNDED_BOTTOM : ROUNDED_TOP,
                    getFill( flags, use ), use );

                if ( vArrow ) {
                    if ( PE_SpinWidgetDown == pe )
                        sr.setY( sr.y() - 1 );
                } else
                    sr.setY( sr.y() + ( PE_SpinWidgetDown == pe ? -2 : 1 ) );

                drawArrow( p, sr, cg, flags, pe == PE_SpinWidgetUp ? PE_ArrowUp : PE_ArrowDown, true );
                break;
            }
        default:
            TDEStyle::drawPrimitive( pe, p, ceData, elementFlags, r, cg, flags, data );
    }
}

void KlearlookStyle::drawTDEStylePrimitive( TDEStylePrimitive kpe, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r,
        const TQColorGroup &cg, SFlags flags, const TQStyleOption &opt, const TQWidget *widget ) const {
    switch ( kpe ) {
        case KPE_ToolBarHandle:
        case KPE_GeneralHandle:
            drawLines( p, r, !( flags & Style_Horizontal ), 2,
                APP_KICKER == themedApp ? 1 : KPE_ToolBarHandle == kpe ? 4 : 2, gray,
                APP_KICKER == themedApp ? 1 : KPE_ToolBarHandle == kpe ? -2 : 0, GROOVE_SUNKEN == handles,
                APPEARANCE_LIGHT_GRADIENT == appearance );
            break;
        case KPE_SliderGroove:
            drawSliderGroove( p, ceData, elementFlags, r, flags, widget );
            break;
        case KPE_SliderHandle:
            drawSliderHandle( p, r, cg, flags );
            break;
        case KPE_ListViewExpander: {
                int lvSize = TQTC_LV_SIZE( lvExpander );
                TQRect ar( r.x() + ( ( r.width() - ( lvSize + 4 ) ) >> 1 ),
                    r.y() + ( ( r.height() - ( lvSize + 4 ) ) >> 1 ), lvSize + 4, lvSize + 4 );

                p->setPen(  /*lvDark ? cg.text() : */cg.mid() );

                if ( LV_LINES_NONE != lvLines ) {
                    int lo = rounded ? 2 : 0;

                    p->drawLine( ar.x() + lo, ar.y(), ( ar.x() + ar.width() - 1 ) - lo, ar.y() );
                    p->drawLine( ar.x() + lo, ar.y() + ar.height() - 1,
                        ( ar.x() + ar.width() - 1 ) - lo, ar.y() + ar.height() - 1 );
                    p->drawLine( ar.x(), ar.y() + lo, ar.x(), ( ar.y() + ar.height() - 1 ) - lo );
                    p->drawLine( ar.x() + ar.width() - 1,
                        ar.y() + lo, ar.x() + ar.width() - 1, ( ar.y() + ar.height() - 1 ) - lo );

                    if ( rounded ) {
                        p->drawPoint( ar.x() + 1, ar.y() + 1 );
                        p->drawPoint( ar.x() + 1, ar.y() + ar.height() - 2 );
                        p->drawPoint( ar.x() + ar.width() - 2, ar.y() + 1 );
                        p->drawPoint( ar.x() + ar.width() - 2, ar.y() + ar.height() - 2 );
                        p->setPen( midColor(  /*lvDark ? cg.text() : */cg.mid(), cg.background() ) );
                        p->drawLine( ar.x(), ar.y() + 1, ar.x() + 1, ar.y() );
                        p->drawLine( ar.x() + ar.width() - 2, ar.y(), ar.x() + ar.width() - 1, ar.y() + 1 );
                        p->drawLine( ar.x(), ar.y() + ar.height() - 2, ar.x() + 1, ar.y() + ar.height() - 1 );
                        p->drawLine( ar.x() + ar.width() - 2, ar.y() + ar.height() - 1,
                            ar.x() + ar.width() - 1, ar.y() + ar.height() - 2 );
                    }
                }

                if ( LV_EXP_ARR == lvExpander )
                    drawArrow( p, ar, cg, flags | Style_Enabled, flags & Style_On // Collapsed = On
                               ? TQApplication::reverseLayout()
                               ? PE_ArrowLeft
                               : PE_ArrowRight
                           : PE_ArrowDown );
                else {
                    int xo = ( ar.width() - lvSize ) >> 1,
                             yo = ( ar.height() - lvSize ) >> 1;
                    int mid = lvSize >> 1;

                    p->setPen( cg.text() );
                    p->drawLine( ar.x() + xo + ( mid - 2 ), ar.y() + yo + mid,
                        ar.x() + xo + lvSize - ( mid - 1 ), ar.y() + yo + mid );
                    if ( flags & Style_On )   // Collapsed = On
                        p->drawLine( ar.x() + xo + mid, ar.y() + yo + ( mid - 2 ),
                            ar.x() + xo + mid, ar.y() + yo + lvSize - ( mid - 1 ) );
                }
                break;
            }
        case KPE_ListViewBranch:
            switch ( lvLines ) {
                case LV_LINES_NONE:
                    break;
                case LV_LINES_DOTTED:
                    // Taken and modified (colour wise) from tdestyle.cpp - which in turn comes from
                    // qwindowsstyl.cpp
                    {
                        static TQBitmap *verticalLine = 0,
                                                       *horizontalLine = 0;
                        static TQCleanupHandler<TQBitmap> lvCleanupBitmap;

                        // Create the dotline pixmaps if not already created
                        if ( !verticalLine ) {
                            // make 128*1 and 1*128 bitmaps that can be used for drawing the right sort of lines.
                            verticalLine = new TQBitmap( 1, 129, true );
                            horizontalLine = new TQBitmap( 128, 1, true );
                            TQPointArray a( 64 );
                            TQPainter p2;

                            p2.begin( verticalLine );

                            int i;
                            for ( i = 0; i < 64; i++ )
                                a.setPoint( i, 0, i * 2 + 1 );

                            p2.setPen( color1 );
                            p2.drawPoints( a );
                            p2.end();
                            TQApplication::flushX();
                            verticalLine->setMask( *verticalLine );

                            p2.begin( horizontalLine );

                            for ( i = 0; i < 64; i++ )
                                a.setPoint( i, i * 2 + 1, 0 );

                            p2.setPen( color1 );
                            p2.drawPoints( a );
                            p2.end();
                            TQApplication::flushX();
                            horizontalLine->setMask( *horizontalLine );

                            lvCleanupBitmap.add( &verticalLine );
                            lvCleanupBitmap.add( &horizontalLine );
                        }

                        p->setPen( lvDark ? cg.text() : cg.mid() );  // Wow, my big modification...

                        if ( flags & Style_Horizontal ) {
                            int point = r.x(),
                                        other = r.y(),
                                                end = r.x() + r.width(),
                                                      thickness = r.height();

                            while ( point < end ) {
                                int i = 128;

                                if ( i + point > end )
                                    i = end - point;
                                p->drawPixmap( point, other, *horizontalLine, 0, 0, i, thickness );
                                point += i;
                            }
                        } else {
                            int point = r.y(),
                                other = r.x(),
                                end = r.y() + r.height(),
                                thickness = r.width(),
                                pixmapoffset = ( flags & Style_NoChange ) ? 0 : 1;    // ### Hackish

                            while ( point < end ) {
                                int i = 128;

                                if ( i + point > end )
                                    i = end - point;
                                p->drawPixmap( other, point, *verticalLine, 0, pixmapoffset, thickness, i );
                                point += i;
                            }
                        }
                        break;
                    }
                case LV_LINES_SOLID:
                    p->setPen( cg.mid() );
                    p->drawLine( r.x(), r.y(), r.x() + r.width() - 1, r.y() + r.height() - 1 );
                    break;
            }
            break;
        default:
            TDEStyle::drawTDEStylePrimitive( kpe, p, ceData, elementFlags, r, cg, flags, opt, widget );
    }
}

void KlearlookStyle::drawControl(
    ControlElement control,
    TQPainter *p,
    const TQStyleControlElementData &ceData,
    ControlElementFlags elementFlags,
    const TQRect &r,
    const TQColorGroup &cg, SFlags flags, const TQStyleOption &data, const TQWidget *widget ) const
{
    if ( widget == hoverWidget )
        flags |= Style_MouseOver;

    switch ( control ) {
        case CE_TabBarTab: {
                const TQTabBar * tb = ( const TQTabBar * ) widget;
                bool cornerWidget = false,
                                    firstTab = 0 == tb->indexOf( data.tab() ->identifier() );

                if ( ::tqt_cast<const TQTabWidget *>( tb->parent() ) ) {
                    const TQTabWidget * tw = ( const TQTabWidget* ) tb->parent();

                    // is there a corner widget in the (top) left edge?
                    if ( tw->cornerWidget( TQt::TopLeft ) )
                        cornerWidget = true;
                }

                if ( borderFrame ) {
                    TQRect tr( r ),
                    fr( r );
                    int offset = rounded ? 2 : 0;

                    switch ( tb->shape() ) {
                        case TQTabBar::TriangularAbove:
                        case TQTabBar::RoundedAbove:
                            if ( flags & Style_Selected ) {
                                tr.addCoords( 0, 0, 0, -1 );
                                fr.addCoords( 2, 2, -2, -2 );
                                p->setPen( gray[ 5 ] );
                                p->drawLine( tr.left(),
                                    firstTab && !cornerWidget ?
                                             tr.bottom() + 1 : tr.bottom(), tr.left(),
                                             tr.top() + offset );
                                p->drawLine( tr.left() + offset, tr.top(), tr.right() - offset, tr.top() );
                                p->drawLine( tr.right(), tr.top() + 1, tr.right(), tr.bottom() );

                                p->setPen( gray[ 0 ] );
                                p->drawLine( tr.left() + 1, tr.bottom() + 1, tr.left() + 1, tr.top() + 2 );
                                p->drawLine( tr.left() + 1, tr.top() + 1, tr.right() - 1, tr.top() + 1 );
                                p->drawLine( tr.right() - 1, tr.bottom() + 1, tr.right(), tr.bottom() + 1 );

                                if ( cornerWidget )
                                    p->drawPoint( tr.left(), tr.bottom() + 1 );

                                p->setPen( gray[ 4 ] );
                                p->drawLine( tr.right() - 1, tr.top() + 1, tr.right() - 1, tr.bottom() );

                                if ( rounded ) {
                                    p->setPen( gray[ 5 ] );
                                    p->drawPoint( tr.x() + 1, tr.y() + 1 );
                                    p->drawPoint( tr.x() + tr.width() - 2, tr.y() + 1 );
                                    p->setPen( gray[ 4 ] );
                                    p->drawLine( tr.x(), tr.y() + 1, tr.x() + 1, tr.y() );
                                    p->drawLine( tr.x() + tr.width() - 2,
                                        tr.y(), tr.x() + tr.width() - 1, tr.y() + 1 );
                                }
                            } else {
                                tr.addCoords( 0, 2, 0, -1 );
                                fr.addCoords( 2, 4, -2, -2 );

                                p->setPen( gray[ 5 ] );
                                p->drawLine( tr.left(),
                                    firstTab && !cornerWidget ? tr.bottom() + 1 : tr.bottom(), tr.left(),
                                             tr.top() + 1 );
                                p->drawLine( rounded ? tr.left() + 1 : tr.left(),
                                    tr.top(), rounded ? tr.right() - 1 : tr.right(), tr.top() );
                                p->drawLine( tr.right(), tr.top() + 1, tr.right(), tr.bottom() );
                                p->drawLine( tr.left(), tr.bottom(), tr.right(), tr.bottom() );
                                p->setPen( gray[ 0 ] );
                                p->drawLine( tr.left() + 1, tr.top() + 1, tr.right() - 1, tr.top() + 1 );

                                if ( cornerWidget )
                                    p->drawPoint( tr.left(), tr.bottom() + 1 );

                                if ( !firstTab )
                                    p->setPen( gray[ 2 ] );

                                p->drawLine( tr.left() + 1, tr.bottom() - 1, tr.left() + 1, tr.top() + 2 );
                                p->setPen( gray[ 0 ] );
                                p->drawLine( tr.left() + 1, tr.bottom() + 1, tr.right(), tr.bottom() + 1 );
                                p->setPen( gray[ 4 ] );
                                p->drawLine( tr.right() - 1, tr.top() + 1, tr.right() - 1, tr.bottom() - 1 );
                            }

                            if ( APPEARANCE_FLAT != appearance ) {
                                if ( flags & Style_Selected ) {
                                    drawBevelGradient( cg.background(), true, 0, p, fr, true,
                                        SHADE_TAB_SEL_LIGHT( appearance ),
                                        SHADE_TAB_SEL_DARK( appearance ) );

				                    p->setPen(menuPbar[ GRADIENT_BASE ]);
				                    p->drawLine( fr.left()-1, fr.top()-1, fr.right()+1, fr.top()-1);
				                    p->drawLine( fr.left()-1, fr.top(), fr.right()+1, fr.top());

				                    p->setPen(menuPbar[ GRADIENT_DARK ].dark(118));
				                    p->drawLine( fr.left(), fr.top()-2, fr.right(), fr.top()-2);
                                    p->drawPoint( tr.x() + 1, tr.y() + 1 );
                                    p->drawPoint( tr.x(), tr.y() + 2 );
                                    p->drawPoint( tr.x() + tr.width() - 2, tr.y() + 1 );
                                    p->drawPoint( tr.x() + tr.width() - 1, tr.y() + 2 );
                                
                                } else
                                    drawBevelGradient( gray[ 2 ], true, 0, p, fr, true,
                                        SHADE_TAB_LIGHT( appearance ), SHADE_TAB_DARK( appearance ) );

			    
                            } else
                                p->fillRect( fr, flags & Style_Selected ? cg.background() : gray[ 2 ] );

                            break;
                        case TQTabBar::TriangularBelow:
                        case TQTabBar::RoundedBelow:
                            if ( flags & Style_Selected ) {
                                fr.addCoords( 3, 2, -3, -3 );
                                p->setPen( gray[ 5 ] );

                                p->drawLine( tr.left(), tr.bottom() - offset, tr.left(),
                                             firstTab && !cornerWidget ? tr.top() : tr.top() + 1 );
                                p->drawLine( rounded ? tr.left() + 1 : tr.left(),
                                    tr.bottom(), tr.right() - offset, tr.bottom() );
                                p->drawLine( tr.right(), tr.top() + 1, tr.right(), tr.bottom() - 1 );
                                p->setPen( gray[ 0 ] );
                                p->drawLine( tr.left() + 1, tr.bottom() - 2, tr.left() + 1,
                                             firstTab && !cornerWidget ? tr.top() : tr.top() - 1 );
                                p->setPen( gray[ 4 ] );
                                p->drawLine( tr.left() + 1, tr.bottom() - 1, tr.right() - 1, tr.bottom() - 1 );
                                p->drawLine( tr.right() - 1, tr.bottom() - 2, tr.right() - 1, tr.top() - 1 );
                                p->drawPoint( tr.right(), tr.top() );
                                if ( cornerWidget )
                                    p->drawPoint( tr.left(), tr.top() );


                                if ( rounded ) {
                                    p->setPen( gray[ 5 ] );
                                    p->drawPoint( tr.x() + 1, tr.y() + tr.height() - 2 );
                                    p->drawPoint( tr.x() + tr.width() - 2, tr.y() + tr.height() - 2 );
                                    p->setPen( gray[ 4 ] );
                                    p->drawLine( tr.x(), tr.y() + tr.height() - 2,
                                        tr.x() + 1, tr.y() + tr.height() - 1 );
                                    p->drawLine( tr.x() + tr.width() - 2,
                                        tr.y() + tr.height() - 1, tr.x() + tr.width() - 1,
                                        tr.y() + tr.height() - 2 );
                                }
                            } else {
                                tr.addCoords( 0, 1, 0, -2 );
                                fr.addCoords( 1, 2, -2, -4 );

                                p->setPen( gray[ 5 ] );
                                p->drawLine( tr.left(), tr.bottom() - 1, tr.left(),
                                             firstTab && !cornerWidget ? tr.top() : tr.top() + 1 );
                                p->drawLine( rounded ? tr.left() + 1 : tr.left(), tr.bottom(),
                                             rounded ? tr.right() - 1 : tr.right(), tr.bottom() );
                                p->drawLine( tr.right(), tr.top() + 1, tr.right(), tr.bottom() - 1 );
                                p->drawLine( tr.right(), tr.top(), tr.left(), tr.top() );
                                p->setPen( gray[ 4 ] );
                                p->drawLine( tr.left(), tr.top() - 1, tr.right(), tr.top() - 1 );
                                p->drawLine( tr.left() + 1, tr.bottom() - 1, tr.right() - 1, tr.bottom() - 1 );
                                p->drawLine( tr.right() - 1, tr.bottom() - 2, tr.right() - 1, tr.top() + 1 );
                            }
                            if ( APPEARANCE_FLAT != appearance )
                                if ( flags & Style_Selected )
                                    drawBevelGradient( cg.background(), false, -1, p, fr, true,
                                        SHADE_BOTTOM_TAB_SEL_DARK( appearance ),
                                        SHADE_BOTTOM_TAB_SEL_LIGHT( appearance ) );
                                else
                                    drawBevelGradient( gray[ 2 ], false, 0, p, fr, true,
                                        SHADE_BOTTOM_TAB_DARK( appearance ),
                                        SHADE_BOTTOM_TAB_LIGHT( appearance ) );
                            else
                                p->fillRect( fr, flags & Style_Selected ? cg.background() : gray[ 2 ] );
                            break;
                        default:
                            TDEStyle::drawControl( control, p, ceData, elementFlags, r, cg, flags, data, widget );
                    }
                } else {
                    TQRect br( r );

                    switch ( tb->shape() ) {
                        case TQTabBar::TriangularAbove:
                        case TQTabBar::RoundedAbove:
                            if ( flags & Style_Selected ) {
                                p->setPen( cg.background() );
                                p->drawLine( br.bottomLeft(), br.bottomRight() );
                                p->setPen( gray[ 0 ] );
                                p->drawPoint( br.bottomLeft() );
                                p->setPen( gray[ 5 ] );
                                p->drawPoint( br.bottomRight() );
                                br.addCoords( 0, 0, 0, -1 );
                            } else {
                                p->setPen( gray[ 0 ] );
                                p->drawLine( br.left(), br.bottom(), br.right(), br.bottom() );
                                br.addCoords( 0, 1, -1, -1 );
                            }

                            p->setPen( gray[ 0 == r.left() || flags & Style_Selected ? 0 : 5 ] );
                            p->drawLine( br.bottomLeft(), br.topLeft() );
                            p->setPen( gray[ 0 ] );
                            p->drawLine( br.left() + 1, br.top(), br.right() - 1, br.top() );
                            p->setPen( gray[ 5 ] );
                            p->drawLine( br.right(), br.top(), br.right(), br.bottom() );
                            br.addCoords( 1, 1, -1, 0 );
                            if ( APPEARANCE_FLAT != appearance )
                                if ( flags & Style_Selected )
                                    drawBevelGradient( cg.background(), true, 0, p, br,
                                        true, SHADE_TAB_SEL_LIGHT( appearance ),
                                        SHADE_TAB_SEL_DARK( appearance ) );
                                else
                                    drawBevelGradient( gray[ 2 ], true, 0, p, br, true,
                                        SHADE_TAB_LIGHT( appearance ), SHADE_TAB_DARK( appearance ) );
                            else
                                p->fillRect( br, flags & Style_Selected ? cg.background() : gray[ 2 ] );
                            break;
                        case TQTabBar::TriangularBelow:
                        case TQTabBar::RoundedBelow:
                            if ( flags & Style_Selected ) {
                                p->setPen( cg.background() );
                                p->drawLine( br.topLeft(), br.topRight() );
                                p->setPen( gray[ 0 ] );
                                p->drawPoint( br.topLeft() );
                                p->setPen( gray[ 5 ] );
                                p->drawPoint( br.topRight() );
                                br.addCoords( 0, 1, 0, 0 );
                            } else {
                                p->setPen( gray[ 5 ] );
                                p->drawLine( br.left(), br.top(),
                                             br.right(), br.top() );
                                br.addCoords( 0, 1, -1, -1 );
                            }

                            if ( 0 == r.left() || flags & Style_Selected ) {
                                p->setPen( gray[ 0 ] );
                                p->drawLine( br.bottomLeft(), br.topLeft() );
                            }
                            p->setPen( gray[ 5 ] );
                            p->drawLine( br.bottomLeft(), br.bottomRight() );
                            p->drawLine( br.right(), br.top(), br.right(), br.bottom() );
                            br.addCoords( 1, 0, -1, -1 );
                            if ( APPEARANCE_FLAT != appearance )
                                if ( flags & Style_Selected )
                                    drawBevelGradient(
                                        cg.background(), false, 0, p, br, true,
                                        SHADE_BOTTOM_TAB_SEL_DARK( appearance ),
                                        SHADE_BOTTOM_TAB_SEL_LIGHT( appearance ) );
                                else
                                    drawBevelGradient( gray[ 2 ], false, 0, p, br,
                                        true, SHADE_BOTTOM_TAB_DARK( appearance ),
                                        SHADE_BOTTOM_TAB_LIGHT( appearance ) );
                            else
                                p->fillRect( br, flags & Style_Selected ? cg.background() : gray[ 2 ] );
                    }
                }
                break;
            }
        case CE_TabBarLabel: {
                if ( data.isDefault() )
                    break;

                const TQTabBar *tb = ( const TQTabBar * ) widget;
                TQTab *t = data.tab();
                TQRect tr = r;

                if ( t->identifier() == tb->currentTab() ) {
                    if ( TQTabBar::RoundedAbove == tb->shape() || TQTabBar::TriangularAbove == tb->shape() )
                        tr.setBottom( tr.bottom() - pixelMetric( TQStyle::PM_TabBarTabShiftVertical, ceData, elementFlags, tb ) );
                } else
                    if ( TQTabBar::RoundedBelow == tb->shape() || TQTabBar::TriangularBelow == tb->shape() )
                        tr.setTop( tr.top() + pixelMetric( TQStyle::PM_TabBarTabShiftVertical, ceData, elementFlags, tb ) );

                drawItem( p, tr, AlignCenter | ShowPrefix, cg, flags & Style_Enabled, 0, t->text() );

                if ( ( flags & Style_HasFocus ) && !t->text().isEmpty() )
                    drawPrimitive( PE_FocusRect, p, ceData, elementFlags, r, cg );
                break;
            }
        case CE_PushButtonLabel:    // Taken from Highcolour and Plastik...
            {
                int x, y, w, h;

                r.rect( &x, &y, &w, &h );

                const TQPushButton *button = static_cast<const TQPushButton *>( widget );
                bool active = button->isOn() || button->isDown(),
                              cornArrow = false;

                // Shift button contents if pushed.
                if ( active ) {
                    x += pixelMetric( PM_ButtonShiftHorizontal, ceData, elementFlags, widget );
                    y += pixelMetric( PM_ButtonShiftVertical, ceData, elementFlags, widget );
                    flags |= Style_Sunken;
                }

                // Does the button have a popup menu?
                if ( button->isMenuButton() ) {
                    int dx = pixelMetric( PM_MenuButtonIndicator, ceData, elementFlags, widget ),
                        margin = pixelMetric( PM_ButtonMargin, ceData, elementFlags, widget );

                    if ( button->iconSet() && !button->iconSet() ->isNull() &&
                       ( dx + button->iconSet() ->pixmap ( TQIconSet::Small, TQIconSet::Normal,
                            TQIconSet::Off ).width() ) >= w )
                        cornArrow = true; //To little room. Draw the arrow in the corner, don't adjust the widget
                    else {
                        drawPrimitive( PE_ArrowDown,
                            p, ceData, elementFlags, visualRect( TQRect(
                                ( x + w ) - ( dx + margin ), y, dx,
                                h ), r ), cg, flags, data );
                                
                        w -= dx;
                    }
                }

                // Draw the icon if there is one
                if ( button->iconSet() && !button->iconSet() ->isNull() ) {
                    TQIconSet::Mode mode = TQIconSet::Disabled;
                    TQIconSet::State state = TQIconSet::Off;

                    if ( button->isEnabled() )
                        mode = button->hasFocus() ? TQIconSet::Active : TQIconSet::Normal;
                    if ( button->isToggleButton() && button->isOn() )
                        state = TQIconSet::On;

                    TQPixmap pixmap = button->iconSet() ->pixmap( TQIconSet::Small, mode, state );

                    static const int constSpace = 2;

                    int xo = 0,
                             pw = pixmap.width(),
                                  iw = 0;

                    if ( button->text().isEmpty() && !button->pixmap() )
                        p->drawPixmap( x + ( w >> 1 ) - ( pixmap.width() >> 1 ),
                                       y + ( h >> 1 ) - ( pixmap.height() >> 1 ),
                                       pixmap );
                    else {
                        iw = button->pixmap() ? button->pixmap() ->width()
                             : widget->fontMetrics().size( TQt::ShowPrefix, button->text() ).width();

                        int cw = iw + pw + constSpace;

                        xo = cw < w ? ( w - cw ) >> 1 : constSpace;
                        p->drawPixmap( x + xo, y + ( h >> 1 ) - ( pixmap.height() >> 1 ), pixmap );
                        xo += pw;
                    }

                    if ( cornArrow )   //Draw over the icon
                        drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, visualRect( TQRect( x + w - 6, x + h - 6, 7, 7 ), r ),
                                       cg, flags, data );

                    if ( xo && iw ) {
                        x += xo + constSpace;
                        w = iw;
                    } else {
                        x += pw + constSpace;
                        w -= pw + constSpace;
                    }
                }

                // Make the label indicate if the button is a default button or not
                int i,
                j = boldDefText && button->isDefault() ? 2 : 1;

                for ( i = 0; i < j; i++ )
                    drawItem( p, TQRect( x + i, y, w, h ),
                              AlignCenter | ShowPrefix,
                              button->colorGroup(),
                              button->isEnabled(),
                              button->pixmap(),
                              button->text(), -1,
                              &button->colorGroup().buttonText() );

                //Draw a focus rect if the button has focus
                if ( flags & Style_HasFocus )
                    drawPrimitive( PE_FocusRect, p, ceData, elementFlags,
                        TQStyle::visualRect( subRect( SR_PushButtonFocusRect, ceData, elementFlags, widget ), ceData, elementFlags ), cg, flags );
                        
                break;
            }
        case CE_PopupMenuItem: {
                if ( !widget || data.isDefault() )
                    break;

                const TQPopupMenu *popupmenu = ( const TQPopupMenu * ) widget;
                TQMenuItem *mi = data.menuItem();
                int tab = data.tabWidth(),
                    maxpmw = data.maxIconWidth(),
                    x, y, w, h;

                r.rect( &x, &y, &w, &h );

                if ( ( flags & Style_Active ) && ( flags & Style_Enabled ) ) {
                    drawPBarOrMenu( p, r, true, cg, true );
                } else if ( widget->erasePixmap() && !widget->erasePixmap() ->isNull() )
                    p->drawPixmap( x, y, *widget->erasePixmap(), x, y, w, h );
                else {
                    // lighter background in popup menu
                   p->fillRect( r, cg.background().light( 100 + popupmenuHighlightLevel ) );
                }

                if ( !mi )
                    break;

                if ( mi->isSeparator() ) {
                    const TQColor * use = backgroundColors( cg );
                    p->setPen( cg.background().dark(105) );
                    p->drawLine( r.left() + 5, r.top() + 3, r.right() - 5, r.top() + 3 );
                    break;
                }

                maxpmw = TQMAX( maxpmw, 16 );

                TQRect cr, ir, tr, sr;
		if (menuIcons) {
		    // check column
		    cr.setRect( r.left(), r.top(), maxpmw, r.height() );
		    // submenu indicator column
		    sr.setCoords( r.right() - maxpmw, r.top(), r.right(), r.bottom() );
		    // tab/accelerator column
		    tr.setCoords( sr.left() - tab - 4, r.top(), sr.left(), r.bottom() );
		    // item column
		    ir.setCoords( cr.right() + 2, r.top(), tr.right() - 4, r.bottom() );
		} else {
		    // item column
		    ir.setCoords( r.left() + 4, r.top(), r.width() , r.bottom() );
		    // check column
		    cr.setCoords( r.right() - maxpmw, r.top(), r.right(), r.bottom() );
		    // submenu indicator column
		    sr.setCoords( r.right() - maxpmw, r.top(), r.right(), r.bottom() );
		    // tab/accelerator column
		    tr.setCoords( sr.left() - tab - 4, r.top(), sr.left(), r.bottom() );
		}

                bool reverse = TQApplication::reverseLayout();

                if ( reverse ) {
                    cr = visualRect( cr, r );
                    sr = visualRect( sr, r );
                    tr = visualRect( tr, r );
                    ir = visualRect( ir, r );
                }

                if ( mi->iconSet() && menuIcons ) {
                    // Select the correct icon from the iconset
                    TQIconSet::Mode mode = flags & Style_Active
                            ? ( mi->isEnabled() ? TQIconSet::Active : TQIconSet::Disabled )
                            : ( mi->isEnabled() ? TQIconSet::Normal : TQIconSet::Disabled );
                    cr = visualRect( TQRect( x, y, maxpmw, h ), r );

                    // Do we have an icon and are checked at the same time?
                    // Then draw a "pressed" background behind the icon
                    if ( popupmenu->isCheckable() && mi->isChecked() ) {

                        TQBrush brush( gray[ 3 ] );

                        qDrawShadePanel( p,
                             cr.x() + 1, cr.y() + 2, cr.width() - 2, cr.height() - 4,
                             TQColorGroup( gray[ 5 ], gray[ NUM_SHADES ], gray[ 0 ], gray[ 5 ],
                                          gray[ 2 ], cg.text(), gray[ NUM_SHADES ] ),
                             true, 1, &brush );
                    }
                    // Draw the icon
                    TQPixmap pixmap = mi->iconSet() ->pixmap( TQIconSet::Small, mode );
                    TQRect pmr( 0, 0, pixmap.width(), pixmap.height() );

                    pmr.moveCenter( cr.center() );
                    p->drawPixmap( pmr.topLeft(), pixmap );
                    
                } else if ( popupmenu->isCheckable() && mi->isChecked() ) {

		    // check column
		    cr.setRect( r.left(), r.top(), maxpmw, r.height() );
		    // submenu indicator column
		    sr.setCoords( r.right() - maxpmw, r.top(), r.right(), r.bottom() );
		    // tab/accelerator column
		    tr.setCoords( sr.left() - tab - 4, r.top(), sr.left(), r.bottom() );
		    // item column
		    ir.setCoords( cr.right() + 2, r.top(), tr.right() - 4, r.bottom() );

                    TQBrush brush( mi->isEnabled() ? cg.highlightedText() : cg.background() );
                    drawPrimitiveMenu( PE_CheckMark, p, ceData, elementFlags, cr, cg,
                        ( flags & ( Style_Enabled | Style_Active ) ) | Style_On );
                }

                TQColor textcolor, embosscolor;

                if ( flags & Style_Active ) {
                    if ( !( flags & Style_Enabled ) ) {
                        textcolor = cg.text();
                        embosscolor = cg.light();
                    } else {
                        textcolor = cg.highlightedText();
                        embosscolor = cg.midlight().light();
                    }
                } else if ( !( flags & Style_Enabled ) ) {
                    textcolor = cg.text();
                    embosscolor = cg.light();
                } else
                    textcolor = embosscolor = cg.buttonText();
                p->setPen( textcolor );

                if ( mi->custom() ) {
                    p->save();
                    if ( !( flags & Style_Enabled ) ) {
                        p->setPen( cg.light() );
                        mi->custom() ->paint( p, cg, ( flags & Style_Enabled ) ? ( flags & Style_Active ) : 0,
                                              flags & Style_Enabled, ir.x() + 1, ir.y() + 1, ir.width() - 1,
                                              ir.height() - 1 );
                        p->setPen( textcolor );
                    }
                    mi->custom() ->paint( p, cg, ( flags & Style_Enabled ) ? ( flags & Style_Active ) : 0,
                                          flags & Style_Enabled, ir.x(), ir.y(), ir.width(), ir.height() );
                    p->restore();
                }

                TQString text = mi->text();

                if ( !text.isNull() ) {
                    int t = text.find( '\t' );

                    // draw accelerator/tab-text
                    if ( t >= 0 ) {
                        int alignFlag = AlignVCenter | ShowPrefix | DontClip | SingleLine;

                        alignFlag |= ( reverse ? AlignLeft : AlignRight );

                        if ( !( flags & Style_Enabled ) ) {
                            p->setPen( embosscolor );
                            tr.moveBy( 1, 1 );
                            p->drawText( tr, alignFlag, text.mid( t + 1 ) );
                            tr.moveBy( -1, -1 );
                            p->setPen( textcolor );
                        }

                        p->drawText( tr, alignFlag, text.mid( t + 1 ) );
                    }

                    int alignFlag = AlignVCenter | ShowPrefix | DontClip | SingleLine;

                    alignFlag |= ( reverse ? AlignRight : AlignLeft );

                    if ( !( flags & Style_Enabled ) ) {
                        p->setPen( embosscolor );
                        ir.moveBy( 1, 1 );
                        p->drawText( ir, alignFlag, text, t );
                        ir.moveBy( -1, -1 );
                        p->setPen( textcolor );
                    }

                    p->drawText( ir, alignFlag, text, t );
                } else if ( mi->pixmap() ) {
                    TQPixmap pixmap = *mi->pixmap();

                    if ( 1 == pixmap.depth() )
                        p->setBackgroundMode( TQt::OpaqueMode );
                    p->drawPixmap( ir.x(), ( ir.height() - pixmap.height() ) >> 1, pixmap );
                    if ( pixmap.depth() == 1 )
                        p->setBackgroundMode( TQt::TransparentMode );
                }

                if ( mi->popup() )
                    drawArrow( p, sr, cg, flags, reverse ? PE_ArrowLeft : PE_ArrowRight, false, true );
                break;
            }
        case CE_MenuBarItem: {
                if ( ( flags & Style_Enabled ) &&
                     ( flags & Style_Active ) &&
                     ( flags & Style_Down ) ) {                    
                    drawPBarOrMenu2( p, TQRect(r.x(), r.y(), r.width(), r.height()),
                        true, cg, true );
                } else
#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS
                    if ( APPEARANCE_FLAT != appearance )
                        drawBevelGradient( cg.background(), true, 0, p,
                        r,
                        true, SHADE_BAR_LIGHT, SHADE_BAR_DARK );
                    else
#endif
                        if (darkMenubar) {
			    drawBevelGradient( cg.background(), true, 1, p,
				    TQRect(r.x()-1, r.y()-1, r.width()+2, r.height()+2), 
				    true, 
				    SHADE_BEVEL_MENU_GRAD_LIGHT( appearance ), SHADE_BEVEL_MENU_GRAD_DARK( appearance ));
                        } else
                            p->fillRect( r, cg.background() );

                if ( data.isDefault() )
                    break;

                TQMenuItem *mi = data.menuItem();

                if ( flags & Style_Active && ( flags & Style_Down ) )
                    drawItem( p, r, AlignCenter | ShowPrefix | DontClip | SingleLine,
                        cg, flags & Style_Enabled, mi->pixmap(), mi->text(), -1, &cg.highlightedText() );
                else
                    drawItem( p, r, AlignCenter | ShowPrefix | DontClip | SingleLine, cg,
                        flags & Style_Enabled, mi->pixmap(), mi->text(), -1, &cg.buttonText() );
                break;
            }
        case CE_MenuBarEmptyArea:
            if (darkMenubar) {
                //p->fillRect( r, cg.background().dark( 106 ) );
		TQColor b;
		b.setRgb(cg.background().red(), cg.background().green(), cg.background().blue());
                drawBevelGradient( b, true, 1, p, 
			TQRect(r.x()-1, r.y()-1, r.width()+2, r.height()+2 ), 
			true, 
			SHADE_BEVEL_MENU_GRAD_LIGHT( appearance ), SHADE_BEVEL_MENU_GRAD_DARK( appearance ));
            } else
                p->fillRect( r, cg.background() );
            break;

        case CE_DockWindowEmptyArea:
#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

            if ( APPEARANCE_FLAT != appearance )
                drawBevelGradient( cg.background(), true, 1, p, r, true, SHADE_BAR_LIGHT, SHADE_BAR_DARK );
            else
#endif

                p->fillRect( r, cg.background() );
            break;
        case CE_ProgressBarGroove:
            p->setBrush( gray[ NUM_SHADES ] );
            p->drawRect( r );
            qDrawShadePanel( p, r,
                TQColorGroup( gray[ 5 ], gray[ NUM_SHADES ], gray[ 0 ], gray[ 5 ], gray[ 2 ],
                cg.text(), gray[ NUM_SHADES ] ), true, 1 );
                
            break;
            
        case CE_ProgressBarContents: {
                // ### Take into account totalSteps()for busy indicator
                const TQProgressBar *pb = ( const TQProgressBar* ) widget;
                TQRect cr = subRect( SR_ProgressBarContents, ceData, elementFlags, widget );
                double progress = pb->progress();
                bool reverse = TQApplication::reverseLayout();
                int steps = pb->totalSteps();

                if ( cr.isValid() && ( progress > 0 || steps == 0 ) ) {
                    double pg = ( steps == 0 ) ? 0.1 : progress / steps;
                    int width = TQMIN( cr.width(), ( int ) ( pg * cr.width() ) );

                    if ( 0 == steps )  //Busy indicator
                    {
                        if ( width < 1 )
                            width = 1; //A busy indicator with width 0 is kind of useless

                        int remWidth = cr.width() - width; //Never disappear completely

                        if ( remWidth <= 0 )
                            remWidth = 1; //Do something non-crashy when too small...

                        int pstep = int( progress ) % ( 2 * remWidth );

                        if ( pstep > remWidth ) {
                            //Bounce about.. We're remWidth +some delta, we want to be remWidth-delta...
                            //-((remWidth +some delta)-2* remWidth)=-(some deleta-remWidth)=remWidth-some delta..
                            pstep = -( pstep - 2 * remWidth );
                        }

                        if ( reverse )
                            drawPBarOrMenu( p, TQRect( cr.x() + cr.width() - width - pstep,
                                cr.y(), width, cr.height() ), true, cg );
                        else
                            drawPBarOrMenu( p, TQRect( cr.x() + pstep, cr.y(), width,
                                cr.height() ), true, cg );
                    } else
                        if ( reverse )
                            drawPBarOrMenu( p, TQRect( cr.x() + ( cr.width() - width ),
                                cr.y(), width, cr.height() ), true, cg );
                        else
                            drawPBarOrMenu( p, TQRect( cr.x(), cr.y(), width, cr.height() ), true, cg );
                }
                break;
            }
        case CE_PushButton: {
                const TQPushButton *button = static_cast<const TQPushButton *>( widget );
                TQRect br( r );
                int dbi = pixelMetric( PM_ButtonDefaultIndicator, ceData, elementFlags, widget );

                if ( rounded && isFormWidget( widget ) )
                    formMode = true;

                if ( widget == hoverWidget )
                    flags |= Style_MouseOver;

                if ( IND_BORDER == defBtnIndicator )
                    br.setCoords( br.left() + dbi, br.top() + dbi, br.right() - dbi, br.bottom() - dbi );
                else if ( IND_FONT_COLOUR == defBtnIndicator && button->isDefault() )
                    flags |= Style_ButtonDefault;

                p->save();
                p->setBrushOrigin( -widget->backgroundOffset().x(), -widget->backgroundOffset().y() );
                // draw button
                drawPrimitive( PE_ButtonCommand, p, ceData, elementFlags, br, cg, flags );
                if ( button->isDefault() && IND_FONT_COLOUR != defBtnIndicator )
                    drawPrimitive( PE_ButtonDefault, p, ceData, elementFlags, r, cg, flags );
                p->restore();
                formMode = false;
                break;
            }
        case CE_CheckBox:
            drawPrimitive( PE_Indicator, p, ceData, elementFlags, r, cg, flags, data );
            break;
        case CE_CheckBoxLabel:
            if ( crLabelHighlight ) {
                const TQCheckBox * checkbox = ( const TQCheckBox * ) widget;

                if ( flags & Style_MouseOver &&
                        HOVER_CHECK == hover && hoverWidget == widget &&
                        !isFormWidget( widget ) ) {
                    TQRect cr( checkbox->rect() );
                    TQRegion r( TQRect( cr.x(), cr.y(),
                        visualRect( subRect( SR_CheckBoxFocusRect, ceData, elementFlags, widget ), ceData, elementFlags ).width() +
                                    pixelMetric( PM_IndicatorWidth, ceData, elementFlags ) + 4, cr.height() ) );

                    r -= visualRect( subRect( SR_CheckBoxIndicator, ceData, elementFlags, widget ), ceData, elementFlags );
                    p->setClipRegion( r );
                    p->fillRect( checkbox->rect(), cg.background().light( TQTC_HIGHLIGHT_FACTOR ) );
                    p->setClipping( false );
                }
                int alignment = TQApplication::reverseLayout() ? AlignRight : AlignLeft;

                drawItem( p, r, alignment | AlignVCenter | ShowPrefix, cg,
                    flags & Style_Enabled, checkbox->pixmap(), checkbox->text() );

                if ( checkbox->hasFocus() )
                    drawPrimitive( PE_FocusRect, p, ceData, elementFlags,
                        visualRect( subRect( SR_CheckBoxFocusRect, ceData, elementFlags, widget ), ceData, elementFlags ), cg, flags );
            } else
                TDEStyle::drawControl( control, p, ceData, elementFlags, r, cg, flags, data, widget );
            break;
        case CE_RadioButton:
            formMode = isFormWidget( widget );
            drawPrimitive( PE_ExclusiveIndicator, p, ceData, elementFlags, r, cg, flags, data );
            formMode = false;
            break;
        case CE_RadioButtonLabel:
            if ( crLabelHighlight ) {
                const TQRadioButton * radiobutton = ( const TQRadioButton * ) widget;

                if ( flags & Style_MouseOver &&
                        HOVER_RADIO == hover && hoverWidget == widget &&
                        !isFormWidget( widget ) ) {
                    TQRect rb( radiobutton->rect() );
                    TQRegion r( TQRect( rb.x(), rb.y(),
                                      visualRect( subRect( SR_RadioButtonFocusRect, ceData, elementFlags, widget ), ceData, elementFlags ).width() +
                                      pixelMetric( PM_ExclusiveIndicatorWidth, ceData, elementFlags ) + 4, rb.height() ) );

                    r -= visualRect( subRect( SR_RadioButtonIndicator, ceData, elementFlags, widget ), ceData, elementFlags );
                    p->setClipRegion( r );
                    p->fillRect( radiobutton->rect(), cg.background().light( TQTC_HIGHLIGHT_FACTOR ) );
                    p->setClipping( false );
                }

                int alignment = TQApplication::reverseLayout() ? AlignRight : AlignLeft;

                drawItem( p, r, alignment | AlignVCenter | ShowPrefix, cg,
                    flags & Style_Enabled, radiobutton->pixmap(), radiobutton->text() );

                if ( radiobutton->hasFocus() )
                    drawPrimitive( PE_FocusRect, p, ceData, elementFlags,
                        visualRect( subRect( SR_RadioButtonFocusRect, ceData, elementFlags, widget ), ceData, elementFlags ), cg, flags );
                break;
            }
        default:
            TDEStyle::drawControl( control, p, ceData, elementFlags, r, cg, flags, data, widget );
    }
}

void KlearlookStyle::drawControlMask( ControlElement control, TQPainter *p, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQRect &r,
                                      const TQStyleOption &data, const TQWidget *widget ) const {
    switch ( control ) {
        case CE_PushButton:
            if ( rounded ) {
                int offset = r.width() < TQTC_MIN_BTN_SIZE || r.height() < TQTC_MIN_BTN_SIZE ? 1 : 2;

                p->fillRect( r, color0 );
                p->fillRect( r.x() + 1, r.y() + 1, r.width() - 2, r.height() - 2, color1 );
                p->setPen( color1 );
                p->drawLine( r.x() + offset, r.y(), r.x() + r.width() - ( offset + 1 ), r.y() );
                p->drawLine( r.x() + offset, r.y() + r.height() - 1,
                    r.x() + r.width() - ( offset + 1 ), r.y() + r.height() - 1 );
                p->drawLine( r.x(), r.y() + offset, r.x(), r.y() + r.height() - ( offset + 1 ) );
                p->drawLine( r.x() + r.width() - 1, r.y() + offset,
                    r.x() + r.width() - 1, r.y() + r.height() - ( offset + 1 ) );
            } else
                p->fillRect( r, color1 );
            break;
        default:
            TDEStyle::drawControlMask( control, p, ceData, elementFlags, r, data, widget );
    }
}

void KlearlookStyle::drawComplexControlMask( ComplexControl control, TQPainter *p, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags, const TQRect &r,
        const TQStyleOption &data, const TQWidget *widget ) const {
    switch ( control ) {
        case CC_ToolButton:
        case CC_ComboBox:
            drawControlMask( CE_PushButton, p, ceData, elementFlags, r, data, widget );
            break;
        default:
            TDEStyle::drawComplexControlMask( control, p, ceData, elementFlags, r, data, widget );
    }
}

TQRect KlearlookStyle::subRect( SubRect subrect, const TQStyleControlElementData &ceData, const ControlElementFlags elementFlags, const TQWidget *widget ) const {
    TQRect rect,
    wrect( widget->rect() );

    switch ( subrect ) {
        case SR_PushButtonFocusRect: {
                //            const TQPushButton *button=(const TQPushButton *)widget;
                int dbw1 = 0,
                           dbw2 = 0;

                //            if(button->isDefault() || button->autoDefault())
                //            {
                dbw1 = pixelMetric( PM_ButtonDefaultIndicator, ceData, elementFlags, widget );
                dbw2 = dbw1 * 2;
                //            }

                rect.setRect( wrect.x() + 3 + dbw1,
                              wrect.y() +3  + dbw1,
                              wrect.width() - 6 - dbw2,
                              wrect.height() - 6 - dbw2 );
                break;
            }
        case SR_CheckBoxIndicator: {
                int h = pixelMetric( PM_IndicatorHeight, ceData, elementFlags );

                rect.setRect( ( widget->rect().height() - h ) >> 1,
                              ( widget->rect().height() - h ) >> 1,
                              pixelMetric( PM_IndicatorWidth, ceData, elementFlags ),
                              h );
                break;
            }
        case SR_RadioButtonIndicator: {
                int h = pixelMetric( PM_ExclusiveIndicatorHeight, ceData, elementFlags );

                rect.setRect( ( widget->rect().height() - h ) >> 1,
                              ( widget->rect().height() - h ) >> 1,
                              pixelMetric( PM_ExclusiveIndicatorWidth, ceData, elementFlags ), h );
                break;
            }
        case SR_ProgressBarContents:
            rect = TQRect( wrect.x() + 1,
                          wrect.y() + 1,
                          wrect.width() - 2,
                          wrect.height() - 2 );
            break;
        default:
            rect = TDEStyle::subRect( subrect, ceData, elementFlags, widget );
    }

    return rect;
}

void KlearlookStyle::drawComplexControl(
        ComplexControl control,
        TQPainter *p,
        const TQStyleControlElementData &ceData,
        ControlElementFlags elementFlags,
        const TQRect &r,
        const TQColorGroup &cg,
        SFlags flags,
        SCFlags controls,
        SCFlags active,
        const TQStyleOption &data,
        const TQWidget *widget ) const
{
    if ( widget == hoverWidget )
        flags |= Style_MouseOver;

    switch ( control ) {
        case CC_ToolButton: {
        
                const TQToolButton * toolbutton = ( const TQToolButton * ) widget;
                TQRect button  ( querySubControlMetrics( control, ceData, elementFlags, SC_ToolButton, data, widget ) ),
                      menuarea( querySubControlMetrics( control, ceData, elementFlags, SC_ToolButtonMenu, data, widget ) );
                
                SFlags bflags = flags, mflags = flags;

                if ( APP_KORN == themedApp ) {
                    drawPrimitive( PE_ButtonTool, p, ceData, elementFlags, button, cg, bflags, data );
                    break;
                }

                bool onControlButtons = false,
                     onToolbar = widget->parentWidget() && ::tqt_cast<TQToolBar *>( widget->parentWidget() ),
                     onExtender = !onToolbar &&
                                  widget->parentWidget() &&
                                  widget->parentWidget() ->inherits( "TQToolBarExtensionWidget" ) &&
                                  ::tqt_cast<TQToolBar *>( widget->parentWidget() ->parentWidget() );

                if ( !onToolbar && !onExtender && widget->parentWidget() &&
                        !qstrcmp( widget->parentWidget() ->name(), "qt_maxcontrols" ) )
                    onControlButtons = true;

                if ( active & SC_ToolButton )
                    bflags |= Style_Down;
                    
                if ( active & SC_ToolButtonMenu )
                    mflags |= Style_Down;

                if ( controls & SC_ToolButton ) {
                    // If we're pressed, on, or raised...
#if TDE_VERSION >= 0x30200
                    if ( bflags & ( Style_Down | Style_On | Style_Raised ) || onControlButtons )
#else
                    // CPD: Style_MouseOver obove is *needed* for KDE's TDEToggleActions...
                    if ( bflags & ( Style_Down | Style_On | Style_Raised | Style_MouseOver ) || onControlButtons )
#endif

                    {
                        //Make sure the standalone toolbuttons have a gradient in the right direction
                        if ( !onToolbar && !onControlButtons )
                            bflags |= Style_Horizontal;

                        drawPrimitive( PE_ButtonTool, p, ceData, elementFlags, button, cg, bflags, data );
                    }

                    // Check whether to draw a background pixmap
                    else if ( toolbutton->parentWidget() &&
                              toolbutton->parentWidget() ->backgroundPixmap() &&
                              !toolbutton->parentWidget() ->backgroundPixmap() ->isNull() ) {
                        p->drawTiledPixmap( r,
                            *( toolbutton->parentWidget() ->backgroundPixmap() ), toolbutton->pos() );
                    } else if ( widget->parent() ) {
                        if ( ::tqt_cast<const TQToolBar *>( widget->parent() ) ) {
                            TQToolBar * parent = ( TQToolBar* ) widget->parent();

#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

                            if ( APPEARANCE_FLAT != appearance )
                                drawBevelGradient( cg.background(), true, 0,
                                    p, parent->rect(), true, SHADE_BAR_LIGHT, SHADE_BAR_DARK );
                            else
#endif

                                p->fillRect( parent->rect(), cg.background() );
                        } else if ( widget->parent() ->inherits( "TQToolBarExtensionWidget" ) ) {
                            TQWidget * parent = ( TQWidget* ) widget->parent();
                            TQToolBar *toolbar = ( TQToolBar* ) parent->parent();

#ifdef TQTC_GRADIENT_TOOLBARS_AND_MENUBARS

                            if ( APPEARANCE_FLAT != appearance )
                                drawBevelGradient( cg.background(), true, 0, p, toolbar->rect(),
                                    true, SHADE_BAR_LIGHT, SHADE_BAR_DARK );
                            else
#endif

                                p->fillRect( toolbar->rect(), cg.background() );
                        }
                    }
                }

                if ( controls & SC_ToolButtonMenu ) {
                    if ( mflags & ( Style_Down | Style_On | Style_Raised ) )
                        drawPrimitive( PE_ButtonDropDown, p, ceData, elementFlags, menuarea, cg, mflags, data );
                    drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, menuarea, cg, mflags, data );
                }

                if ( toolbutton->hasFocus() && !toolbutton->focusProxy() ) {
                    TQRect fr = toolbutton->rect();
                    fr.addCoords( 3, 3, -3, -3 );
                    drawPrimitive( PE_FocusRect, p, ceData, elementFlags, fr, cg );
                }
                break;
            }
        case CC_ComboBox: {
                const TQComboBox *combobox = ( const TQComboBox * ) widget;
                
                TQRect frame( TQStyle::visualRect( querySubControlMetrics( CC_ComboBox,
                             ceData,elementFlags,SC_ComboBoxFrame,data,widget ),ceData, elementFlags ) ),
                             
                      arrow( TQStyle::visualRect( querySubControlMetrics( CC_ComboBox,
                             ceData,elementFlags,SC_ComboBoxArrow,data,widget),ceData, elementFlags)),
                             
                      field( TQStyle::visualRect( querySubControlMetrics(CC_ComboBox,
                             ceData,elementFlags,SC_ComboBoxEditField,data,widget),ceData, elementFlags));
                             
                const TQColor *use = buttonColors( cg );

                if ( rounded && isFormWidget( widget ) )
                    formMode = true;

                if ( controls & SC_ComboBoxFrame && frame.isValid() ) {
                    if ( controls & SC_ComboBoxEditField && field.isValid() && combobox->editable() ) {
                        TQRect f2( field );
                        TQRegion reg( r );

                        f2.addCoords( -1, -1, 1, 1 );
                        reg -= f2;
                        p->setClipRegion( reg );
                    }
                    drawLightBevelButton( p, r, cg, flags | Style_Raised | Style_Horizontal,
                        true, ROUNDED_ALL, getFill( flags, use ),
                                          use );
                    p->setClipping( false );
                }

                if ( controls & SC_ComboBoxArrow && arrow.isValid() ) {
                    drawPrimitive( PE_ArrowDown, p, ceData, elementFlags, arrow, cg, flags & ~Style_MouseOver );
		    p->setPen( use[ 4 ].light(70) );
                    arrow.addCoords( -1, -1, -1, 1 );
		    p->drawLine( arrow.left(), arrow.top(), arrow.left(), arrow.bottom() );
		 }

                if ( controls & SC_ComboBoxEditField && field.isValid() ) {
                    if ( ( flags & Style_HasFocus ) && ( ! combobox->editable() ) ) {
                        TQRect fr = TQStyle::visualRect( subRect( SR_ComboBoxFocusRect, ceData, elementFlags, widget ), ceData, elementFlags );

                        fr.addCoords( 0, 0, -2, 0 );
                        drawPrimitive( PE_FocusRect,
                            p, ceData, elementFlags, fr, cg, flags | Style_FocusAtBorder, TQStyleOption( cg.highlight() ) );
                    }
                }

                p->setPen( flags & Style_Enabled ? cg.buttonText() : cg.mid() );
                formMode = false;
                break;
            }
        case CC_SpinWidget: {
                const TQSpinWidget *spinwidget = ( const TQSpinWidget * ) widget;
                TQRect frame( querySubControlMetrics( CC_SpinWidget, ceData, elementFlags, SC_SpinWidgetFrame, data, widget ) ),
                up( spinwidget->upRect() ),
                down( spinwidget->downRect() );

                if ( hoverWidget && spinwidget == hoverWidget )
                    flags |= Style_MouseOver;

                if ( ( controls & SC_SpinWidgetFrame ) && frame.isValid() )
                    qDrawShadePanel(
                        p, r, TQColorGroup( gray[ 5 ], gray[ NUM_SHADES ], gray[ 0 ],
                        gray[ 5 ], gray[ 2 ], cg.text(), gray[ NUM_SHADES ] ),
                        true, pixelMetric( PM_SpinBoxFrameWidth, ceData, elementFlags )
                        );

                if ( ( controls & SC_SpinWidgetUp ) && up.isValid() ) {
                    PrimitiveElement pe = PE_SpinWidgetUp;
                    SFlags upflags = flags;

                    if ( spinwidget->buttonSymbols() == TQSpinWidget::PlusMinus )
                        pe = PE_SpinWidgetPlus;
                    if ( !spinwidget->isUpEnabled() )
                        upflags ^= Style_Enabled;
                    drawPrimitive(
                        pe, p, ceData, elementFlags, up, cg,
                        upflags | ( ( active == SC_SpinWidgetUp ) ? Style_On | Style_Sunken : Style_Raised )
                    );
                }

                if ( ( controls & SC_SpinWidgetDown ) && down.isValid() ) {
                    PrimitiveElement pe = PE_SpinWidgetDown;
                    SFlags downflags = flags;

                    if ( spinwidget->buttonSymbols() == TQSpinWidget::PlusMinus )
                        pe = PE_SpinWidgetMinus;
                    if ( !spinwidget->isDownEnabled() )
                        downflags ^= Style_Enabled;
                    drawPrimitive(
                        pe, p, ceData, elementFlags, down, cg,
                        downflags | ( ( active == SC_SpinWidgetDown ) ? Style_On | Style_Sunken : Style_Raised )
                    );
                }
                const TQColor *use = backgroundColors( cg );
		p->setPen( use[ 4 ].light(80) );
		p->drawRect( r );
                break;
            }
        case CC_ScrollBar: {
                const TQScrollBar *scrollbar = ( const TQScrollBar * ) widget;
                bool hw = hoverWidget == scrollbar;
                TQRect subline( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarSubLine, data, widget ) ),
                addline( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarAddLine, data, widget ) ),
                subpage( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarSubPage, data, widget ) ),
                addpage( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarAddPage, data, widget ) ),
                slider( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarSlider, data, widget ) ),
                first( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarFirst, data, widget ) ),
                last( querySubControlMetrics( control, ceData, elementFlags, SC_ScrollBarLast, data, widget ) );

                if ( ( controls & SC_ScrollBarSubLine ) && subline.isValid() )
                    drawPrimitive(
                        PE_ScrollBarSubLine, p, ceData, elementFlags, subline, cg,
                        ( hw && HOVER_SB_SUB == hover ? Style_MouseOver : Style_Default ) |
                        Style_Enabled |
                        ( ( active == SC_ScrollBarSubLine ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default )
                    );
                if ( ( controls & SC_ScrollBarAddLine ) && addline.isValid() )
                    drawPrimitive(
                        PE_ScrollBarAddLine, p, ceData, elementFlags, addline, cg,
                        ( hw && HOVER_SB_ADD == hover ? Style_MouseOver : Style_Default ) |
                        Style_Enabled |
                        ( ( active == SC_ScrollBarAddLine ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default )
                    );
                if ( ( controls & SC_ScrollBarSubPage ) && subpage.isValid() )
                    drawPrimitive( PE_ScrollBarSubPage, p, ceData, elementFlags, subpage, cg,
                        Style_Enabled |
                        ( ( active == SC_ScrollBarSubPage ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default ) );
                if ( ( controls & SC_ScrollBarAddPage ) && addpage.isValid() )
                    drawPrimitive( PE_ScrollBarAddPage, p, ceData, elementFlags, addpage, cg,
                        ( ( scrollbar->minValue() == scrollbar->maxValue() ) ? Style_Default : Style_Enabled ) |
                        ( ( active == SC_ScrollBarAddPage ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default ) );
                if ( ( controls & SC_ScrollBarFirst ) && first.isValid() )
                    drawPrimitive( PE_ScrollBarFirst, p, ceData, elementFlags, first, cg,
                        Style_Enabled |
                        ( ( active == SC_ScrollBarFirst ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default ) );
                if ( ( controls & SC_ScrollBarLast ) && last.isValid() )
                    drawPrimitive( PE_ScrollBarLast, p, ceData, elementFlags, last, cg,
                        Style_Enabled |
                        ( ( active == SC_ScrollBarLast ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default ) );
                if ( ( controls & SC_ScrollBarSlider ) && slider.isValid() ) {
                    drawPrimitive( PE_ScrollBarSlider, p, ceData, elementFlags, slider, cg,
                        ( hw && HOVER_SB_SLIDER == hover ? Style_MouseOver : Style_Default ) |
                        Style_Enabled |
                        ( ( active == SC_ScrollBarSlider ) ? Style_Down : Style_Default ) |
                        ( ( scrollbar->orientation() == TQt::Horizontal ) ? Style_Horizontal : Style_Default ) );

                    // ### perhaps this should not be able to accept focus if maxedOut?
                    if ( scrollbar->hasFocus() )
                        drawPrimitive( PE_FocusRect, p, ceData, elementFlags,
                            TQRect( slider.x() + 2, slider.y() + 2, slider.width() - 5, slider.height() - 5 ),
                                   cg, Style_Default );
                }
                break;
            }
        case CC_Slider: {
                TQRect groove = querySubControlMetrics( CC_Slider, ceData, elementFlags, SC_SliderGroove, data, widget ),
                               handle = querySubControlMetrics( CC_Slider, ceData, elementFlags, SC_SliderHandle, data, widget );

                if ( ( controls & SC_SliderGroove ) && groove.isValid() )
                    drawSliderGroove( p, ceData, elementFlags, groove, flags, widget );
                if ( ( controls & SC_SliderHandle ) && handle.isValid() )
                    drawSliderHandle( p, handle, cg, flags );
                if ( controls & SC_SliderTickmarks )
                    TQCommonStyle::drawComplexControl(
                        control, p, ceData, elementFlags, r, cg, flags, SC_SliderTickmarks, active, data, widget
                    );
                break;
            }
        default:
            TDEStyle::drawComplexControl( control, p, ceData, elementFlags, r, cg, flags, controls, active, data, widget );
    }
}

TQRect KlearlookStyle::querySubControlMetrics( ComplexControl control, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, SubControl sc,
        const TQStyleOption &data, const TQWidget *widget ) const {
    switch ( control ) {
        case CC_SpinWidget: {
                if ( !widget )
                    return TQRect();

                int fw = pixelMetric( PM_SpinBoxFrameWidth, ceData, elementFlags, 0 );
                TQSize bs;

                bs.setHeight( widget->height() >> 1 );
                if ( bs.height() < 8 )
                    bs.setHeight( 8 );
                bs.setWidth( TQMIN( bs.height() * 8 / 6, widget->width() / 4 ) );
                bs = bs.expandedTo( TQApplication::globalStrut() );

                if ( !( bs.width() % 2 ) )
                    bs.setWidth( bs.width() + 1 );

                int extra = bs.height() * 2 == widget->height() ? 0 : 1;
                int y = 0,
                        x = widget->width() - y - bs.width(),
                            lx = fw,
                                 rx = x - fw * 2;

                switch ( sc ) {
                    case SC_SpinWidgetUp:
                        return TQRect( x, y, bs.width(), bs.height() );
                    case SC_SpinWidgetDown:
                        return TQRect( x, y + bs.height(), bs.width(), bs.height() + extra );
                    case SC_SpinWidgetButtonField:
                        return TQRect( x, y, bs.width(), widget->height() - 2 * fw );
                    case SC_SpinWidgetEditField:
                        return TQRect( lx, fw, rx, widget->height() - 2 * fw );
                    case SC_SpinWidgetFrame:
                        return TQRect( widget->x(), widget->y(), widget->width() - bs.width(), widget->height() );
                }
            }
        default:
            return TDEStyle::querySubControlMetrics( control, ceData, elementFlags, sc, data, widget );
    }
}

int KlearlookStyle::pixelMetric( PixelMetric metric, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQWidget *widget ) const {
    switch ( metric ) {
        case PM_MenuButtonIndicator:
            return 7;
        case PM_MenuBarItemSpacing: {
                return 5;
            }
        case PM_ButtonMargin:
            return 5;

        case PM_TabBarTabShiftVertical: {
                const TQTabBar *tb = ::tqt_cast<const TQTabBar *>( widget );

                return TQTabBar::RoundedAbove == tb->shape() || TQTabBar::TriangularAbove == tb->shape()
                       ? 1
                       : -1;
            }
        case PM_TabBarTabShiftHorizontal:
            return 0;

        case PM_TabBarTabVSpace: {
                const TQTabBar * tb = ( const TQTabBar * ) widget;
                if ( tb->shape() == TQTabBar::RoundedAbove ||
                        tb->shape() == TQTabBar::RoundedBelow )
                    return 12;
                else
                    return 4;
            }


        case PM_ButtonShiftHorizontal:
        case PM_ButtonShiftVertical:
            return 1;
        case PM_ButtonDefaultIndicator:
            return IND_BORDER == defBtnIndicator ? 1 : 0;
        case PM_DefaultFrameWidth:
            return borderFrame && widget && ( ::tqt_cast<const TQTabBar *>( widget ) ||
                                              ::tqt_cast<const TQWidgetStack *>( widget ) ||
                                              ::tqt_cast<const TQPopupMenu *>( widget ) )
                   ? 2
                   : TQTC_DEF_FRAME_WIDTH;
        case PM_SpinBoxFrameWidth:
            return 1;
        case PM_MenuBarFrameWidth:
            return 1;
        case PM_IndicatorWidth:
        case PM_IndicatorHeight:
            return TQTC_CHECK_SIZE;
        case PM_ExclusiveIndicatorWidth:
        case PM_ExclusiveIndicatorHeight:
            return TQTC_RADIO_SIZE;
        case PM_TabBarTabOverlap:
            return 1;
        case PM_ProgressBarChunkWidth:
            return 2;
        case PM_DockWindowSeparatorExtent:
            return 4;
        case PM_DockWindowHandleExtent:
            return 10;
        case PM_SplitterWidth:
            return 4;
        case PM_ScrollBarSliderMin:
            return 16;
        case PM_ScrollBarExtent:
        case PM_SliderControlThickness:
        case PM_SliderThickness:
            return 15;
        case PM_SliderLength:
            return 24;
        case PM_MaximumDragDistance:
            return -1;
        default:
            return TDEStyle::pixelMetric( metric, ceData, elementFlags, widget );
    }
}

int KlearlookStyle::kPixelMetric( TDEStylePixelMetric kpm, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQWidget *widget ) const {
    switch ( kpm ) {
        case KPM_MenuItemSeparatorHeight:
            return 4;
        default:
            return TDEStyle::kPixelMetric( kpm, ceData, elementFlags, widget );
    }
}

TQSize KlearlookStyle::sizeFromContents( ContentsType t,
                                        const TQStyleControlElementData &ceData,
                                        ControlElementFlags elementFlags,
                                        const TQSize &s,
                                        const TQStyleOption &opt,
                                        const TQWidget *widget ) const {
    switch ( t ) {
        case CT_PopupMenuItem: {
                if ( !widget || opt.isDefault() )
                    return s;

                const TQPopupMenu *popup = dynamic_cast<const TQPopupMenu *>( widget );
                TQMenuItem *mi = opt.menuItem();
                int maxpmw = opt.maxIconWidth();
                int w = s.width(), h = s.height();
                bool checkable = popup->isCheckable();

                if ( mi->custom() ) {
                    w = mi->custom() ->sizeHint().width();
                    h = mi->custom() ->sizeHint().height();
                    if ( !mi->custom() ->fullSpan() )
                        h += 4;
                } else if ( mi->widget() ) {
                    // don't change the size in this case.
                } else if ( mi->isSeparator() ) {
                    w = 20;
                    h = 8;
                } else {
                    if ( mi->pixmap() ) {
                        h = TQMAX( h, mi->pixmap() ->height() + 2 );
                    } else {
                        h = TQMAX( h, 21 );
                        TQSettings s;
                        if ( menuIcons )
                            h = TQMAX( h, popup->fontMetrics().height() + MENU_POPUP_ITEM_HIGH_HI );
                        else
                            h = TQMAX( h, popup->fontMetrics().height() + MENU_POPUP_ITEM_HIGH_LO );
                    }

                    if ( mi->iconSet() ) {
                        h = TQMAX( h, mi->iconSet() ->pixmap( TQIconSet::Small, TQIconSet::Normal ).height() + 2 );
                    }
                }

                if ( !mi->text().isNull() && ( mi->text().find( '\t' ) >= 0 ) ) {
                    w += itemHMargin + itemFrame * 2 + 7;
                } else if ( mi->popup() ) {
                    w += 2 * arrowHMargin;
                }

                if ( maxpmw ) {
                    w += maxpmw + 6;
                }
                if ( checkable && maxpmw < 20 ) {
                    w += 20 - maxpmw;
                }
                if ( checkable || maxpmw > 0 ) {
                    w += 12;
                }

                w += rightBorder;

                return TQSize( w-25, h );
            }

        case CT_PushButton: {
                const TQPushButton* btn = static_cast<const TQPushButton*>( widget );

                int w = s.width() + 2 * pixelMetric( PM_ButtonMargin, ceData, elementFlags, widget );
                int h = s.height() + 2 * pixelMetric( PM_ButtonMargin, ceData, elementFlags, widget );
                if ( btn->text().isEmpty() && s.width() < 32 )
                    return TQSize( w, h );
                // return button size
                return TQSize( w + 25, h + 3 );
            }

        case CT_ToolButton: {
                if ( widget->parent() && ::tqt_cast<TQToolBar*>( widget->parent() ) )
                    return TQSize( s.width() + 2 * 4, s.height() + 2 * 4 );
                else {
                    return TDEStyle::sizeFromContents ( t, ceData, elementFlags, s, opt, widget );
                }
            }

        default:
            return TDEStyle::sizeFromContents ( t, ceData, elementFlags, s, opt, widget );
    }

    return TDEStyle::sizeFromContents ( t, ceData, elementFlags, s, opt, widget );
}



int KlearlookStyle::styleHint( StyleHint stylehint, const TQStyleControlElementData &ceData, ControlElementFlags elementFlags, const TQStyleOption &option, TQStyleHintReturn *returnData, const TQWidget *widget ) const {
    switch ( stylehint ) {
        case SH_EtchDisabledText:
        case SH_Slider_SnapToValue:
        case SH_PrintDialog_RightAlignButtons:
        case SH_FontDialog_SelectAssociatedText:
        case SH_MenuBar_AltKeyNavigation:
        case SH_MenuBar_MouseTracking:
        case SH_PopupMenu_MouseTracking:
        case SH_PopupMenu_SpaceActivatesItem:
        case SH_ComboBox_ListMouseTracking:
        case SH_ScrollBar_MiddleClickAbsolutePosition:
            return 1;
        case SH_MainWindow_SpaceBelowMenuBar:
            return 0;
        case SH_ComboBox_Popup:
            return 0;
        case SH_PopupMenu_SubMenuPopupDelay:
            return 300;
        case SH_PopupMenu_AllowActiveAndDisabled:
            return 0;
        default:
            return TDEStyle::styleHint( stylehint, ceData, elementFlags, option, returnData, widget );
    }
}

void KlearlookStyle::drawPBarOrMenu(
    TQPainter *p,
    TQRect const &r,
    bool horiz,
    const TQColorGroup &cg,
    bool menu ) const
{
    switch ( pmProfile ) {
        case PROFILE_SUNKEN:
            drawGradientWithBorder( p, r, horiz );
            break;
        case PROFILE_RAISED: {
                int flags = TQStyle::Style_Raised;

                if ( horiz )
                    flags |= Style_Horizontal;

                drawLightBevel( p, r,
                    cg, flags, true,
                    menu ? ROUNDED_ALL : ROUNDED_NONE,
                    getFill( flags, menuPbar ),
                    menuPbar, true
                );
                
                break;
            }
        default:
            p->fillRect( r, menuPbar[ GRADIENT_BASE ] );
            break;
    }
}
void KlearlookStyle::drawPBarOrMenu2(
    TQPainter *p,
    TQRect const &r,
    bool horiz,
    const TQColorGroup &cg,
    bool menu ) const
{
    switch ( pmProfile ) {
        case PROFILE_SUNKEN:
            drawGradientWithBorder( p, r, horiz );
            break;
        case PROFILE_RAISED: {
                int flags = TQStyle::Style_Raised;

                if ( horiz )
                    flags |= Style_Horizontal;

                drawLightBevel( p, r,
                    cg, flags, true,
                    menu ? ROUNDED_TOP : ROUNDED_NONE,
                    getFill( flags, menuPbar ),
                    menuPbar, true
                );
                
                break;
            }
        default:
            p->fillRect( r, menuPbar[ GRADIENT_BASE ] );
            break;
    }
}

void KlearlookStyle::drawGradientWithBorder(
    TQPainter *p,
    TQRect const &r,
    bool horiz ) const
{
    TQRect r2( r );

    drawGradient( menuPbar[ GRADIENT_TOP ],
        menuPbar[ GRADIENT_BOTTOM ], true, borderFrame ? 2 : 1, p, r, horiz );
    // 3d border effect...
    if ( borderFrame ) {
        p->setPen( menuPbar[ GRADIENT_BASE ] );
        p->setBrush( NoBrush );
        p->drawRect( r );
    } else
        r2.addCoords( -1, -1, 1, 1 );

    p->setPen( menuPbar[ GRADIENT_LIGHT ] );
    p->drawLine( r2.left() + 1, r2.top() + 1, r2.right() - 1, r2.top() + 1 );
    p->drawLine( r2.left() + 1, r2.top() + 1, r2.left() + 1, r2.bottom() - 1 );
    p->setPen( menuPbar[ GRADIENT_DARK ] );
    p->drawLine( r2.left() + 1, r2.bottom() - 1, r2.right() - 1, r2.bottom() - 1 );
    p->drawLine( r2.right() - 1, r2.bottom() - 1, r2.right() - 1, r2.top() + 1 );
}

void KlearlookStyle::drawBevelGradient( 
    const TQColor &base, 
    bool increase, 
    int border, 
    TQPainter *p, 
    TQRect const &r,
    bool horiz, double shadeTop, double shadeBot ) 
const {
    //CPD TODO: Store last settings to make faster!
    TQColor top, bot;

    if ( equal( 1.0, shadeTop ) )
        top = base;
    else
        shade( base, &top, shadeTop );
    if ( equal( 1.0, shadeBot ) )
        bot = base;
    else
        shade( base, &bot, shadeBot );

    drawGradient( top, bot, increase, border, p, r, horiz );
}

void KlearlookStyle::drawGradient( 
	const TQColor &top, 
	const TQColor &bot, 
	bool increase, 
	int border, 
	TQPainter *p, 
	TQRect const &r, 
	bool horiz ) const 
{
    if ( r.width() > 0 && r.height() > 0 ) {
        TQRect grad(
            r.left() + border,
            r.top() + border,
            r.width() - ( border * 2 ),
            r.height() - ( border * 2 )
        );

        if ( top == bot )
           p->fillRect( grad, top );
        else {
            TQRect grad(
                r.left() + border,
                r.top() + border,
                r.width() - ( border * 2 ),
                r.height() - ( border * 2 )
            );
            
            int i,
            s = horiz ? grad.top() : grad.left(),
                e = horiz ? grad.bottom() : grad.right();

            double amt = ( horiz ? grad.height() : grad.width() ) ,
                   dr = ( ( double ) ( bot.red() - top.red() ) ) / amt ,
                   dg = ( ( double ) ( bot.green() - top.green() ) ) / amt ,
                   db = ( ( double ) ( bot.blue() - top.blue() ) ) / amt,
                   rc = 0, gc = 0, bc = 0;

            if ( increase )
                for ( i = s; i <= e ; i++ ) {
                    p->setPen( TQColor(
                            limit( top.red() + rc ),
                            limit( top.green() + gc ),
                            limit( top.blue() + bc )
                        ));
                      
                    if ( horiz )
                        p->drawLine( grad.left(), i, grad.right(), i );
                    else
                        p->drawLine( i, grad.top(), i, grad.bottom() );
                    rc += dr;
                    gc += dg;
                    bc += db;
                }
            else
                for ( i = e; i >= s; i-- ) {
                    p->setPen(
                        TQColor(
                            limit( top.red() + rc ),
                            limit( top.green() + gc ),
                            limit( top.blue() + bc )
                         ) );
                         
                    if ( horiz )
                        p->drawLine( grad.left(), i, grad.right(), i );
                        
                    else
                        p->drawLine( i, grad.top(), i, grad.bottom() );
                        
                    rc += dr;
                    gc += dg;
                    bc += db;
                }
        }
    }
}


void KlearlookStyle::drawPopupRect( TQPainter *p, const TQRect &r, const TQColorGroup &cg ) const
{
    const TQColor *use = backgroundColors( cg );
    p->setPen( use[ 4 ].light(70) );
    p->setBrush( NoBrush );
    p->drawRect( r );
}

void KlearlookStyle::drawSliderHandle(
    TQPainter *p,
    const TQRect &r,
    const TQColorGroup &cg, TQStyle::SFlags flags
) const
{
    const TQColor * use = buttonColors( cg );

    if ( r.width() > r.height() )
        flags |= Style_Horizontal;
    flags |= Style_Raised;

    drawLightBevelButton( p, r, cg, flags, true, ROUNDED_ALL, getFill( flags, use ), use );

    if ( GROOVE_NONE != sliderThumbs &&
       ( ( flags & Style_Horizontal && r.width() >= 14 ) || r.height() >= 14 ) )
        drawLines( p, r,
            r.width() < r.height(),
            4, 3, use, 0,
            GROOVE_SUNKEN == sliderThumbs,
            APPEARANCE_LIGHT_GRADIENT == appearance );
}

void KlearlookStyle::drawSliderGroove
    ( TQPainter *p,
      const TQStyleControlElementData &ceData,
      ControlElementFlags elementFlags,
      const TQRect &r,
      TQStyle::SFlags flags,
      const TQWidget *widget ) const
{
    const TQSlider * slider = ( const TQSlider * ) widget;
    TQRect groove( r );

    if ( flags & Style_HasFocus ) {
        TQRect fr( groove );

        fr.addCoords( -1, -1, 1, 1 );
        drawPrimitive( PE_FocusRect, p, ceData, elementFlags, fr, TQColorGroup() );
    }

    if ( TQt::Horizontal == slider->orientation() ) {
        int dh = ( groove.height() - 5 ) >> 1;

        groove.addCoords( 0, dh, 0, -dh );
    } else {
        int dw = ( groove.width() - 5 ) >> 1;

        groove.addCoords( dw, 0, -dw, 0 );
    }
    p->setBrush( gray[ 2 ] );
    p->setPen( gray[ 5 ] );
    p->drawRect( groove );
    p->setPen( gray[ 4 ] );
    p->drawLine( groove.x() + 1, groove.y() + 1, groove.x() + groove.width() - 2, groove.y() + 1 );
    p->drawLine( groove.x() + 1, groove.y() + 1, groove.x() + 1, groove.y() + groove.height() - 2 );
}

void KlearlookStyle::shadeColors( const TQColor &base, TQColor *vals ) const {
    TQTC_SHADES

    int i;

    for ( i = 0; i < NUM_SHADES; ++i )
        shade( base, &vals[ i ], TQTC_SHADE( appearance, contrast, i ) );
        
    vals[ NUM_SHADES ] = base;
}

const TQColor * KlearlookStyle::buttonColors( const TQColorGroup &cg ) const {
    if ( cg.button() != button[ NUM_SHADES ] ) {
        shadeColors( cg.button(), buttonColoured );
        return buttonColoured;
    }

    return button;
}

const TQColor * KlearlookStyle::backgroundColors( const TQColorGroup &cg ) const {
    if ( cg.background() != gray[ NUM_SHADES ] ) {
        shadeColors( cg.background(), backgroundColoured );
        return backgroundColoured;
    }

    return gray;
}

bool KlearlookStyle::redrawHoverWidget() {
    if ( !hoverWidget )
        return false;

    const TQStyleControlElementData &hoverCeData = populateControlElementDataFromWidget(hoverWidget, TQStyleOption());
    ControlElementFlags hoverElementFlags = getControlElementFlagsForObject(hoverWidget, TQStyleOption());

    TQPoint cursor( TQCursor::pos() ),
    widgetZero( hoverWidget->mapToGlobal( TQPoint( 0, 0 ) ) );

    //
    // TQt>=3.2 sets the sensitive part of a check/radio to the image + label -> anything else
    // is not sensitive. But,
    // the widget can ocupy a larger area - and this whole are will react to mouse over.
    // This needs to be coounteracted
    // so that it looks as if only the sensitive area mouse-overs...
    TQRadioButton *rb = dynamic_cast<TQRadioButton *>( hoverWidget );

    if ( rb ) {
        TQRect rect( widgetZero.x(), widgetZero.y(),
            visualRect( subRect( SR_RadioButtonFocusRect, hoverCeData, hoverElementFlags, rb ), hoverCeData, hoverElementFlags ).width() +
            pixelMetric( PM_ExclusiveIndicatorWidth, hoverCeData, hoverElementFlags ) + 4, hoverWidget->height() );

        hover = rect.contains( cursor ) ? HOVER_RADIO : HOVER_NONE;
        return ( HOVER_NONE != hover && !rect.contains( oldCursor ) ) ||
               ( HOVER_NONE == hover && rect.contains( oldCursor ) );
    } else {
        TQCheckBox *cb = dynamic_cast<TQCheckBox *>( hoverWidget );

        if ( cb ) {
            TQRect rect( widgetZero.x(), widgetZero.y(),
                visualRect( subRect( SR_CheckBoxFocusRect, hoverCeData, hoverElementFlags, cb ), hoverCeData, hoverElementFlags ).width() +
                        pixelMetric( PM_IndicatorWidth, hoverCeData, hoverElementFlags ) + 4, hoverWidget->height() );

            hover = rect.contains( cursor ) ? HOVER_CHECK : HOVER_NONE;
            return ( HOVER_NONE != hover && !rect.contains( oldCursor ) ) ||
                   ( HOVER_NONE == hover && rect.contains( oldCursor ) );
        } else {
            TQScrollBar *sb = dynamic_cast<TQScrollBar *>( hoverWidget );

            if ( sb )    // So, are we over add button, sub button, slider, or none?
            {
                TQRect subline( querySubControlMetrics( CC_ScrollBar, hoverCeData, hoverElementFlags, SC_ScrollBarSubLine, TQStyleOption::Default, hoverWidget ) ),
                addline( querySubControlMetrics( CC_ScrollBar, hoverCeData, hoverElementFlags, SC_ScrollBarAddLine, TQStyleOption::Default, hoverWidget ) ),
                slider( querySubControlMetrics( CC_ScrollBar, hoverCeData, hoverElementFlags, SC_ScrollBarSlider, TQStyleOption::Default, hoverWidget ) );

                subline.moveLeft( subline.x() + widgetZero.x() );
                subline.moveTop( subline.y() + widgetZero.y() );
                addline.moveLeft( addline.x() + widgetZero.x() );
                addline.moveTop( addline.y() + widgetZero.y() );
                slider.moveLeft( slider.x() + widgetZero.x() );
                slider.moveTop( slider.y() + widgetZero.y() );

                if ( slider.contains( cursor ) )
                    hover = HOVER_SB_SLIDER;
                else if ( subline.contains( cursor ) )
                    hover = HOVER_SB_SUB;
                else if ( addline.contains( cursor ) )
                    hover = HOVER_SB_ADD;
                else
                    hover = HOVER_NONE;

                return ( HOVER_SB_SLIDER == hover && !slider.contains( oldCursor ) ) ||
                       ( HOVER_SB_SLIDER != hover && slider.contains( oldCursor ) ) ||
                       ( HOVER_SB_SUB == hover && !subline.contains( oldCursor ) ) ||
                       ( HOVER_SB_SUB != hover && subline.contains( oldCursor ) ) ||
                       ( HOVER_SB_ADD == hover && !addline.contains( oldCursor ) ) ||
                       ( HOVER_SB_ADD != hover && addline.contains( oldCursor ) );
            } else {
#if TDE_VERSION >= 0x30400
                TQToolButton *tb = dynamic_cast<TQToolButton *>( hoverWidget );

                if ( tb ) {
                    hover = APP_KICKER == themedApp ? HOVER_KICKER : HOVER_NONE;
                    return HOVER_KICKER == hover;
                } else {
#endif
                    TQHeader *hd = dynamic_cast<TQHeader *>( hoverWidget );

                    if ( hd ) {
                        // Hmm... this ones tricky, as there's only 1 widget - but it has different sections...
                        // and the ones that aren't clickable should not highlight on mouse over!

                        TQRect rect(
                            widgetZero.x(),
                            widgetZero.y(),
                            hoverWidget->width(),
                            hoverWidget->height()
                        );
                        
                        int s = 0;
                        bool redraw = false;

                        hover = rect.contains( cursor ) ? HOVER_HEADER : HOVER_NONE;
                        hoverSect = TQTC_NO_SECT;

                        for ( s = 0; s < hd->count() && ( TQTC_NO_SECT == hoverSect || !redraw ); ++s ) {
                            TQRect r( hd->sectionRect( s ) );

                            r.moveLeft( r.x() + widgetZero.x() );
                            r.moveTop( r.y() + widgetZero.y() );

                            bool hasNew = r.contains( cursor );

                            if ( hasNew )
                                hoverSect = s;

                            if ( !redraw ) {
                                bool hasOld = r.contains( oldCursor );

                                if ( ( hasNew && !hasOld ) || ( !hasNew && hasOld ) )
                                    redraw = true;
                            }
                        }
                        return redraw;
                    } else
                        return oldCursor == TQPoint( -1, -1 );
#if TDE_VERSION >= 0x30400

                }
#endif

            }
        }
    }

    return false;
}

#define gdouble double

EDefBtnIndicator qtc_to_ind( const char *str ) {
    if ( 0 == memcmp( str, "fontcolour", 10 ) )
        return IND_FONT_COLOUR;
    if ( 0 == memcmp( str, "border", 6 ) )
        return IND_BORDER;
    if ( 0 == memcmp( str, "none", 4 ) )
        return IND_NONE;
    return IND_CORNER;
}

EGroove qtc_to_groove( const char *str ) {
    if ( 0 == memcmp( str, "raised", 6 ) )
        return GROOVE_RAISED;
    if ( 0 == memcmp( str, "none", 4 ) )
        return GROOVE_NONE;
    return GROOVE_SUNKEN;
}

ETBarBorder qtc_to_tbar_border( const char *str ) {
    if ( 0 == memcmp( str, "dark", 4 ) )
        return TB_DARK;
    if ( 0 == memcmp( str, "none", 4 ) )
        return TB_NONE;
    if ( 0 == memcmp( str, "light", 5 ) )
        return TB_LIGHT;
    return TB_LIGHT;
}

ELvExpander qtc_to_lv_expander( const char *str ) {
    return 0 == memcmp( str, "arrow", 5 ) ? LV_EXP_ARR : LV_EXP_PM;
}

ELvLines qtc_to_lv_lines( const char *str ) {
    if ( 0 == memcmp( str, "none", 4 ) )
        return LV_LINES_NONE;
    if ( 0 == memcmp( str, "dotted", 6 ) )
        return LV_LINES_DOTTED;
    return LV_LINES_SOLID;
}

EProfile qtc_to_profile( const char *str ) {
    if ( 0 == memcmp( str, "flat", 4 ) )
        return PROFILE_FLAT;
    if ( 0 == memcmp( str, "raised", 6 ) )
        return PROFILE_RAISED;
    return PROFILE_SUNKEN;
}

EAppearance qtc_to_appearance( const char *str ) {
    if ( 0 == memcmp( str, "flat", 4 ) )
        return APPEARANCE_FLAT;
    if ( 0 == memcmp( str, "gradient", 8 ) )
        return APPEARANCE_GRADIENT;
    return APPEARANCE_LIGHT_GRADIENT;
}


#include "klearlook.moc"
