/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.
 
    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>
 
    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.
 
    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.
 
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/


#include "FloatEdit.h"

#include "gui/widgets/HSpinBox.h"
#include <kdialogbase.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqstring.h>
#include <tqvbox.h>
#include <tqwidget.h>
#include <cmath>

namespace Rosegarden
{

FloatEdit::FloatEdit(TQWidget *parent,
                     const TQString &title,
                     const TQString &text,
                     float min,
                     float max,
                     float value,
                     float step):
        KDialogBase(parent, "rosegardenFloatEdit", true, title, Ok | Cancel, Ok)
{
    TQVBox *vbox = makeVBoxMainWidget();
    TQGroupBox *groupBox = new TQGroupBox(1, TQt::Horizontal, text, vbox);
    TQVBox *inVbox = new TQVBox(groupBox);

    // Calculate decimal points according to the step size
    //
    double calDP = log10(step);
    int dps = 0;
    if (calDP < 0.0)
        dps = int( -calDP);
    //std::cout << "CAL DP = " << calDP << ", dps = " << dps << std::endl;

    m_spin = new HSpinBox(inVbox, value, 1, min, max, dps);
    new TQLabel(TQString("(min: %1, max: %2)").arg(min).arg(max), inVbox);
}

float
FloatEdit::getValue() const
{
    return m_spin->valuef();
}

}
#include "FloatEdit.moc"
