/***************************************************************************
                          kmymoneybriefschedule.cpp  -  description
                             -------------------
    begin                : Sun Jul 6 2003
    copyright            : (C) 2000-2003 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// TQt Includes

#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqtextedit.h>
#include <tqtoolbutton.h>

// ----------------------------------------------------------------------------
// TDE Includes

#include <tdeglobal.h>
#include <tdelocale.h>
#include <kiconloader.h>
#include <kpushbutton.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/mymoneyscheduled.h>
#include "kmymoneybriefschedule.h"
#include "../kmymoneyutils.h"

KMyMoneyBriefSchedule::KMyMoneyBriefSchedule(TQWidget *parent, const char *name )
  : kScheduleBriefWidget(parent,name, WStyle_Customize | WStyle_NoBorder)
{
  TDEIconLoader *ic = TDEGlobal::iconLoader();
  m_nextButton->setPixmap(BarIcon(TQString::fromLatin1("1rightarrow")));
  m_prevButton->setPixmap(BarIcon(TQString::fromLatin1("1leftarrow")));

  connect(m_prevButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotPrevClicked()));
  connect(m_nextButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotNextClicked()));
  connect(m_closeButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(hide()));
  connect(m_skipButton, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotSkipClicked()));
  connect(m_buttonEnter, TQ_SIGNAL(clicked()), this, TQ_SLOT(slotEnterClicked()));

  KGuiItem skipGuiItem(  i18n("&Skip"),
                          TQIconSet(ic->loadIcon("media-seek-forward", TDEIcon::Small, TDEIcon::SizeSmall)),
                          i18n("Skip this transaction"),
                          i18n("Use this button to skip this transaction"));
  m_skipButton->setGuiItem(skipGuiItem);

  KGuiItem enterGuiItem(  i18n("&Enter"),
                          TQIconSet(ic->loadIcon("key_enter", TDEIcon::Small, TDEIcon::SizeSmall)),
                          i18n("Record this transaction into the register"),
                          i18n("Use this button to record this transaction"));
  m_buttonEnter->setGuiItem(enterGuiItem);
}

KMyMoneyBriefSchedule::~KMyMoneyBriefSchedule()
{
}

void KMyMoneyBriefSchedule::setSchedules(TQValueList<MyMoneySchedule> list, const TQDate& date)
{
  m_scheduleList = list;
  m_date = date;

  m_index = 0;
  if (list.count() >= 1)
  {
    loadSchedule();
  }
}

void KMyMoneyBriefSchedule::loadSchedule()
{
  try
  {
    if (m_index < m_scheduleList.count())
    {
      MyMoneySchedule sched = m_scheduleList[m_index];

      m_indexLabel->setText(i18n("%1 of %2")
                              .arg(TQString::number(m_index+1))
                              .arg(TQString::number(m_scheduleList.count())));
      m_name->setText(sched.name());
      m_type->setText(KMyMoneyUtils::scheduleTypeToString(sched.type()));
      m_account->setText(sched.account().name());
      TQString text;
      MyMoneyMoney amount = sched.transaction().splitByAccount(sched.account().id()).value();
      amount = amount.abs();

      if (sched.willEnd())
      {
        int transactions = sched.paymentDates(m_date, sched.endDate()).count()-1;
        text = i18n("Payment on %1 for %2 with %3 transactions remaining occuring %4.")
                .arg(TDEGlobal::locale()->formatDate(m_date, true))
                .arg(amount.formatMoney(sched.account().fraction()))
                .arg(TQString::number(transactions))
                .arg(i18n(sched.occurenceToString().utf8()));
      } else {
        text = i18n("Payment on %1 for %2 occuring %4.")
                .arg(TDEGlobal::locale()->formatDate(m_date, true))
                .arg(amount.formatMoney(sched.account().fraction()))
                .arg(i18n(sched.occurenceToString().utf8()));
      }

      if (m_date < TQDate::currentDate())
      {
        if (sched.isOverdue())
        {
          TQDate startD = (sched.lastPayment().isValid()) ?
            sched.lastPayment() :
            sched.startDate();

          if (m_date.isValid())
            startD = m_date;

          int days = startD.daysTo(TQDate::currentDate());
          int transactions = sched.paymentDates(startD, TQDate::currentDate()).count();

          text += "<br><font color=red>";
          text += i18n("%1 days overdue (%2 occurences).")
                      .arg(TQString::number(days))
                      .arg(TQString::number(transactions));
          text += "</color>";
        }
      }

      m_details->setText(text);

      m_prevButton->setEnabled(true);
      m_nextButton->setEnabled(true);
      m_skipButton->setEnabled(sched.occurencePeriod() != MyMoneySchedule::OCCUR_ONCE);

      if (m_index == 0)
        m_prevButton->setEnabled(false);
      if (m_index == (m_scheduleList.count()-1))
        m_nextButton->setEnabled(false);
    }
  }
  catch (MyMoneyException *e)
  {
    delete e;
  }
}

void KMyMoneyBriefSchedule::slotPrevClicked()
{
  if (m_index >= 1)
  {
    --m_index;
    loadSchedule();
  }
}

void KMyMoneyBriefSchedule::slotNextClicked()
{
  if (m_index < (m_scheduleList.count()-1))
  {
    m_index++;
    loadSchedule();
  }
}

void KMyMoneyBriefSchedule::slotEnterClicked()
{
  hide();
  emit enterClicked(m_scheduleList[m_index], m_date);
}

void KMyMoneyBriefSchedule::slotSkipClicked()
{
  hide();
  emit skipClicked(m_scheduleList[m_index], m_date);
}

#include "kmymoneybriefschedule.moc"
