/***************************************************************************
                          proto_base.h  -  description
                             -------------------
    begin                : Sat Oct 26 2002
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PROTO_BASE_H
#define PROTO_BASE_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqvaluelist.h>
#include "command.h"
#include "definitions.h"

/**
  *@author Troy Corbin Jr.
  */
typedef TQValueList<Command> CommandList;

class proto_base : public TQObject
{
	TQ_OBJECT
  
	public:
											proto_base( const int ID );
		virtual						~proto_base();
		int								getID( void );
		void							setID( const int ID );

	public slots:
		virtual void			parse( const Command& ) = 0;
		virtual void			parse( const TQString& ) = 0;

	signals:
		void							output( const TQString& );
		void							output( const Command& );

	protected:
		int								myID;
		ChessMove					myMove;
};

#endif
