/* ============================================================
 *
 * This file is a part of digiKam project
 * http://www.digikam.org
 * 
 * Date        : 2005-04-24
 * Description : icon view.
 *
 * Copyright (C) 2005 by Renchi Raju <renchi@pooh.tam.uiuc.edu>
 * Copyright (C) 2006-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

#ifndef ICONVIEW_H
#define ICONVIEW_H

// TQt includes.

#include <tqscrollview.h>

// Local includes.

#include "digikam_export.h"

class TQPainter;
class TQMouseEvent;
class TQPaintEvent;
class TQDropEvent;
class TQPoint;

namespace Digikam
{

class IconItem;
class IconGroupItem;
class IconViewPriv;

class DIGIKAM_EXPORT IconView : public TQScrollView
{
    TQ_OBJECT

public:

    IconView(TQWidget* parent=0, const char* name=0);
    virtual ~IconView();

    IconGroupItem* firstGroup() const;
    IconGroupItem* lastGroup() const;
    IconGroupItem* findGroup(const TQPoint& pos);

    IconItem* firstItem() const;
    IconItem* lastItem() const;
    IconItem* currentItem() const;
    IconItem* findItem(const TQPoint& pos);
    
    void setCurrentItem(IconItem* item);

    int  count() const;
    int  countSelected() const;
    int  groupCount() const;

    virtual void clear(bool update=true);
    void sort();

    void clearSelection();
    void selectAll();
    void invertSelection();
    
    void selectItem(IconItem* item, bool select);

    /** Define the item which is visible after changing an album 
        (applies both to physical and virtual albums, like tags and date view). */
    void setStoredVisibleItem(IconItem *item);
 
    void triggerRearrangement();
    
    void insertGroup(IconGroupItem* group);
    void takeGroup(IconGroupItem* group);

    void insertItem(IconItem* item);
    void takeItem(IconItem* item);

    void ensureItemVisible(IconItem *item);
    IconItem* findFirstVisibleItem(const TQRect& r, bool useThumbnailRect = true) const;
    IconItem* findLastVisibleItem(const TQRect& r, bool useThumbnailRect = true) const;
    IconItem* findFirstVisibleItem(bool useThumbnailRect = true) const;
    IconItem* findLastVisibleItem(bool useThumbnailRect = true) const;

    virtual TQRect itemRect() const;
    virtual TQRect bannerRect() const;

    TQRect contentsRectToViewport(const TQRect& r) const;

    void setEnableToolTips(bool val);

    void setDelayedRearrangement(bool delayed);

protected:

    virtual void viewportPaintEvent(TQPaintEvent* pe);
    virtual void resizeEvent(TQResizeEvent* e);
    virtual void contentsMousePressEvent(TQMouseEvent* e);
    virtual void contentsMouseMoveEvent(TQMouseEvent* e);
    virtual void contentsMouseReleaseEvent(TQMouseEvent* e);
    virtual void contentsMouseDoubleClickEvent(TQMouseEvent *e);
    virtual void contentsWheelEvent(TQWheelEvent* e);
    virtual void leaveEvent(TQEvent *e);
    virtual void focusOutEvent(TQFocusEvent* e);
    virtual void keyPressEvent(TQKeyEvent* e);

    virtual void startDrag();

    void drawFrameRaised(TQPainter* p);
    void drawFrameSunken(TQPainter* p);

    virtual bool acceptToolTip(IconItem* , const TQPoint&);

private:

    bool arrangeItems();
    void rebuildContainers();
    void appendContainer();
    void deleteContainers();

    void drawRubber(TQPainter* p);

    void itemClickedToOpen(IconItem* item);

    bool anchorIsBehind() const;

    void startRearrangeTimer();

    static int cmpItems(const void *n1, const void *n2);
    
signals:

    void signalSelectionChanged();
    void signalRightButtonClicked(IconItem* item, const TQPoint& pos);
    void signalRightButtonClicked(const TQPoint& pos);
    void signalDoubleClicked(IconItem* item);
    void signalReturnPressed(IconItem* item);
    void signalShowToolTip(IconItem* item);
    
public slots:

    void slotRearrange();

private slots:

    void slotToolTip();

private:

    IconViewPriv* d;
};

}  // namespace Digikam
    
#endif /* ICONVIEW_H */
