/***************************************************************************
*   Copyright (C) 2005 by                                                 *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "ingredientgroupsdialog.h"

#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqvbox.h>

#include <tdelocale.h>
#include <kdialog.h>

#include "widgets/krelistview.h"
#include "widgets/headerlistview.h"

IngredientGroupsDialog::IngredientGroupsDialog( RecipeDB *db, TQWidget *parent, const char *name ) : TQWidget(parent,name), database(db)
{
	TQHBoxLayout* layout = new TQHBoxLayout( this, KDialog::marginHint(), KDialog::spacingHint() );

	headerListView = new KreListView ( this, i18n( "Header list" ), true, 0 );
	StdHeaderListView *list_view = new StdHeaderListView( headerListView, database, true );
	headerListView->setListView( list_view );
	headerListView->setSizePolicy( TQSizePolicy( TQSizePolicy::Ignored, TQSizePolicy::MinimumExpanding ) );
	layout->addWidget(headerListView);

  TQVBoxLayout *buttonLayout = new TQVBoxLayout(NULL, 0, KDialog::spacingHint());
	TQPushButton *addHeaderButton = new TQPushButton( this );
	addHeaderButton->setText( "+" );
	addHeaderButton->setMinimumSize( TQSize( 30, 30 ) );
	addHeaderButton->setMaximumSize( TQSize( 30, 30 ) );
	addHeaderButton->setSizePolicy( TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed ) );
	addHeaderButton->setFlat( true );
	buttonLayout->addWidget(addHeaderButton);

	TQSpacerItem* spacer_buttons = new TQSpacerItem( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::Fixed );
	buttonLayout->addItem( spacer_buttons );

	TQPushButton *removeHeaderButton = new TQPushButton( this );
	removeHeaderButton->setText( "-" );
	removeHeaderButton->setMinimumSize( TQSize( 30, 30 ) );
	removeHeaderButton->setMaximumSize( TQSize( 30, 30 ) );
	removeHeaderButton->setSizePolicy( TQSizePolicy( TQSizePolicy::Fixed, TQSizePolicy::Fixed ) );
	removeHeaderButton->setFlat( true );
	buttonLayout->addWidget(removeHeaderButton);

	TQSpacerItem* spacer_below_buttons = new TQSpacerItem( 10, 10, TQSizePolicy::Fixed, TQSizePolicy::MinimumExpanding );
	buttonLayout->addItem( spacer_below_buttons );

	layout->addLayout(buttonLayout);

	connect( addHeaderButton, TQ_SIGNAL( clicked() ), list_view, TQ_SLOT( createNew() ) );
	connect( removeHeaderButton, TQ_SIGNAL( clicked() ), list_view, TQ_SLOT( remove() ) );
}

void IngredientGroupsDialog::reload( ReloadFlags flag )
{
	( ( StdHeaderListView* ) headerListView->listView() ) ->reload(flag);
}
