
#ifndef LISTBOXLINK_H
#define LISTBOXLINK_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqlistbox.h>

class TDEListBox;
class TQPainter;
class TQPixmap;
class TQStringList;
class KURL;

class ListBoxLink : public TQListBoxPixmap
{
friend class DnDListBox;

public:
   ListBoxLink(const TQString & icon, uint size, const TQString & title, const TQString & url);
   ListBoxLink(const TQPixmap & pixmap, const TQString & title, const TQString & url);
   ListBoxLink(ListBoxLink & link);
   ~ListBoxLink();
   TQString & URL(){return url_;}
   void setURL(const TQString & url);
   TQString & icon(){return icon_;}
   void setIcon(const TQString & icon);
   int height ( const TQListBox * lb ) const;

private:
   TQString url_; //TODO: make this KURL?!
   TQString icon_;
};

class ListBoxDevice : public ListBoxLink
{
   friend class MediaListBox;
public:
   ListBoxDevice(const TQString & icon, uint size, const TQString & title, const TQString & url, const TQString & name, const TQString & mountPoint, bool mounted, bool ejectable = false, bool removable = false, int id = 0);
   ListBoxDevice(const TQPixmap & pixmap, const TQString & title, const TQString & url, const TQString & name, const TQString & mountPoint, bool mounted, bool ejectable = false, bool removable = false, int id = 0);
   ~ListBoxDevice(){};
   TQString & name(){return name_;}
   bool mounted(){return mounted_;}
   bool ejectable(){return ejectable_;}
   bool removable(){return removable_;}
   TQString & mountPoint(){return mountPoint_;}
   int id(){return id_;}
   int width ( const TQListBox * lb ) const;

protected:
   void paint( TQPainter * p );

private:
   TQString name_;
   TQString mountPoint_;
   bool mounted_;
   bool ejectable_;
   bool removable_;
   int id_;
};

#endif
