//////////////////////////////////////////////////////////////////////////////
// baghiraconfig.h
// -------------------
// Config module for Baghira window decoration
// -------------------
// Copyright (c) 2004 Thomas Lübking
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
// IN THE SOFTWARE.
//////////////////////////////////////////////////////////////////////////////

#ifndef BAGHIRACONFIG_H
#define BAGHIRACONFIG_H

#include <tqobject.h>
#include <tqdialog.h>
#include <tqvaluelist.h>
#include "colorpicker.h"
#include "aquariusbutton.h"

class TDEConfig;
class TQSettings;
class ConfigDialog;
class TQLabel;
class TQVBoxLayout;
class TQHBoxLayout;
class TQGridLayout;
class TQPushButton;
class TQComboBox;

class ButtonColors : public TQDialog
{
    TQ_OBJECT
public:
    ButtonColors(TQWidget* parent, const char * name = 0);
    ~ButtonColors();
    ColorPicker *inactiveColor;
    ColorPicker *closeColor;
    ColorPicker *minColor;
    ColorPicker *maxColor;
    ColorPicker *menuColor;
    ColorPicker *helpColor;
    ColorPicker *stickyColor;
    ColorPicker *aboveColor;
    ColorPicker *behindColor;
    ColorPicker *shadeColor;
    ColorPicker *currentPicker;
    
    AquariusButton *inactiveButton;
    AquariusButton *closeButton;
    AquariusButton *minButton;
    AquariusButton *maxButton;
    AquariusButton *menuButton;
    AquariusButton *helpButton;
    AquariusButton *stickyButton;
    AquariusButton *aboveButton;
    AquariusButton *behindButton;
    AquariusButton *shadeButton;
    
    TQHBoxLayout *twoButts;
    TQPushButton *cancel;
    TQPushButton *ok;
    TQComboBox *presets_;
    bool save;
    
public slots:
//     void defaults();
    void setColorGroup(int);
    void init();
    
    
private:

/*
    |------------|---|
    | Indicator  | B |
    |------------|---|
    |            | T |
    |   Picker   |---|
    |            | N |
    |------------|---|
*/

    TQVBoxLayout *buttonLayout;
    TQVBoxLayout *pickerLayout;
    TQGridLayout *layout;
    TQLabel *indicator;
    
    void setPicker(ColorPicker *picker);
    
private slots:
    void activateInactive();
    void activateClose();
    void activateMin();
    void activateMax();
    void activateMenu();
    void activateHelp();
    void activateSticky();
    void activateAbove();
    void activateBehind();
    void activateShade();
    void setSave(){
        save = true;
    }
    void reset();
};

class CustomDecoSettings;

class BaghiraConfig : public TQObject
{
    TQ_OBJECT
public:
    BaghiraConfig(TDEConfig* config, TQWidget* parent);
    ~BaghiraConfig();
    
signals:
    void changed();

public slots:
    void load(TDEConfig* conf);
    void save(TDEConfig* conf);
    void defaults();

private:
//     TQSettings *config_;
   ConfigDialog *dialog_;
   ButtonColors *buttonDialog_;
   typedef TQValueList<CustomDecoSettings> DecoList;
   DecoList decoList;
};


#endif // BAGHIRACONFIG_H
