/***************************************************************************
 *   Copyright (C) 2003 by S�astien Laot                                 *
 *   slaout@linux62.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/

#ifndef FORMATIMPORTER_H
#define FORMATIMPORTER_H

#include <tqobject.h>
//#include <tqwidget.h>
#include <tqdom.h>

namespace TDEIO {
	class Job;
}

/**
  * @author S�astien Laot
  */
class FormatImporter : TQObject
{
  TQ_OBJECT
  
  public:
	static bool shouldImportBaskets();
	static void importBaskets();
	static TQDomElement importBasket(const TQString &folderName);

	void copyFolder(const TQString &folder, const TQString &newFolder);
	void moveFolder(const TQString &folder, const TQString &newFolder);
  private slots:
	void slotCopyingDone(TDEIO::Job*);
  private:
	bool copyFinished;
};

#endif // FORMATIMPORTER_H
