/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "qalculateconvertnumberbasesdialog.h"
#include "qalculate_tde_utils.h"
#include <string>
#include <tdelocale.h>
#include <tqgrid.h>
#include <tqlabel.h>
#include <klineedit.h>
#include <tqpushbutton.h>

extern EvaluationOptions evalops;

QalculateConvertNumberBasesDialog::QalculateConvertNumberBasesDialog(TQWidget *parent, const char *name)
		: KDialogBase(parent, name, false, i18n("Number Bases"), Close, Close) {

	actionButton(Close)->setAutoDefault(false);
	actionButton(Close)->setDefault(false);

	TQGrid *grid = makeGridMainWidget(2, TQt::Horizontal);
	new TQLabel(i18n("Decimal:"), grid);
	decimalEdit = new KLineEdit(grid);
	decimalEdit->setAlignment(TQt::AlignRight);
	TQObject::connect(decimalEdit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(setDecimalValue(const TQString&)));
	new TQLabel(i18n("Binary:"), grid);
	binaryEdit = new KLineEdit(grid);
	binaryEdit->setAlignment(TQt::AlignRight);
	TQObject::connect(binaryEdit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(setBinaryValue(const TQString&)));
	new TQLabel(i18n("Octal:"), grid);
	octalEdit = new KLineEdit(grid);
	octalEdit->setAlignment(TQt::AlignRight);
	TQObject::connect(octalEdit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(setOctalValue(const TQString&)));
	new TQLabel(i18n("Hexadecimal:"), grid);
	hexadecimalEdit = new KLineEdit(grid);
	hexadecimalEdit->setAlignment(TQt::AlignRight);
	TQObject::connect(hexadecimalEdit, TQ_SIGNAL(textChanged(const TQString&)), this, TQ_SLOT(setHexadecimalValue(const TQString&)));

	decimalEdit->setFocus();

}


QalculateConvertNumberBasesDialog::~QalculateConvertNumberBasesDialog() {}

void QalculateConvertNumberBasesDialog::setDecimalValue(const TQString &qstr) {
	std::string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 10);
}
void QalculateConvertNumberBasesDialog::setBinaryValue(const TQString &qstr) {
	std::string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.base = BASE_BINARY;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 2);
}
void QalculateConvertNumberBasesDialog::setOctalValue(const TQString &qstr) {
	std::string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.base = BASE_OCTAL;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 8);
}
void QalculateConvertNumberBasesDialog::setHexadecimalValue(const TQString &qstr) {
	std::string str = qstr.ascii();
	remove_blank_ends(str);
	if(str.empty()) return;
	if(is_in(OPERATORS EXP, str[str.length() - 1])) return;
	EvaluationOptions eo;
	eo.parse_options.angle_unit = evalops.parse_options.angle_unit;
	eo.parse_options.base = BASE_HEXADECIMAL;
	MathStructure value = CALCULATOR->calculate(CALCULATOR->unlocalizeExpression(str, evalops.parse_options), eo);
	updateEntries(&value, 16);
}

void QalculateConvertNumberBasesDialog::updateEntries(const MathStructure *value, int base) {
	decimalEdit->blockSignals(true);
	binaryEdit->blockSignals(true);
	octalEdit->blockSignals(true);
	hexadecimalEdit->blockSignals(true);
	PrintOptions po;
	po.number_fraction_format = FRACTION_DECIMAL;
	if(base != 10) {po.base = 10; decimalEdit->setText(value->print(po).c_str());}
	if(base != 2) {po.base = 2; binaryEdit->setText(value->print(po).c_str());}
	if(base != 8) {po.base = 8; octalEdit->setText(value->print(po).c_str());}
	if(base != 16) {po.base = 16; hexadecimalEdit->setText(value->print(po).c_str());}
	decimalEdit->blockSignals(false);
	binaryEdit->blockSignals(false);
	octalEdit->blockSignals(false);
	hexadecimalEdit->blockSignals(false);
}

#include "qalculateconvertnumberbasesdialog.moc"
