/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include "entryfield.h"

namespace BibTeX
{

    EntryField::EntryField( FieldType fieldType ) : m_fieldType( fieldType )
    {
        m_fieldTypeName = fieldTypeToString( m_fieldType );
        m_value = new Value();
    }

    EntryField::EntryField( const TQString &fieldTypeName ) : m_fieldTypeName( fieldTypeName )
    {
        m_fieldType = fieldTypeFromString( m_fieldTypeName );
        m_value = new Value();
    }

    EntryField::EntryField( BibTeX::EntryField *other ) : m_fieldType( other->m_fieldType ), m_fieldTypeName( other->m_fieldTypeName ), m_value( NULL )
    {
        setValue( other->m_value );
    }

    EntryField::~EntryField()
    {
        delete m_value;
    }

    TQString EntryField::fieldTypeName() const
    {
        return m_fieldTypeName;
    }

    void EntryField::setFieldType( FieldType fieldType, const TQString& fieldTypeName )
    {
        m_fieldType = fieldType;
        m_fieldTypeName = fieldTypeName;
    }

    EntryField::FieldType EntryField::fieldType() const
    {
        return m_fieldType;
    }

    TQString EntryField::fieldTypeToString( const FieldType fieldType )
    {
        switch ( fieldType )
        {
        case ftAbstract:
            return TQString( "abstract" );
        case ftAddress:
            return TQString( "address" );
        case ftAnnote:
            return TQString( "annote" );
        case ftAuthor:
            return TQString( "author" );
        case ftBookTitle:
            return TQString( "booktitle" );
        case ftChapter:
            return TQString( "chapter" );
        case ftCrossRef:
            return TQString( "crossref" );
        case ftDoi:
            return TQString( "doi" );
        case ftEdition:
            return TQString( "edition" );
        case ftEditor:
            return TQString( "editor" );
        case ftHowPublished:
            return TQString( "howpublished" );
        case ftInstitution:
            return TQString( "institution" );
        case ftISBN:
            return TQString( "isbn" );
        case ftISSN:
            return TQString( "issn" );
        case ftJournal:
            return TQString( "journal" );
        case ftKey:
            return TQString( "key" );
        case ftKeywords:
            return TQString( "keywords" );
        case ftLocalFile:
            return TQString( "localfile" );
        case ftLocation:
            return TQString( "location" );
        case ftMonth:
            return TQString( "month" );
        case ftNote:
            return TQString( "note" );
        case ftNumber:
            return TQString( "number" );
        case ftOrganization:
            return TQString( "organization" );
        case ftPages:
            return TQString( "pages" );
        case ftPublisher:
            return TQString( "publisher" );
        case ftSeries:
            return TQString( "series" );
        case ftSchool:
            return TQString( "school" );
        case ftTitle:
            return TQString( "title" );
        case ftType:
            return TQString( "type" );
        case ftURL:
            return TQString( "url" );
        case ftVolume:
            return TQString( "volume" );
        case ftYear:
            return TQString( "year" );
        default:
            return TQString( "unknown" );
        }
    }

    EntryField::FieldType EntryField::fieldTypeFromString( const TQString & fieldTypeString )
    {
        TQString fieldTypeStringLower = fieldTypeString.lower();

        if ( fieldTypeStringLower == "abstract" )
            return ftAbstract;
        else if ( fieldTypeStringLower == "address" )
            return ftAddress;
        else if ( fieldTypeStringLower == "annote" )
            return ftAnnote;
        else if ( fieldTypeStringLower == "author" )
            return ftAuthor;
        else if ( fieldTypeStringLower == "booktitle" )
            return ftBookTitle;
        else if ( fieldTypeStringLower == "chapter" )
            return ftChapter;
        else if ( fieldTypeStringLower == "crossref" )
            return ftCrossRef;
        else if ( fieldTypeStringLower == "doi" )
            return ftDoi;
        else if ( fieldTypeStringLower == "edition" )
            return ftEdition;
        else if ( fieldTypeStringLower == "editor" )
            return ftEditor;
        else if ( fieldTypeStringLower == "howpublished" )
            return ftHowPublished;
        else if ( fieldTypeStringLower == "institution" )
            return ftInstitution;
        else if ( fieldTypeStringLower == "isbn" )
            return ftISBN;
        else if ( fieldTypeStringLower == "issn" )
            return ftISSN;
        else if ( fieldTypeStringLower == "journal" )
            return ftJournal;
        else if ( fieldTypeStringLower == "key" )
            return ftKey;
        else if ( fieldTypeStringLower == "keywords" )
            return ftKeywords;
        else if ( fieldTypeStringLower == "localfile" )
            return ftLocalFile;
        else if ( fieldTypeStringLower == "location" )
            return ftLocation;
        else if ( fieldTypeStringLower == "month" )
            return ftMonth;
        else if ( fieldTypeStringLower == "note" )
            return ftNote;
        else if ( fieldTypeStringLower == "number" )
            return ftNumber;
        else if ( fieldTypeStringLower == "organization" )
            return ftOrganization;
        else if ( fieldTypeStringLower == "pages" )
            return ftPages;
        else if ( fieldTypeStringLower == "publisher" )
            return ftPublisher;
        else if ( fieldTypeStringLower == "series" )
            return ftSeries;
        else if ( fieldTypeStringLower == "school" )
            return ftSchool;
        else if ( fieldTypeStringLower == "title" )
            return ftTitle;
        else if ( fieldTypeStringLower == "type" )
            return ftType;
        else if ( fieldTypeStringLower == "url" )
            return ftURL;
        else if ( fieldTypeStringLower == "volume" )
            return ftVolume;
        else if ( fieldTypeStringLower == "year" )
            return ftYear;
        else
            return ftUnknown;
    }

    Value *EntryField::value()
    {
        return m_value;
    }

    void EntryField::setValue( const Value *value )
    {
        if ( value != m_value )
        {
            delete m_value;

            if ( value != NULL )
            {
                m_value = new Value( value );
            }
            else
                m_value = new Value();
        }
    }
}
