iconName = 'idea'
labelText = 'KTipDialog'

import os

from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQ_SIGNAL
from tdecore import i18n
from tdeui import KPushButton, KTipDatabase, KTipDialog, KTextEdit


helpText = ("The TDE standard Tip-of-the-Day dialog.")


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Tip-of-the-Day Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, TQ_SIGNAL('clicked()'), self.showTipDialog)

    def showTipDialog(self):
        filename = os.path.abspath(os.path.join(os.path.dirname(__file__), 'tips'))
        tips = KTipDatabase(filename)
        dlg = KTipDialog(tips, self)
        dlg.exec_loop()
