/***************************************************************************
                          sq_archivehandler.h  -  description
                             -------------------
    begin                : ??? ??? 26 2004
    copyright            : (C) 2004 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
  ***************************************************************************/

#ifndef SQ_ARCHIVEHANDLER_H
#define SQ_ARCHIVEHANDLER_H

#include <tqobject.h>
#include <tqstring.h>
#include <tqmap.h>

// forward declarations
class KFileItem;
class KURL;

#define SQ_AH SQ_ArchiveHandler

/*
 *  Helper class for archive extracting via tdeio-slaves (since 0.7.1).
 */

class SQ_ArchiveHandler : public TQObject, TQMap<TQString, TQString>
{
    TQ_OBJECT
  

    public: 
        SQ_ArchiveHandler(TQObject *parent = 0, const char *name = 0);
        ~SQ_ArchiveHandler();

        /*
         *  Find protocol name by mimetype name.
         * 
         *  For example findProtocolByMime(""application/x-tgz"") will
         *  return "tar".
         */
        TQString findProtocolByMime(const TQString &mime);

        /*
         *  Find protocol name by KFileItem's mimetype.
         */
        TQString findProtocolByFile(KFileItem *item);

        /*
         *  Determine mimetype and emit unpack() signal
         */
        void tryUnpack(KFileItem *);

        void tryUnpack(const KURL &, const TQString &mime);

        static SQ_ArchiveHandler* instance() { return m_instance; }

    private:
        void fillProtocols();

    signals:
        void unpack(const KURL &);

    private:
        static SQ_ArchiveHandler *m_instance;
};

#endif
