/***************************************************************************
                          sq_utils.h  -  description
                             -------------------
    begin                : Thu Aug 2 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SQ_UTILS_H
#define SQ_UTILS_H

#include <tqimage.h>
#include <tqwmatrix.h>

class KURL;

class TQString;

class SQ_Thumbnail;

/*
 *  Helper class for SQ_GLWidget and SQ_ThumbnailLoadJob:
 *
 *  thumbnail loader, rotater, mmx scaler
 */

namespace SQ_Utils
{
    enum SmoothAlgorithm { SMOOTH_NONE, SMOOTH_FAST, SMOOTH_NORMAL, SMOOTH_BEST };

    TQImage scale(const TQImage& image, int width, int height,
                SmoothAlgorithm alg, TQImage::ScaleMode mode = TQImage::ScaleFree, double blur = 1.0);

    /*
     *  Scale given image to fit it within 'fitwithin'
     */
    TQImage scaleImage(unsigned char *im, int w, int h, int fitwithin);

#ifndef KSQUIRREL_PART
    /*
     *  Create and save thumbnail for 'pixPath'
     */
    bool loadThumbnail(const KURL &pixPath, SQ_Thumbnail&);
#endif

    /*
     * determine EXIF rotation and rotate image if needed
     */
    void exifRotate(const TQString &file, TQImage &i, int o = -1);

    TQWMatrix exifGetMatrix(const TQString &file, int o = -1);
};

#endif
