/***************************************************************************
                          fontfamilychooser.h  -  description
                             -------------------
    begin                : mer lug 23 11:20:17 CEST 2003
    copyright            : (C) |YEAR| by si2003    email                : gulmini.luciano@student.unife.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FONTFAMILYCHOOSER_H
#define FONTFAMILYCHOOSER_H

#include "fontfamilychoosers.h"
#include <tqmap.h>
class TQStringList;

class fontFamilyChooser : public fontFamilyChooserS
{
  TQ_OBJECT
  
  private:
    enum FontOrigin { available, generic };
    TQString m_currentSelectedFont;
    FontOrigin m_fontOrigin;
    int  m_currentSelectedFontIndex;
    TQMap<TQString,FontOrigin> m_selectedFontMap;
  
  private slots:
    void updatePreview(const TQString &);
    void setCurrentSelectedAvailableFamilyFont(const TQString&); 
    void setCurrentSelectedGenericFamilyFont(const TQString&);
    void setCurrentSelectedFont( int i) { m_currentSelectedFontIndex = i; }
    void setCurrentSelectedFont( const TQString& f ) { m_currentSelectedFont = f; }
    void addFont();
    void removeFont();
    void moveFontUp();
    void moveFontDown();
    
  public:    
    fontFamilyChooser(TQWidget* parent, const char *name=0);
    ~fontFamilyChooser(); 
    TQStringList fontList();
    void setInitialValue(const TQString& s);
};

#endif
