/***************************************************************************
	  kommanderplugin.cpp - An interface to Kommander widget plugins
                             -------------------
    copyright            : (C) 2003 by Marc Britton
    email                : consume@optusnet.com.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kommanderplugin.h"
#include "specialinformation.h"

KommanderPlugin::KommanderPlugin()
{ 
}

KommanderPlugin::~KommanderPlugin()
{
}

void KommanderPlugin::addWidget( const TQString &name, const TQString &group, const TQString &toolTip, TQIconSet *iconSet, const TQString &whatsThis, bool isContainer)
{
    m_widgets[name] = WidgetInfo( group, toolTip, iconSet, whatsThis, isContainer );
}

void KommanderPlugin::removeWidget( const TQString &name )
{
    m_widgets.remove( name );
}

TQStringList KommanderPlugin::widgets() const
{
    TQStringList ws;
    WidgetInfos::ConstIterator it;
    for( it = m_widgets.begin() ; it != m_widgets.end() ; ++ it )
	ws += it.key();
    return ws;
}

TQString KommanderPlugin::group( const TQString &name ) const
{
    return m_widgets[name].group;
}

TQString KommanderPlugin::toolTip( const TQString &name ) const
{
    return m_widgets[name].toolTip;
}

TQString KommanderPlugin::whatsThis( const TQString &name ) const
{
    return m_widgets[name].whatsThis;
}

bool KommanderPlugin::isContainer( const TQString &name ) const
{
    return m_widgets[name].isContainer;
}

TQIconSet* KommanderPlugin::iconSet( const TQString &name ) const
{
    return m_widgets[name].iconSet;
}

void KommanderPlugin::setDefaultGroup( int id )
{
    SpecialInformation::setDefaultGroup(id);
}

bool KommanderPlugin::registerFunction(int id, const TQString& function, const TQString description , int minArgs, int maxArgs)
{
   return SpecialInformation::insert(id, function, description, minArgs, maxArgs); 
}

#include "kommanderplugin.moc"
