/***************************************************************************
 *   Copyright (C) 2002 by Bernd Gehrmann                                  *
 *   bernd@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "shellinsertdlg.h"

#include <tqcombobox.h>
#include <tqlayout.h>
#include <tqpushbutton.h>
#include <tdeconfig.h>
#include <kbuttonbox.h>
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kprocess.h>
#include <klineedit.h>
#include <kstdguiitem.h>
#include <tdeversion.h>

#include "kdevplugin.h"
#include "domutil.h"
#include "filterpart.h"


ShellInsertDialog::ShellInsertDialog()
    : TQDialog(0, "shell filter dialog", true)
{
    TQVBoxLayout *layout = new TQVBoxLayout(this, 10, 4);

    combo = new TQComboBox(true, this);
    combo->setDuplicatesEnabled(false);
    layout->addWidget(combo);

    KButtonBox *buttonbox = new KButtonBox(this);
    start_button = buttonbox->addButton(i18n("&Start"));
    start_button->setDefault(true);
    cancel_button = buttonbox->addButton(KStdGuiItem::cancel());
    buttonbox->layout();
    layout->addWidget(buttonbox);

    connect( start_button, TQ_SIGNAL(clicked()),
             this, TQ_SLOT(slotStartClicked()) );
    connect( cancel_button, TQ_SIGNAL(clicked()),
             this, TQ_SLOT(reject()) );
    connect( combo->lineEdit(), TQ_SIGNAL(textChanged( const TQString &)), this, TQ_SLOT(executeTextChanged( const TQString &)));
    m_proc = 0;

    TDEConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    TQStringList items = config->readListEntry("InsertItems");
    combo->insertStringList(items);
    executeTextChanged( combo->lineEdit()->text());

}


ShellInsertDialog::~ShellInsertDialog()
{
    kdDebug(9029) << "~ShellInsertDialog" << endl;
    delete m_proc;

    // TQComboBox API is a bit incomplete :-(
    TQStringList list;
    for (int i=0; i < combo->count(); ++i)
        list << combo->text(i);

    TDEConfig *config = FilterFactory::instance()->config();
    config->setGroup("General");
    config->writeEntry("InsertItems", list);
}


void ShellInsertDialog::executeTextChanged( const TQString &text)
{
    start_button->setEnabled(!text.isEmpty());
}

int ShellInsertDialog::exec()
{
    start_button->setEnabled(true);
    return TQDialog::exec();
}


void ShellInsertDialog::slotStartClicked()
{
    start_button->setEnabled(false);
    m_str = TQCString();

    delete m_proc;
    m_proc = new KShellProcess("/bin/sh");
    (*m_proc) << combo->currentText();
    connect( m_proc, TQ_SIGNAL(receivedStdout(TDEProcess*, char *, int)),
             this, TQ_SLOT(slotReceivedStdout(TDEProcess*, char *, int)) );
    connect( m_proc, TQ_SIGNAL(processExited(TDEProcess*)),
             this, TQ_SLOT(slotProcessExited(TDEProcess*)) );
    m_proc->start(TDEProcess::NotifyOnExit, TDEProcess::AllOutput);
}


void ShellInsertDialog::slotReceivedStdout(TDEProcess *, char *text, int len)
{
    m_str += TQCString(text, len+1);
}


void ShellInsertDialog::slotProcessExited(TDEProcess *)
{
    if (m_proc->normalExit()) {
        accept();
    } else {
        KMessageBox::error(this, i18n("Process exited with status %1")
                           .arg(m_proc->exitStatus()));
        reject();
    }
}

#include "shellinsertdlg.moc"
