/***************************************************************************
 *   Copyright (C) 2004 by Jens Dagerbo                                    *
 *   jens.dagerbo@swipnet.se                                               *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kiconloader.h>
#include <tqfontmetrics.h>
#include <tqfileinfo.h>

#include "filelist_item.h"

#include <kiconloader.h>
#include <tdefileitem.h>

FileListItem * FileListItem::s_activeItem = 0;

FileListItem::FileListItem( TQListView * parent, KURL const & url, DocumentState state )
	: TQListViewItem( parent, url.fileName() ),
	_url( url )

{
	KFileItem fileItem( KFileItem::Unknown, KFileItem::Unknown, _url );
    _icon = fileItem.pixmap(TDEIcon::SizeSmall);
    setState( state );
}

KURL FileListItem::url()
{
	return _url;
}

DocumentState FileListItem::state( )
{
	return _state;
}

void FileListItem::setState( DocumentState state )
{
	_state = state;

	switch( state )
	{
		case Clean:
            setPixmap( 0, _icon);
// 			setPixmap( 0, 0L );
			break;
		case Modified:
			setPixmap( 0, SmallIcon("document-save") );
			break;
		case Dirty:
			setPixmap( 0, SmallIcon("document-revert") );
			break;
		case DirtyAndModified:
			setPixmap( 0, SmallIcon("process-stop") );
			break;
	}
}

void FileListItem::setHeight( int )
{
	TQListViewItem::setHeight( TDEIcon::SizeSmall > listView()->fontMetrics().height() ? TDEIcon::SizeSmall : listView()->fontMetrics().height() );
}

void FileListItem::paintCell( TQPainter * p, const TQColorGroup & cg, int column, int width, int align )
{
	TQColorGroup mcg = cg;

	if ( isActive() )
	{
		mcg.setColor( TQColorGroup::Base, TQt::yellow );
	}

	TQListViewItem::paintCell( p, mcg, column, width, align );
}

bool FileListItem::isActive( )
{
	return ( s_activeItem == this );
}

//static
void FileListItem::setActive( FileListItem * item )
{
	s_activeItem = item;
}

int FileListItem::compare( TQListViewItem * i, int col, bool ascending ) const
{
	TQFileInfo info1( key( col, ascending ) ); //this
	TQFileInfo info2( i->key( col, ascending ) ); //that
    int fileComp = info1.fileName().compare( info2.fileName() );
	if ( fileComp != 0 )
		return fileComp;
	else
		return info1.extension().compare( info2.extension() );
}
