/*  This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef __chmfile_h__
#define __chmfile_h__

#include <cstdio>
#include <tqmap.h>
#include <tqstring.h>

class TQFile;

struct ChmDirTableEntry
{
    ChmDirTableEntry() : section(0), offset(0), length(0) {}
    ChmDirTableEntry( uint s, uint o, uint l )
	: section(s), offset(o), length(l) {}

    uint section;
    uint offset;
    uint length;
};

typedef TQMap<TQString, ChmDirTableEntry> ChmDirectoryMap;

class Chm
{
public:
    bool read( const TQString&, ChmDirectoryMap&, TQByteArray& ) const;

private:
    bool getChunk( TQFile&, uint, ChmDirectoryMap& ) const;
    uint getEncInt( TQFile&, uint& ) const;
    uint getName( TQFile&, TQString& ) const;
    uint getIntel32( TQFile& ) const;
    uint getIntel64( TQFile& ) const;
};

#endif // __chmfile_h__

