/***************************************************************************
 *   Copyright (C) 2001 by Harald Fernengel                                *
 *   harry@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _DIFFPART_H_
#define _DIFFPART_H_

#include <tqguardedptr.h>
#include <tqcstring.h>

#include "kdevplugin.h"
#include "kdevdifffrontend.h"

class TQPopupMenu;
class Context;
class TDEProcess;
class DiffWidget;
class TQCString;

class DiffPart : public KDevDiffFrontend
{
    TQ_OBJECT
  

public:
    DiffPart( TQObject *parent, const char *name, const TQStringList & );
    virtual ~DiffPart();

    void openURL( const KURL& url );
    void showDiff( const TQString& diff );
    void showDiff( const KURL &, const KURL & ) { /** @todo */ }

public slots:
    void slotExecDiff();

private slots:
    void contextMenu( TQPopupMenu* popup, const Context* context );
    void localDiff();
    void processExited( TDEProcess* p );
    void receivedStdout( TDEProcess* p, char* buf, int buflen );
    void receivedStderr( TDEProcess* p, char* buf, int buflen );
    void wroteStdin( TDEProcess* p );

private:
    TQGuardedPtr<DiffWidget> diffWidget;
    KURL popupFile;
    TDEProcess* proc;
    TQCString buffer;
    TQString resultBuffer;
    TQString resultErr;
};

#endif
