#include "sqlsupport_part.h"
#include <tqwhatsthis.h>
#include <tqstringlist.h>
#include <tqtimer.h>
#include <tqsqldatabase.h>
#include <tqsqlrecord.h>

#include <tdeapplication.h>
#include <kiconloader.h>
#include <tdelocale.h>
#include <kdevgenericfactory.h>
#include <kdebug.h>
#include <tdeaction.h>
#include <tdeparts/part.h>
#include <kdialogbase.h>
#include <tdetexteditor/editinterface.h>
#include <tdemessagebox.h>

#include "kdevcore.h"
#include "kdevmainwindow.h"
#include "kdevlanguagesupport.h"
#include "kdevpartcontroller.h"
#include "kdevproject.h"
#include "codemodel.h"
#include "kdevplugininfo.h"

#include "sqlconfigwidget.h"
#include "sqlactions.h"
#include "sqloutputwidget.h"
#include "domutil.h"

typedef KDevGenericFactory<SQLSupportPart> SQLSupportFactory;
static const KDevPluginInfo pluginData("kdevsqlsupport");
K_EXPORT_COMPONENT_FACTORY( libkdevsqlsupport, SQLSupportFactory( pluginData ) )

SQLSupportPart::SQLSupportPart( TQObject *parent, const char *name, const TQStringList& )
        : KDevLanguageSupport ( &pluginData, parent, name ? name : "SQLSupportPart" )
{
    setInstance( SQLSupportFactory::instance() );
    setXMLFile( "kdevsqlsupport.rc" );

    TDEAction *action;
    action = new TDEAction( i18n( "&Run" ), "application-x-executable", Key_F9, this, TQ_SLOT( slotRun() ), actionCollection(), "build_execute" );
    action->setToolTip(i18n("Run"));
    action->setWhatsThis(i18n("<b>Run</b><p>Executes a SQL script."));

    dbAction = new SqlListAction( this, i18n( "&Database Connections" ), 0, this, TQ_SLOT(activeConnectionChanged()), actionCollection(), "connection_combo" );

    kdDebug( 9000 ) << "Creating SQLSupportPart" << endl;

    connect( core(), TQ_SIGNAL( projectConfigWidget( KDialogBase* ) ),
             this, TQ_SLOT( projectConfigWidget( KDialogBase* ) ) );
    connect( core(), TQ_SIGNAL(projectOpened()), this, TQ_SLOT(projectOpened()) );
    connect( core(), TQ_SIGNAL(projectClosed()), this, TQ_SLOT(projectClosed()) );
    connect( core(), TQ_SIGNAL(languageChanged()), this, TQ_SLOT(projectOpened()) );
    connect( partController(), TQ_SIGNAL( savedFile( const KURL& ) ), this, TQ_SLOT( savedFile( const KURL& ) ) );

    m_widget = new SqlOutputWidget();
    mainWindow()->embedOutputView( m_widget, i18n( "SQL" ), i18n( "Output of SQL commands" ) );
    TQWhatsThis::add(m_widget, i18n("<b>Output of SQL commands</b><p>This window shows the output of SQL commands being executed. It can display results of SQL \"select\" commands in a table."));
}


SQLSupportPart::~SQLSupportPart()
{
    mainWindow()->removeView(m_widget);
    delete m_widget;
}

TQString SQLSupportPart::cryptStr(const TQString& aStr)
{
    TQString result;
    for (unsigned int i = 0; i < aStr.length(); i++)
	result += (aStr[i].unicode() < 0x20) ? aStr[i] :
		  TQChar(0x1001F - aStr[i].unicode());
    return result;
}

void SQLSupportPart::activeConnectionChanged()
{
    updateCatalog();
}

void SQLSupportPart::clearConfig()
{
    for ( TQStringList::Iterator it = conNames.begin(); it != conNames.end(); ++it ) {
        if ( TQSqlDatabase::contains( *it ) ) {
            TQSqlDatabase::database( *it, false )->close();
            TQSqlDatabase::removeDatabase( *it );
        } else {
            kdDebug( 9000 ) << "Could not find connection named " << (*it) << endl;
        }
    }
    conNames.clear();

    dbAction->refresh();
}

void SQLSupportPart::loadConfig()
{
    clearConfig();

    TQDomDocument* doc = projectDom();

    TQStringList db;
    int i = 0;
    TQString conName;
    while ( true ) {
        TQStringList sdb = DomUtil::readListEntry( *doc, "kdevsqlsupport/servers/server" + TQString::number( i ), "el" );
        if ( (int)sdb.size() < 6 )
            break;

        conName = "KDEVSQLSUPPORT_";
        conName += TQString::number( i );
        conNames << conName;
	TQSqlDatabase* db = TQSqlDatabase::addDatabase( sdb[0], TQString( "KDEVSQLSUPPORT_%1" ).arg( i ) );
        db->setDatabaseName( sdb[1] );
        db->setHostName( sdb[2] );
        bool ok;
        int port = sdb[3].toInt( &ok );
        if ( ok )
            db->setPort( port );
        db->setUserName( sdb[4] );
        db->setPassword( cryptStr( sdb[5] ) );
        db->open();

        i++;
    }

    dbAction->refresh();
}

void SQLSupportPart::projectConfigWidget( KDialogBase *dlg )
{
    TQVBox *vbox = dlg->addVBoxPage( TQString( "SQL" ), i18n( "Specify Your Database Connections" ), BarIcon("text-x-src", TDEIcon::SizeMedium) );
    SqlConfigWidget *w = new SqlConfigWidget( (TQWidget*)vbox, "SQL config widget" );
    w->setProjectDom( projectDom() );
    w->loadConfig();
    connect( dlg, TQ_SIGNAL(okClicked()), w, TQ_SLOT(accept()) );
    connect( w, TQ_SIGNAL(newConfigSaved()), this, TQ_SLOT(loadConfig()) );
}

void SQLSupportPart::projectOpened()
{
    connect( project(), TQ_SIGNAL( addedFilesToProject( const TQStringList & ) ),
             this, TQ_SLOT( addedFilesToProject( const TQStringList & ) ) );
    connect( project(), TQ_SIGNAL( removedFilesFromProject( const TQStringList & ) ),
             this, TQ_SLOT( removedFilesFromProject( const TQStringList & ) ) );

    loadConfig();

    // We want to parse only after all components have been
    // properly initialized
    TQTimer::singleShot( 0, this, TQ_SLOT( parse() ) );
}


void SQLSupportPart::projectClosed()
{
    clearConfig();
}

void SQLSupportPart::slotRun ()
{
    TQString cName = dbAction->currentConnectionName();
    if ( cName.isEmpty() ) {
        KMessageBox::sorry( 0, i18n("Please select a valid database connection.") );
        return;
    }

    KTextEditor::EditInterface* doc = dynamic_cast<KTextEditor::EditInterface*>(partController()->activePart());
    if ( !doc )
        return; // show error message?

    mainWindow()->raiseView( m_widget );
    m_widget->showQuery( cName, doc->text() );
}

#if 0
static TQString dbCaption(const TQSqlDatabase* db)
{
    TQString res;
    if (!db)
        return res;
    res = db->driverName();
    res += TQString::fromLatin1("@");
    res += db->hostName();
    if (db->port() >= 0)
        res += TQString::fromLatin1(":") + TQString::number(db->port());
    return res;
}
#endif

void SQLSupportPart::parse()
{
    // @todo
}

void SQLSupportPart::updateCatalog()
{
    if (!project() || !dbAction)
        return;

    codeModel()->wipeout();

    TQString curConnection = dbAction->currentConnectionName();
    if (curConnection.isEmpty()) {
        emit updatedSourceInfo();
        return;
    }

    FileDom dbf = codeModel()->create<FileModel>();
    dbf->setName(dbAction->currentConnectionName());
    TQSqlDatabase *db = TQSqlDatabase::database(dbAction->currentConnectionName(), true);

    // tables are classes and fields are methods
    if (db->isOpen()) {
        TQSqlRecord inf;
        TQStringList tables = db->tables();
        for (TQStringList::Iterator it = tables.begin(); it != tables.end(); ++it) {
            ClassDom dbc = codeModel()->create<ClassModel>();
            dbc->setName(*it);
            inf = db->record(*it);
            for (int i = 0; i < (int)inf.count(); ++i) {
                FunctionDom dbv = codeModel()->create<FunctionModel>();
                dbv->setName(inf.fieldName(i));
                dbv->setResultType(TQVariant::typeToName(inf.field(i)->type()));
                dbc->addFunction(dbv);
            }
            dbf->addClass(dbc);
        }
    }

    codeModel()->addFile(dbf);

    emit updatedSourceInfo();
}

void SQLSupportPart::addedFilesToProject( const TQStringList &fileList )
{
    TQStringList::ConstIterator it;

    for ( it = fileList.begin(); it != fileList.end(); ++it ) {
//        parse( project() ->projectDirectory() + "/" + ( *it ) );
    }

    emit updatedSourceInfo();
}


void SQLSupportPart::removedFilesFromProject( const TQStringList &fileList )
{
    TQStringList::ConstIterator it;

    for ( it = fileList.begin(); it != fileList.end(); ++it ) {
//        classStore() ->removeWithReferences( project() ->projectDirectory() + "/" + ( *it ) );
    }

    emit updatedSourceInfo();
}

void SQLSupportPart::savedFile( const KURL &fileName )
{
    if ( project() ->allFiles().contains( fileName.path().mid ( project() ->projectDirectory().length() + 1 ) ) ) {
//        parse( fileName );
//        emit updatedSourceInfo();
    }
}

KDevLanguageSupport::Features SQLSupportPart::features()
{
    return Features( Classes | Functions );
}

KMimeType::List SQLSupportPart::mimeTypes( )
{
    KMimeType::List list;
    KMimeType::Ptr mime = KMimeType::mimeType( "text/plain" );
    if( mime )
        list << mime;
    return list;
}

#include "sqlsupport_part.moc"
