
#include "%{APPNAMELC}_part.h"

#include <kinstance.h>
#include <tdeaction.h>
#include <kstdaction.h>
#include <tdefiledialog.h>
#include <tdeglobal.h>
#include <tdelocale.h>

#include <tqfile.h>
#include <tqtextstream.h>
#include <tqmultilineedit.h>

%{APPNAME}Part::%{APPNAME}Part( TQWidget *parentWidget, const char *widgetName,
                                  TQObject *parent, const char *name )
    : KParts::ReadWritePart(parent, name)
{
    // we need an instance
    setInstance( %{APPNAME}PartFactory::instance() );

    // this should be your custom internal widget
    m_widget = new TQMultiLineEdit( parentWidget, widgetName );

    // notify the part that this is our internal widget
    setWidget(m_widget);

    // create our actions
    KStdAction::open(this, TQ_SLOT(fileOpen()), actionCollection());
    KStdAction::saveAs(this, TQ_SLOT(fileSaveAs()), actionCollection());
    KStdAction::save(this, TQ_SLOT(save()), actionCollection());

    // set our XML-UI resource file
    setXMLFile("%{APPNAMELC}_part.rc");

    // we are read-write by default
    setReadWrite(true);

    // we are not modified since we haven't done anything yet
    setModified(false);
}

%{APPNAME}Part::~%{APPNAME}Part()
{
}

void %{APPNAME}Part::setReadWrite(bool rw)
{
    // notify your internal widget of the read-write state
    m_widget->setReadOnly(!rw);
    if (rw)
        connect(m_widget, TQ_SIGNAL(textChanged()),
                this,     TQ_SLOT(setModified()));
    else
    {
        disconnect(m_widget, TQ_SIGNAL(textChanged()),
                   this,     TQ_SLOT(setModified()));
    }

    ReadWritePart::setReadWrite(rw);
}

void %{APPNAME}Part::setModified(bool modified)
{
    // get a handle on our Save action and make sure it is valid
    TDEAction *save = actionCollection()->action(KStdAction::stdName(KStdAction::Save));
    if (!save)
        return;

    // if so, we either enable or disable it based on the current
    // state
    if (modified)
        save->setEnabled(true);
    else
        save->setEnabled(false);

    // in any event, we want our parent to do it's thing
    ReadWritePart::setModified(modified);
}

bool %{APPNAME}Part::openFile()
{
    // m_file is always local so we can use TQFile on it
    TQFile file(m_file);
    if (!file.open(IO_ReadOnly))
        return false;

    // our example widget is text-based, so we use TQTextStream instead
    // of a raw TQDataStream
    TQTextStream stream(&file);
    TQString str;
    while (!stream.eof())
        str += stream.readLine() + "\n";

    file.close();

    // now that we have the entire file, display it
    m_widget->setText(str);

    // just for fun, set the status bar
    emit setStatusBarText( m_url.prettyURL() );

    return true;
}

bool %{APPNAME}Part::saveFile()
{
    // if we aren't read-write, return immediately
    if (!isReadWrite())
        return false;

    // m_file is always local, so we use TQFile
    TQFile file(m_file);
    if (!file.open(IO_WriteOnly))
        return false;

    // use TQTextStream to dump the text to the file
    TQTextStream stream(&file);
    stream << m_widget->text();

    file.close();

    return true;
}

void %{APPNAME}Part::fileOpen()
{
    // this slot is called whenever the File->Open menu is selected,
    // the Open shortcut is pressed (usually CTRL+O) or the Open toolbar
    // button is clicked
    TQString file_name = KFileDialog::getOpenFileName();

    if (!file_name.isEmpty())
        openURL(file_name);
}

void %{APPNAME}Part::fileSaveAs()
{
    // this slot is called whenever the File->Save As menu is selected,
    TQString file_name = KFileDialog::getSaveFileName();
    if (!file_name.isEmpty())
        saveAs(file_name);
}


// It's usually safe to leave the factory code alone.. with the
// notable exception of the TDEAboutData data
#include <tdeaboutdata.h>
#include <tdelocale.h>

TDEInstance*  %{APPNAME}PartFactory::s_instance = 0L;
TDEAboutData* %{APPNAME}PartFactory::s_about = 0L;

%{APPNAME}PartFactory::%{APPNAME}PartFactory()
    : KParts::Factory()
{
}

%{APPNAME}PartFactory::~%{APPNAME}PartFactory()
{
    delete s_instance;
    delete s_about;

    s_instance = 0L;
}

KParts::Part* %{APPNAME}PartFactory::createPartObject( TQWidget *parentWidget, const char *widgetName,
                                                        TQObject *parent, const char *name,
                                                        const char *classname, const TQStringList &args )
{
    // Create an instance of our Part
    %{APPNAME}Part* obj = new %{APPNAME}Part( parentWidget, widgetName, parent, name );

    // See if we are to be read-write or not
    if (TQCString(classname) == "KParts::ReadOnlyPart")
        obj->setReadWrite(false);

    return obj;
}

TDEInstance* %{APPNAME}PartFactory::instance()
{
    if( !s_instance )
    {
        s_about = new TDEAboutData("%{APPNAMELC}part", I18N_NOOP("%{APPNAME}Part"), "%{VERSION}");
        s_about->addAuthor("%{AUTHOR}", 0, "%{EMAIL}");
        s_instance = new TDEInstance(s_about);
    }
    return s_instance;
}

extern "C"
{
    void* init_lib%{APPNAMELC}part()
    {
	TDEGlobal::locale()->insertCatalogue("%{APPNAMELC}");
        return new %{APPNAME}PartFactory;
    }
};

#include "%{APPNAMELC}_part.moc"
