#include "factory.h"

#include "ai.h"
#include "settings.h"


CommonFactory::CommonFactory(const MainData &md, const BaseBoardInfo &bbi,
                             const CommonBoardInfo &ci)
    : BaseFactory(md, bbi), cbi(ci)
{}

TQWidget *CommonFactory::createAppearanceConfig()
{
    return new AppearanceConfig;
}

TQWidget *CommonFactory::createGameConfig()
{
    return new GameConfig;
}

TQWidget *CommonFactory::createAIConfig()
{
    AI *ai = createAI();
    TQWidget *cw = new AIConfig(ai->elements());
    delete ai;
    return cw;
}
