#ifndef BASE_MAIN_H
#define BASE_MAIN_H

#include "kzoommainwindow.h"

#include <tdemacros.h>

class BaseInterface;
class TDEToggleAction;
class KKeyDialog;
class TDEConfigDialog;

class TDE_EXPORT BaseMainWindow : public KZoomMainWindow
{
    TQ_OBJECT
  
public:
    BaseMainWindow();
    virtual ~BaseMainWindow();

signals:
    void settingsChanged();

private slots:
    void start();
    void pause();
    void showHighscores();
    void configureSettings();
    void configureKeys();
    void configureHighscores();
    void configureNotifications();

protected:
    BaseInterface     *_inter;

    void buildGUI(TQWidget *widget);
    virtual void addConfig(TDEConfigDialog *) {}
    virtual void addKeys(KKeyDialog &) {}
    virtual void saveKeys() {}
    
    virtual void writeZoomSetting(uint zoom);
    virtual uint readZoomSetting() const;
    virtual void writeMenubarVisibleSetting(bool visible);
    virtual bool menubarVisibleSetting() const;

private:
    TDEToggleAction *_pause;
};

#endif
