/***************************************************************************
 *   Copyright (C) 2005 by Albert Astals Cid <tsdgeos@terra.es>            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <tdeaboutdata.h>
#include <tdeapplication.h>
#include <tdecmdlineargs.h>
#include <kprocess.h>
#include <kstandarddirs.h>

#include "fontchecker.h"
#include "blinken.h"

int main(int argc, char *argv[])
{
	TDEAboutData about("blinken", I18N_NOOP("blinKen"), "0.1.1", I18N_NOOP("A memory enhancement game"), TDEAboutData::License_GPL, "© 2005 Albert Astals Cid\n© 2005 Danny Allen");
	about.addAuthor("Albert Astals Cid", I18N_NOOP("Coding"), "tsdgeos@terra.es");
	about.addAuthor("Danny Allen", I18N_NOOP("Design, Graphics and Sounds"), "danny@dannyallen.co.uk");
	about.addCredit("Steve Jordi", I18N_NOOP("GPL'ed his 'Steve' font so that we could use it"), "steve@sjordi.com");
	TDECmdLineArgs::init(argc, argv, &about);
	TDEApplication app;
	app.connect(&app, TQ_SIGNAL(lastWindowClosed()), &app, TQ_SLOT(quit()));
	
	TQFont f("Steve", 12, TQFont::Normal, true);
	if (!fontChecker::checkInstalled(f, locate("appdata", "fonts/steve.ttf")))
	{
		TDEProcess *proc = new TDEProcess;
		for (int i = 0; i < argc; i++) *proc << argv[i];
		proc->start();
	}
	else
	{
		app.setTopWidget(new blinken());
		return app.exec();
	}
}
