/*
  Copyright (C) 2000 Rik Hemsley (rikkus) <rik@kde.org>
  Copyright (C) 2000, 2001, 2002 Michael Matz <matz@kde.org>
  Copyright (C) 2001 Carsten Duvenhorst <duvenhorst@m2.uni-hannover.de>
  Copyright (C) 2001 Adrian Schroeter <adrian@suse.de>
  Copyright (C) 2003 Richard Lärkäng <richard@goteborg.utfors.se>
  Copyright (C) 2003 Scott Wheeler <wheeler@kde.org>
  Copyright (C) 2004, 2005 Benjamin Meyer <ben at meyerhome dot net>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

#include "encoderwav.h"

extern "C"
{
  TDE_EXPORT void create_audiocd_encoders(TDEIO::SlaveBase *slave, TQPtrList<AudioCDEncoder> &encoders)
  {
    encoders.append( new EncoderWav(slave));
    encoders.append( new EncoderCda(slave));
  }
}

class EncoderWav::Private
{
  public:
  
};

unsigned long EncoderWav::size(long time_secs) const {
  return (EncoderCda::size(time_secs) + 44);
}

const char * EncoderWav::mimeType() const {
  return "audio/x-wav";
}

long EncoderWav::readInit(long byteCount){
  static char riffHeader[] =
  {
    '\x52', '\x49', '\x46', '\x46', // 0  "AIFF"
    '\x00', '\x00', '\x00', '\x00', // 4  wavSize
    '\x57', '\x41', '\x56', '\x45', // 8  "WAVE"
    '\x66', '\x6d', '\x74', '\x20', // 12 "fmt "
    '\x10', '\x00', '\x00', '\x00', // 16
    '\x01', '\x00', '\x02', '\x00', // 20
    '\x44', '\xac', '\x00', '\x00', // 24
    '\x10', '\xb1', '\x02', '\x00', // 28
    '\x04', '\x00', '\x10', '\x00', // 32
    '\x64', '\x61', '\x74', '\x61', // 36 "data"
    '\x00', '\x00', '\x00', '\x00'  // 40 byteCount
  };

  TQ_INT32 wavSize(byteCount + 44 - 8);


  riffHeader[4]   = (wavSize   >> 0 ) & 0xff;
  riffHeader[5]   = (wavSize   >> 8 ) & 0xff;
  riffHeader[6]   = (wavSize   >> 16) & 0xff;
  riffHeader[7]   = (wavSize   >> 24) & 0xff;

  riffHeader[40]  = (byteCount >> 0 ) & 0xff;
  riffHeader[41]  = (byteCount >> 8 ) & 0xff;
  riffHeader[42]  = (byteCount >> 16) & 0xff;
  riffHeader[43]  = (byteCount >> 24) & 0xff;

  TQByteArray output;
  output.setRawData(riffHeader, 44);
  ioslave->data(output);
  output.resetRawData(riffHeader, 44);
  return 44;
}

