/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2004-2006                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "dialog_utils.h"

// qt/kde includes
#include <tqgroupbox.h>
#include <tqlayout.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <kinputdialog.h>

// app includes
#include "uml.h"
#include "umlwidget.h"

namespace Dialog_Utils {

TQLineEdit* makeLabeledEditField(TQGroupBox *containingBox, TQGridLayout *layout, int row,
                                TQLabel * &label, const TQString& labelText,
                                TQLineEdit * &editField,
                                const TQString& editFieldText /* = TQString() */)
{
    label = new TQLabel(labelText, containingBox);
    layout->addWidget(label, row, 0);
    editField = new TQLineEdit(editFieldText, containingBox);
    layout->addWidget(editField, row, 1 );
    label->setBuddy(editField);
    return editField;
}


void askNameForWidget(UMLWidget * &targetWidget, const TQString& dialogTitle,
                      const TQString& dialogPrompt, const TQString& defaultName) {

    bool pressedOK = false;

    TQString name = KInputDialog::getText(dialogTitle, dialogPrompt, defaultName, &pressedOK, UMLApp::app());

    if (pressedOK) {
        targetWidget->setName(name);
    } else {
        targetWidget->cleanup();
        delete targetWidget;
        targetWidget = NULL;
    }
}


}  // end namespace Dialog_Utils

