#ifndef DBENTRIES_H
#define DBENTRIES_H

#include <db4/db_cxx.h>
#include <tqstring.h>
#include <tqbuffer.h>
#include <tqmap.h>
#include <tqstringlist.h>
#include <tqdatetime.h>

class CatalogInfo
{

 TQString author;
 TQDateTime datetime;
 TQString filename;
 TQString filepath;


};

class ResultInfo
{
public:
//Common info
 TQString original;  //placeholder

//
//Multi reference info
 TQValueList<CatalogInfo> catalogs;

 TQString info;
 
};

class InputInfo
{
public:
 unsigned int ref() {return 1;}
 
};

class DBItem : public  Dbt
{
public:
 
 virtual ~DBItem(){}

 virtual bool isEmpty(){return empty;}
//void fromDbt(Dbt *dbt);

 void set();
 void get();
 

protected:
 virtual void read(TQDataStream *s) = 0;
 virtual void write(TQDataStream *s) = 0;
 TQByteArray mydata;  
 bool empty;
 
};

class DBItemMainKey : public DBItem
{
 public:
  DBItemMainKey();
  DBItemMainKey(TQString searchstring);
  
 
 TQString getString(){  return sstr;}
 
private:
 
 virtual void read(TQDataStream *s);
 virtual void write(TQDataStream *s);
 
 TQString sstr;
 
};


class DBItemMainData : public DBItem
{
 public:

  typedef TQMapIterator<TQString,TQValueList<unsigned int> > TranslationIterator;
  typedef TQMap<TQString,TQValueList<unsigned int> > TranslationMap;

  DBItemMainData();
 
  TQStringList getTranslations();
  TQValueList<unsigned int> getReferences(TQString str);
  
  void clear();


//Add a translation with  reference ref, if translation exists append
// ref to the list of references
  void addTranslation(TQString str,unsigned int ref);       
  void removeTranslation(TQString str,unsigned int ref);       

//remove any reference to ref, if ref is the only reference of a translation
// the translation is removed  
  void removeRef(unsigned int ref);  

  unsigned int getIndexnumber(){  return indexnumber; }
  void setIndexnumber(int i){ indexnumber=i;   }
  
private:
 
 virtual void read(TQDataStream *s);
 virtual void write(TQDataStream *s);

 unsigned int indexnumber;
 TranslationMap translations;
 
};


class DBItemMultiIndex : public DBItem   
{
 public:
  typedef TQValueList<unsigned int> IndexList;
 
  DBItemMultiIndex();
  // DBItemMultiIndex(IndexList l);
   
 void addEntry(unsigned int index);
 void removeEntry(unsigned int index);
 
 IndexList getList(){   return list;}
  void clear() {list.clear();}
 
private:
 
 virtual void read(TQDataStream *s);
 virtual void write(TQDataStream *s);
 
 IndexList list;
 
};


class DBItemNum : public Dbt
{
 public:
  DBItemNum(){ 
  	set_data(&num);
  	set_size(4);
    num=0;
  }
  DBItemNum(unsigned int i){	
    set_data(&num);
  	set_size(4);
    num=i;
  }
 
 unsigned int getNum(){ num=*(unsigned int *)get_data();  return num;}
 
private:
 
 unsigned int num;
 
};




#endif
