//Auto-generated by kalyptus. DO NOT EDIT.
package org.trinitydesktop.koala;

import org.trinitydesktop.qt.TQMetaObject;
import org.trinitydesktop.qt.QtSupport;
import java.util.ArrayList;
import org.trinitydesktop.qt.TQWidget;

public interface KDirListerSignals {
	/**
		 Tell the view that we started to list <code>_url.</code> NOTE: this does _not_ imply that there
		 is really a job running! I.e. KDirLister.jobs() may return an empty list. In this case
		 the items are taken from the cache.
			 The view knows that openURL should start it, so it might seem useless,
		 but the view also needs to know when an automatic update happens.
			@param _url the URL to list
		   		@short    Tell the view that we started to list <code>_url.</code>
	*/
	void started(KURL _url);
	/**
		 Tell the view that listing is finished. There are no jobs running anymore.
		   		@short    Tell the view that listing is finished.
	*/
	void completed();
	/**
		 Tell the view that the listing of the directory <code>_url</code> is finished.
		 There might be other running jobs left.
		 This signal is only emitted if KDirLister is watching more than one directory.
			@param _url the directory URL
		   		@short    Tell the view that the listing of the directory <code>_url</code> is finished.
	*/
	void completed(KURL _url);
	/**
		 Tell the view that the user canceled the listing. No running jobs are left.
		   		@short    Tell the view that the user canceled the listing.
	*/
	void canceled();
	/**
		 Tell the view that the listing of the directory <code>_url</code> was canceled.
		 There might be other running jobs left.
		 This signal is only emitted if KDirLister is watching more than one directory.
			@param _url the directory URL
		   		@short    Tell the view that the listing of the directory <code>_url</code> was canceled.
	*/
	void canceled(KURL _url);
	/**
		 Signal a redirection.
		 Only emitted if there's just one directory to list, i.e. most
		 probably openURL() has been called with <code>_keep</code> == <code>false.</code>
			@param _url the new URL
		   		@short    Signal a redirection.
	*/
	void redirection(KURL _url);
	/**
		 Signal a redirection.
			@param oldUrl the original URL
			@param newUrl the new URL
		   		@short    Signal a redirection.
	*/
	void redirection(KURL oldUrl, KURL newUrl);
	/**
		 Signal to clear all items.
		 It must always be connected to this signal to avoid doubled items!
		   		@short    Signal to clear all items.
	*/
	void clear();
	/**
		 Signal to empty the directory <code>_url.</code>
		 It is only emitted if the lister is holding more than one directory.
			@param _url the directory that will be emptied
		   		@short    Signal to empty the directory <code>_url.</code>
	*/
	void clear(KURL _url);
	/**
		 Signal new items.
			@param items a list of new items
		   		@short    Signal new items.
	*/
	void newItems(ArrayList items);
	/**
		 Send a list of items filtered-out by mime-type.
			@param items the list of filtered items
		   		@short    Send a list of items filtered-out by mime-type.
	*/
	void itemsFilteredByMime(ArrayList items);
	/**
		 Signal an item to remove.
			 ATTENTION: if <code>_fileItem</code> == rootItem() the directory this lister
		            is holding was deleted and you HAVE to release especially the
		            rootItem() of this lister, otherwise your app will CRASH!!
		            The clear() signals have been emitted already.
			@param _fileItem the fileItem to delete
		   		@short    Signal an item to remove.
	*/
	void deleteItem(KFileItem _fileItem);
	/**
		 Signal an item to refresh (its mimetype/icon/name has changed).
		 Note: KFileItem.refresh has already been called on those items.
			@param items the items to refresh
		   		@short    Signal an item to refresh (its mimetype/icon/name has changed).
	*/
	void refreshItems(ArrayList items);
	/**
		 Emitted to display information about running jobs.
		 Examples of message are "Resolving host", "Connecting to host...", etc.
			@param msg the info message
		   		@short    Emitted to display information about running jobs.
	*/
	void infoMessage(String msg);
	/**
		 Progress signal showing the overall progress of the KDirLister.
		 This allows using a progress bar very easily. (see KProgress)
			@param percent the progress in percent
		   		@short    Progress signal showing the overall progress of the KDirLister.
	*/
	void percent(int percent);
	/**
		 Emitted when we know the size of the jobs.
			@param size the total size in bytes
		   		@short    Emitted when we know the size of the jobs.
	*/
	void totalSize(long size);
	/**
		 Regularly emitted to show the progress of this KDirLister.
			@param size the processed size in bytes
		   		@short    Regularly emitted to show the progress of this KDirLister.
	*/
	void processedSize(long size);
	/**
		 Emitted to display information about the speed of the jobs.
			@param bytes_per_second the speed in bytes/s
		   		@short    Emitted to display information about the speed of the jobs.
	*/
	void speed(int bytes_per_second);
}
