/*
    This file is part of tdepim.

    Copyright (c) 2004 Cornelius Schumacher <schumacher@kde.org>
    Copyright (c) 2004 Till Adam <adam@kde.org>
    Copyright (c) 2005 Reinhold Kainhofer <reinhold@kainhofer.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/
#ifndef KPIM_GROUPWAREJOB_H
#define KPIM_GROUPWAREJOB_H

#include <tqobject.h>
#include <tqstring.h>
#include "folderlister.h"

namespace KPIM {

class GroupwareDataAdaptor;

/**
  This class provides a resource for accessing a Groupware tdeioslave-based
  calendar.
*/
class GroupwareJob : public TQObject
{
    TQ_OBJECT
  
  public:
    GroupwareJob( GroupwareDataAdaptor *adaptor );

    bool error() const;
    TQString errorString() const;

    virtual void kill() = 0;
    
  signals:
    void result( KPIM::GroupwareJob * );

  protected:
    void success();
    void error( const TQString & );
    GroupwareDataAdaptor *adaptor() { return mAdaptor; }
    const GroupwareDataAdaptor *adaptor() const { return mAdaptor; }

  protected slots:
    virtual void run() = 0;

  private:
    TQString mErrorString;
    GroupwareDataAdaptor *mAdaptor;
};

}

#endif
