/*
    This file is part of KOrganizer.
    Copyright (c) 2002 Cornelius Schumacher <schumacher@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/
#ifndef KORG_GLOBALS_H
#define KORG_GLOBALS_H

#include <tdemacros.h>
#include <tqwidget.h>

class TQDate;
class TQPixmap;
class TQIconSet;
class KCalendarSystem;
class AlarmClient;

class TDEConfig;
class TDEInstance;
class KHolidays;

class TDE_EXPORT KOGlobals
{
  public:
    static KOGlobals *self();

    enum HowChanged {
      INCIDENCEADDED,
      INCIDENCEEDITED,
      INCIDENCEDELETED,
      NOCHANGE
    };
    enum WhatChanged {
      PRIORITY_MODIFIED,
      COMPLETION_MODIFIED,
      CATEGORY_MODIFIED,
      DATE_MODIFIED,
      RELATION_MODIFIED,
      ALARM_MODIFIED,
      DESCRIPTION_MODIFIED,
      SUMMARY_MODIFIED,
      COMPLETION_MODIFIED_WITH_RECURRENCE,
      RECURRENCE_MODIFIED_ONE_ONLY,
      RECURRENCE_MODIFIED_ALL_FUTURE,
      UNKNOWN_MODIFIED,
      NOTHING_MODIFIED
    };

    enum WhichOccurrences {
      NONE,
      ONLY_THIS_ONE,
      ONLY_FUTURE,
      ALL
    };

    enum OccurrenceAction {
      CUT,
      COPY,
      EDIT
    };

    static void fitDialogToScreen( TQWidget *widget, bool force=false );
    TDEConfig *config() const;

    static bool reverseLayout();

    const KCalendarSystem *calendarSystem() const;

    AlarmClient *alarmClient() const;

    ~KOGlobals();

    TQPixmap smallIcon( const TQString& name );
    TQIconSet smallIconSet( const TQString& name, int size = 0 );

    TQStringList holiday( const TQDate & );
    bool isWorkDay( const TQDate & );
    int getWorkWeekMask();
    /**
       Set which holidays the user wants to use.
       @param h a KHolidays object initialized with the desired locale.
       We capture this object, so you must not delete it.
    */
    void setHolidays( KHolidays *h );

    /** return the KHolidays object or 0 if none has been defined
    */
    KHolidays *holidays() const;

  protected:
    KOGlobals();

  private:
    static KOGlobals *mSelf;

    TDEInstance *mOwnInstance;

    AlarmClient *mAlarmClient;

    KHolidays *mHolidays;
};

#endif
