/**
 * folderdiaacltab.h
 *
 * Copyright (c) 2004 David Faure <faure@kde.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *  In addition, as a special exception, the copyright holders give
 *  permission to link the code of this program with any edition of
 *  the TQt library by Trolltech AS, Norway (or with modified versions
 *  of TQt that use the same license as TQt), and distribute linked
 *  combinations including the two.  You must obey the GNU General
 *  Public License in all respects for all of the code used other than
 *  TQt.  If you modify this file, you may extend this exception to
 *  your version of the file, but you are not obligated to do so.  If
 *  you do not wish to do so, delete this exception statement from
 *  your version.
 */
#ifndef FOLDERDIAACL_H
#define FOLDERDIAACL_H

#include "kmfolderdia.h"
#include "acljobs.h"
#include "kmfoldertype.h"

class KMFolderImap;
class KPushButton;
class TQWidgetStack;
class TQHBox;
class TQVButtonGroup;
class TDEListView;
namespace TDEIO { class Job; }

namespace KMail {

enum IMAPUserIdFormat { FullEmail, UserName };

struct ACLListEntry;
typedef TQValueVector<KMail::ACLListEntry> ACLList;

class ImapAccountBase;

/**
 * "New Access Control Entry" dialog.
 * Internal class, only used by FolderDiaACLTab
 */
class ACLEntryDialog :public KDialogBase {
  TQ_OBJECT
  

public:
  ACLEntryDialog( IMAPUserIdFormat userIdFormat, const TQString& caption, TQWidget* parent, const char* name = 0 );

  void setValues( const TQString& userId, unsigned int permissions );

  TQString userId() const;
  TQStringList userIds() const;
  unsigned int permissions() const;

private slots:
  void slotSelectAddresses();
  void slotChanged();

private:
  TQVButtonGroup* mButtonGroup;
  KLineEdit* mUserIdLineEdit;
  IMAPUserIdFormat mUserIdFormat;
};

/**
 * "Access Control" tab in the folder dialog
 * Internal class, only used by KMFolderDialog
 */
class FolderDiaACLTab : public FolderDiaTab
{
  TQ_OBJECT
  

public:
  FolderDiaACLTab( KMFolderDialog* dlg, TQWidget* parent, const char* name = 0 );

  virtual void load();
  virtual bool save();
  virtual AccepStatus accept();

  static bool supports( KMFolder* refFolder );

private slots:
  // Network (TDEIO) slots
  void slotConnectionResult( int, const TQString& );
  void slotReceivedACL( KMFolder*, TDEIO::Job*, const KMail::ACLList& );
  void slotMultiSetACLResult(TDEIO::Job *);
  void slotACLChanged( const TQString&, int );
  void slotReceivedUserRights( KMFolder* folder );
  void slotDirectoryListingFinished(KMFolderImap*);

  // User (TDEListView) slots
  void slotEditACL(TQListViewItem*);
  void slotSelectionChanged(TQListViewItem*);

  // User (pushbuttons) slots
  void slotAddACL();
  void slotEditACL();
  void slotRemoveACL();

  void slotChanged( bool b );

private:
  KURL imapURL() const;
  void initializeWithValuesFromFolder( KMFolder* folder );
  void startListing();
  void loadListView( const KMail::ACLList& aclList );
  void loadFinished( const KMail::ACLList& aclList );
  void addACLs( const TQStringList& userIds, unsigned int permissions );

private:
  // The widget containing the ACL widgets (listview and buttons)
  TQHBox* mACLWidget;
  //class ListView;
  class ListViewItem;
  TDEListView* mListView;
  KPushButton* mAddACL;
  KPushButton* mEditACL;
  KPushButton* mRemoveACL;

  TQStringList mRemovedACLs;
  TQString mImapPath;
  ImapAccountBase* mImapAccount;
  int mUserRights;
  KMail::ACLJobs::ACLFetchState mUserRightsState;
  KMFolderType mFolderType;
  ACLList mInitialACLList;
  ACLList mACLList; // to be set
  IMAPUserIdFormat mUserIdFormat;

  TQLabel* mLabel;
  TQWidgetStack* mStack;
  KMFolderDialog* mDlg;

  bool mChanged;
  bool mAccepting; // i.e. close when done
  bool mSaving;
};

} // end of namespace KMail

#endif /* FOLDERDIAACL_H */

