/*
    This file is part of KAddressbook.
    Copyright (c) 2003 Tobias Koenig <tokoe@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.

    As a special exception, permission is given to link this program
    with any edition of TQt, and distribute the resulting executable,
    without including the source code for TQt in the source distribution.
*/

#include <tqfile.h>

#include <kdebug.h>
#include <tdefiledialog.h>
#include <tdeio/netaccess.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <kprocess.h>
#include <kstandarddirs.h>
#include <tdetempfile.h>
#include <kurl.h>

#include "xxportmanager.h"

#include "kde2_xxport.h"

K_EXPORT_KADDRESSBOOK_XXFILTER( libkaddrbk_kde2_xxport, KDE2XXPort )

KDE2XXPort::KDE2XXPort( TDEABC::AddressBook *ab, TQWidget *parent, const char *name )
  : KAB::XXPort( ab, parent, name )
{
  createImportAction( i18n( "Import KDE 2 Addressbook..." ) );
}

TDEABC::AddresseeList KDE2XXPort::importContacts( const TQString& ) const
{
  TQString fileName = locateLocal( "data", "tdeabc/std.vcf" );
  if ( !TQFile::exists( fileName ) ) {
    KMessageBox::sorry( parentWidget(), i18n( "<qt>Could not find a KDE 2 address book <b>%1</b>.</qt>" ).arg( fileName ) );
    return TDEABC::AddresseeList();
  }

  int result = KMessageBox::questionYesNoCancel( parentWidget(),
      i18n( "Override previously imported entries?" ),
      i18n( "Import KDE 2 Addressbook" ), i18n("Import"), i18n("Do Not Import") );

  if ( !result ) return TDEABC::AddresseeList();

  TDEProcess proc;

  if ( result == KMessageBox::Yes ) {
    proc << "tdeab2tdeabc";
    proc << "--override";
  } else if ( result == KMessageBox::No )
    proc << "tdeab2tdeabc";
  else {
    kdDebug(5720) << "KAddressBook::importKDE2(): Unknow return value." << endl;
    return TDEABC::AddresseeList();
  }
  proc.start( TDEProcess::Block );

  addressBook()->load();

  return TDEABC::AddresseeList();
}

#include "kde2_xxport.moc"
