/****************************************************************************
**
** Copyright (C) 2012 Timothy Pearson.  All rights reserved.
**
** This file is part of the TDE Qt4 style interface
**
** This file may be used under the terms of the GNU General
** Public License versions 2.0 or 3.0 as published by the Free
** Software Foundation and appearing in the files LICENSE.GPL2
** and LICENSE.GPL3 included in the packaging of this file.
**
** This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
** INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE. Trolltech reserves all rights not granted
** herein.
**
**********************************************************************/

#ifndef TDEQT4CONVERTER_H
#define TDEQT4CONVERTER_H

#include <tqstyle.h>
#include <tqpixmap.h>
#include <tqbitmap.h>
#include <tqpainter.h>
#include <tqapplication.h>
#include <tqprogressbar.h>
#include <tqtabbar.h>
#include <tqradiobutton.h>
#include <tqcheckbox.h>
#include <tqpopupmenu.h>
#include <tqmenudata.h>
#include <tqcombobox.h>
#include <tqslider.h>
#include <tqscrollbar.h>
#include <tqspinbox.h>
#include <tqiconset.h>
#include <tqmenubar.h>
#include <tqtoolbox.h>
#include <tqtoolbutton.h>
#include <qtitlebar_p.h>
#include <tqpixmapcache.h>
#undef Qt

#include <QtGui/QtGui>
#include <QtGui/QX11Info>

enum TQt3WidgetType {
	TQT3WT_NONE,
	TQT3WT_TQProgressBar,
	TQT3WT_TQTabBar,
	TQT3WT_TQRadioButton,
	TQT3WT_TQCheckBox,
	TQT3WT_TQPushButton,
	TQT3WT_TQPopupMenu,
	TQT3WT_TQComboBox,
	TQT3WT_TQSlider,
	TQT3WT_TQScrollBar,
	TQT3WT_TQSpinBox,
	TQT3WT_TQSpinWidget,
	TQT3WT_TQTitleBar,
	TQT3WT_TQMenuBar,
	TQT3WT_TQToolBox,
	TQT3WT_TQToolButton
};

TQt::Orientation convertQt4ToTQt3Orientation(Qt::Orientation qt4orient);
TQSlider::TickSetting convertQt4ToTQt3TickSetting(QSlider::TickPosition qt4ts);
QColor convertTQt3ToQt4Color(TQColor tqt3color);
TQColor convertQt4ToTQt3Color(QColor qt4color);
QString convertTQt3ToQt4String(TQString tqt3string);
TQString convertQt4ToTQt3String(QString qt4string);
QStringList convertTQt3ToQt4StringList(TQStringList tqt3stringlist);
QSize convertTQt3ToQt4Size(TQSize tqt3size);
TQSize convertQt4ToTQt3Size(QSize qt4size);
TQString generateTQt3CacheKey(QIcon qt4icon, int iconsize, bool transparent, TQColor* bgcolor);
TQPixmap convertQt4ToTQt3Pixmap(QPixmap qt4pixmap, bool copyTransparency = true, TQColor* bgcolor = 0);
TQRegion convertQt4ToTQt3Region(QRegion qt4region);
TQPixmap convertQt4IconToTQt3Pixmap(QIcon qt4icon, int iconsize, TQPixmapCache* pmCache = 0, bool copyTransparency = true, TQColor* bgcolor = 0);
QIcon convertTQt3PixmapToQt4Icon(TQPixmap tqt3pixmap);
TQIconSet convertQt4ToTQt3IconSet(QIcon qt4icon, int smallsize, int largesize, TQPixmapCache* pmCache = 0);
QRect convertTQt3ToQt4Rect(TQRect tqt3rect);
QBrush convertTQt3ToQt4Brush(TQBrush tqt3brush);
TQBrush convertQt4ToTQt3Brush(QBrush qt4brush);
QPalette convertTQt3ToQt4Palette(TQPalette tqt3palette);
TQPalette convertQt4ToTQt3Palette(QPalette qt4palette);
QFont convertTQt3ToQt4Font(TQFont qt3font);
TQStyle::SFlags convertQt4ToTQt3SFlags(QStyle::State qt4stateflags, TQt3WidgetType wt);

#endif // TDEQT4CONVERTER_H
