/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>
#include <tdeconfig.h>
#include <tqcheckbox.h>

#include "configdlgbase.h"
#include "configdlg.h"
#include "toplevel.h"

KTMConfigureDialog::KTMConfigureDialog(TopLevel* tlapp, TQWidget* parent, const char* name)
	: KDialogBase(parent, name, true, i18n("Kerberos Ticket Manager Configuration"), Ok|Cancel|Apply, Ok, true), m_tlapp(tlapp)
{
	m_base = new ConfigDlgBase(this);

	setMainWidget(m_base);

	m_base->autostart->setChecked(m_tlapp->autostart);
	m_base->notifyExpiry->setChecked(m_tlapp->notifyExpiry);
	m_base->notifyExpiryMinutes->setValue(m_tlapp->notifyExpiryMinutes);
}

void KTMConfigureDialog::save() {
	m_tlapp->autostart = m_base->autostart->isOn();
	m_tlapp->notifyExpiry = m_base->notifyExpiry->isOn();
	m_tlapp->notifyExpiryMinutes = m_base->notifyExpiryMinutes->value();

	m_tlapp->save();
}

void KTMConfigureDialog::slotOk() {
	save();
	accept();
}

void KTMConfigureDialog::slotApply() {
	save();
}

#include "configdlg.moc"
