/***************************************************************************
 *   Copyright (C) 2005-2007 by Rajko Albrecht                             *
 *   ral@alwins-world.de                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
 ***************************************************************************/
#include "ssltrustprompt_impl.h"
#include "tdesvnsettings.h"

#include <tdelocale.h>
#include <tqlabel.h>
#include <tqtable.h>
#include <tqvbox.h>
#include <kdebug.h>
#include <tdeglobal.h>
#include <kapp.h>
#include <tdeconfigbase.h>
#include <tdeconfig.h>
#include <kdialogbase.h>
#include <ktextbrowser.h>

SslTrustPrompt_impl::SslTrustPrompt_impl(const TQString&host,TQWidget *parent, const char *name)
    :SslTrustPrompt(parent, name)
{
    m_MainLabel->setText("<p align=\"center\"><b>"+
        i18n("Error validating server certificate for '%1'").arg(host)+
        TQString("</b></p>"));
}


/*!
    \fn SslTrustPrompt_impl::sslTrust(const TQString&host,const TQString&fingerprint,const TQString&validFrom,const TQString&validUntil,const TQString&issuerName,const TQString&realm,bool*ok,bool*saveit)
 */
bool SslTrustPrompt_impl::sslTrust(const TQString&host,const TQString&fingerprint,const TQString&validFrom,const TQString&validUntil,const TQString&issuerName,const TQString&realm,const TQStringList&reasons,bool*ok,bool*saveit)
{
    SslTrustPrompt_impl*ptr=0;
    KDialogBase dlg(i18n("Trust ssl certificate"));
    dlg.setButtonText(KDialogBase::Yes,i18n("Accept permanently"));
    dlg.setButtonText(KDialogBase::No,i18n("Accept temporarily"));
    dlg.setButtonCancel(KGuiItem(i18n("Reject")));

    static TQString rb = "<tr><td>";
    static TQString rs = "</td><td>";
    static TQString re = "</td></tr>";
    TQString text = "<html><body>";
    if (reasons.count()>0) {
        text+="<p align=\"center\">";
        text+="<h2>"+i18n("Failure reasons")+"</h2><hline>";
        for (unsigned int i = 0; i < reasons.count();++i) {
            text+=reasons[i]+"<br><hline>";
        }
        text+="</p>";
    }

    text+="<p align=\"center\"><table>";
    text+=rb+i18n("Realm")+rs+realm+re;
    text+=rb+i18n("Host")+rs+host+re;
    text+=rb+i18n("Valid from")+rs+validFrom+re;
    text+=rb+i18n("Valid until")+rs+validUntil+re;
    text+=rb+i18n("Issuer name")+rs+issuerName+re;
    text+=rb+i18n("Fingerprint")+rs+fingerprint+re;
    text+="</table></p></body></html>";

    TQWidget* Dialog1Layout = dlg.makeVBoxMainWidget();
    dlg.resize(dlg.configDialogSize(*(Kdesvnsettings::self()->config()),"trustssldlg"));
    ptr = new SslTrustPrompt_impl(host,Dialog1Layout);
    ptr->m_ContentText->setText(text);
    int i = dlg.exec();
    dlg.saveDialogSize(*(Kdesvnsettings::self()->config()),"trustssldlg",false);
    *saveit = false;
    *ok = true;
    if (i == KDialogBase::Yes) {
        *saveit = true;
    } else if (i==KDialogBase::Cancel) {
        *ok = false;
    }
    return *ok;
}
#include "ssltrustprompt_impl.moc"
