/***************************************************************************
 *   Copyright (C) 2006 by Sergio Cambra   *
 *   sergio@ensanjose.net   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#include <tqlayout.h>

#include <tdelocale.h>
#include <tdeglobal.h>
#include <tdeparts/genericfactory.h>
#include <tdeaboutdata.h>

#include "kcmkommando.h"
#include "configdialogimpl.h"
#include "configuration.h"

static const char description[] =
    I18N_NOOP("A wheelmenu for TDE powerusers");

static const char version[] = "0.5.2";

typedef KGenericFactory<KCMKommando, TQWidget> kommandoFactory;
K_EXPORT_COMPONENT_FACTORY( kcm_kommando, kommandoFactory("kommando"))

KCMKommando::KCMKommando(TQWidget *parent, const char *name, const TQStringList&)
	: TDECModule(kommandoFactory::instance(), parent, name), about(0), configDialog(0)
{
	about = new TDEAboutData("kommando", I18N_NOOP("Kommando"), version, description,
					 TDEAboutData::License_GPL, "(C) 2005 Daniel StÃ¶ckel", 0, 0, "the_docter@gmx.net");
	about->addAuthor( "Daniel StÃ¶ckel", 0, "the_docter@gmx.net" );
	about->addAuthor( "Sergio Cambra", 0, "runico@users.berlios.de" );
	setAboutData(about);
	
	TQVBoxLayout* layout = new TQVBoxLayout( this );
	layout->setAutoAdd( true );
	configDialog = new ConfigDialogImpl(this);
	connect(configDialog, TQ_SIGNAL(changed(bool)), this, TQ_SLOT(configChanged(bool)));
    load();
};


KCMKommando::~KCMKommando()
{
}


void KCMKommando::load()
{
	Config& config = Config::getSingleton();
    config.readConfigFile();
    configDialog->readConfig();
    emit changed(false);
}


void KCMKommando::defaults()
{
	configDialog->slotDefaultsClicked();
    emit changed(true);
}


void KCMKommando::save()
{
	configDialog->slotApplyClicked();
    emit changed(false);
}


int KCMKommando::buttons()
{
    return TDECModule::Default|TDECModule::Apply|TDECModule::Help;
}


TQString KCMKommando::quickHelp() const
{
    return i18n("Helpful information about the prueba module.");
}

#include "kcmkommando.moc"
