/* This file is part of KNemo
   Copyright (C) 2006 Percy Leonhardt <percy@eris23.de>

   KNemo is free software; you can redistribute it and/or modify
   it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   KNemo is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef KCMREGISTRY_H
#define KCMREGISTRY_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <tqstring.h>

#include <tdelocale.h>

/**
 * This registry tells the KCM module what backends are available
 * and how they can be created. It also offers a short description
 * for every backend that is used in the configuration dialog of KNemo.
 * It should describe how a backend gathers its information.
 *
 * @short Registry for all backends
 * @author Percy Leonhardt <percy@eris23.de>
 */

struct KCMRegistryEntry
{
    TQString name;
    TQString description;
};

KCMRegistryEntry KCMRegistry[] =
{
    { "Sys", i18n( "Uses the sys filesystem available in 2.6 kernels and " \
                   "direct system calls to the Linux kernel." ) },
#if defined( WITH_NETTOOLS )
    { "Nettools", i18n( "Uses the tools from the net-tools package like ifconfig, " \
                        "iwconfig and route to read the necessary information "     \
                        "from the ouput of these commands.") },
#endif
    { TQString(), TQString() }
};

#endif // KCMREGISTRY_H
