/***************************************************************************
 *   Copyright (C) 2000 Ronny Standtke <Ronny.Standtke@gmx.de>             *
 *             (C) 2005 Gábor Lehel <illissius@gmail.com>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include "squeezedtextlabel.h"
#include <tqsimplerichtext.h>
#include <tqwindowdefs.h> //TQCOORD_MAX
#include <tqtooltip.h>
#include <kdebug.h>

namespace KDE {

SqueezedTextLabel::SqueezedTextLabel( const TQString &text , TQWidget *parent, const char *name )
 : TQLabel ( parent, name ) {
  setSizePolicy(TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
  fullText = text;
  squeezeTextToLabel();
}

SqueezedTextLabel::SqueezedTextLabel( TQWidget *parent, const char *name )
 : TQLabel ( parent, name ) {
  setSizePolicy(TQSizePolicy( TQSizePolicy::Expanding, TQSizePolicy::Fixed ));
}

void SqueezedTextLabel::resizeEvent( TQResizeEvent * ) {
  squeezeTextToLabel();
}

TQSize SqueezedTextLabel::minimumSizeHint() const
{
  TQSize sh = TQLabel::minimumSizeHint();
  sh.setWidth(-1);
  return sh;
}

TQSize SqueezedTextLabel::sizeHint() const
{
  return TQSize(contentsRect().width(), TQLabel::sizeHint().height());
}

void SqueezedTextLabel::setText( const TQString &text ) {
  fullText = text;
  squeezeTextToLabel();
}


//TQSimpleRichText suck
//in more detail, we only want the widthUsed(), which doesn't normally work, see below
class MySimpleRichText: public TQSimpleRichText
{
    public:
    MySimpleRichText( const TQString &text, const TQFont &font )
        : TQSimpleRichText( text, font )
    {
        setWidth( TQCOORD_MAX ); //by default it's like 150-something, always. wtf?
    }
};

void SqueezedTextLabel::squeezeTextToLabel()
{
    if( MySimpleRichText( fullText, font() ).widthUsed() > width() )
    {
        TQString text;
        const int w = width() - fontMetrics().width( "..." );
        if( w < 0 )
        {
            text = "..";
            while( fontMetrics().width( text ) > width() && !text.isEmpty() )
                text.remove( text.length() - 1, 1);
        }
        else
        {
            text = fullText;
            do
            {
                int pos = text.length() - 1;
                bool breakagain = false; //isn't there a better way to handle this?
                while( text[pos] == '>' ) //don't remove parts of <tags>, it's not nice
                {
                    const int lpos = pos;
                    while( text[pos] != '<' && pos >= 0  )
                        --pos;
                    if( pos == 0 ) //text is only tags
                    {
                        breakagain = true;
                        break;
                    }
                    else
                        --pos;
                    if( pos < 0 ) //didn't find an opening <
                    {
                        pos = lpos;
                        break;
                    }
                }
                if( breakagain )
                    break;
                text.remove( pos, 1 );                                    //paranoia
            } while( MySimpleRichText( text, font() ).widthUsed() > w && !text.isEmpty() );
            text += "...";
        }
        TQLabel::setText( text );
	TQToolTip::remove( this );
        TQToolTip::add( this, fullText );
    }
    else
    {
        TQLabel::setText( fullText );
        TQToolTip::remove( this );
        TQToolTip::hide();
    }
}

void SqueezedTextLabel::setAlignment( int alignment )
{
  // save fullText and restore it
  TQString tmpFull(fullText);
  TQLabel::setAlignment(alignment);
  fullText = tmpFull;
}


}

#include "squeezedtextlabel.moc"
