#!/usr/bin/env python
#Gnome Multimedia Key's event handler script.
#This script will allow the use of multimedia buttons in amarok as configured using gnome keyboard shortcuts.
#Author: Chris Brown
#Date: 22June2007
#Version: 0.3
#bug reports to: chris.scotland[at]gmail.com

import os, gobject

try:
    import dbus
except:
    os.system("kdialog --sorry 'the package python-dbus (DBUS bindings for Python) is required for this script.'")
    raise

try:
    from dbus import glib
except:
    os.system("kdialog --sorry 'the package libdbus-glib (Glib-based shared library for dbus) is required for this script.'")
    raise

bus = dbus.SessionBus()
object = bus.get_object('org.gnome.SettingsDaemon', '/org/gnome/SettingsDaemon')

def signal_handler(*mmkeys):
	for mmk in mmkeys:
        	if mmk == "Play":
			os.system("dcop amarok player playPause")
		elif mmk == "Pause":
			os.system("dcop amarok player pause")
		elif mmk == "Stop":
			os.system("dcop amarok player stop")
		elif mmk == "Next":
			os.system("dcop amarok player next")
		elif mmk == "Previous":
			os.system("dcop amarok player prev")


object.connect_to_signal("MediaPlayerKeyPressed", signal_handler, dbus_interface='org.gnome.SettingsDaemon')

gobject.timeout_add(5000, signal_handler)

loop = gobject.MainLoop()
loop.run()
