/***************************************************************************
 *   Copyright (C) 2003 by KDevelop Authors                                *
 *   tdevelop-devel@kde.org                                                *
 *   Copyright (C) 2003 by Mario Scalas                                    *
 *   mario.scalas@libero.it                                                *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _CVSOPTIONSWIDGET_H_
#define _CVSOPTIONSWIDGET_H_

#include <tqwidget.h>
#include "cvsoptionswidgetbase.h"

class TQLabel;
class TQVBoxLayout;

class CvsOptionsWidget : public CvsOptionsWidgetBase
{
    TQ_OBJECT
  
public:
    CvsOptionsWidget( TQWidget *parent, const char *name=0 );
    virtual ~CvsOptionsWidget();

    bool pruneEmptyDirWhenUpdating() const;
    void setPruneEmptyDirWhenUpdating( bool b );

    bool createNewDirWhenUpdating() const;
    void setCreateNewDirWhenUpdating( bool b );

    bool recursiveWhenUpdating() const;
    void setRecursiveWhenUpdating( bool b );

    bool recursiveWhenCommittingRemoving() const;
    void setRecursiveWhenCommittingRemoving( bool b );

    unsigned int contextLines() const;
    void setContextLines( unsigned int p );

    TQString diffOptions() const;
    void setDiffOptions( const TQString &p );

    TQString cvsRshEnvVar() const;
    void setCvsRshEnvVar( const TQString &p );

    TQString serverLocation() const;
    void setServerLocation( const TQString &p );

public slots:
    void accept();

private:
    void readConfig();
    void storeConfig();
};

#endif
