/***************************************************************************
 *   Copyright (C) 2004 by Alexander Dymo                                  *
 *   adymo@kdevelop.org                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include <tdeapplication.h>
#include <tdeaboutdata.h>
#include <tdecmdlineargs.h>

#include "profileeditor.h"

static TDECmdLineOptions options[] =
{
    TDECmdLineLastOption
};

int main(int argc, char **argv)
{
    TDEAboutData about("kdevprofileeditor", I18N_NOOP("TDevelop Profile Editor"), "1", "",
                     TDEAboutData::License_GPL, I18N_NOOP("(c) 2004, The KDevelop Developers"), 0, 0, "");
    about.addAuthor("Alexander Dymo", 0, "adymo@kdevelop.org");
    TDECmdLineArgs::init(argc, argv, &about);
    TDECmdLineArgs::addCmdLineOptions(options);

    TDEApplication app(argc, argv);
    ProfileEditor editor;
    editor.show();
    app.setMainWidget(&editor);

    return app.exec();
}
