#ifndef _CORE_H_
#define _CORE_H_

#include <tqregexp.h>
#include <kxmlguiclient.h>

#include <tdeparts/partmanager.h>


#include "kdevcore.h"

namespace MainWindowUtils{

TQString beautifyToolTip(const TQString& text);
}

/**
Core implementation.
*/
class Core : public KDevCore
{
  TQ_OBJECT
  

public:

  static Core *getInstance();
  
  /**
   * Setup shourtcut tips. For every TDEAction with a shortcut,
   * appends the shortcut string, in parenthesis, to the
   * actions's tooltip. If tooltip already has any text in
   * parens, it's removed and shortcut is added instead.
   *
   * @param client
   *   Pointer to KXMLGUIClient object, which contain an collection
   *   of actions (TDEActionCollection). If the parameter is null,
   *   function is applied to the all available KXMLGUIClient objects.
   */
  static void setupShourtcutTips(KXMLGUIClient * client = 0);

  ~Core();

  virtual void running(KDevPlugin *which, bool runs);
  virtual void fillContextMenu(TQPopupMenu *popup, const Context *context);
  virtual void openProject(const TQString& projectFileName);

  void doEmitProjectOpened() { emit projectOpened(); }
  void doEmitProjectClosed() { emit projectClosed(); }
  void doEmitLanguageChanged() { emit languageChanged(); }
  void doEmitCoreInitialized() { emit coreInitialized(); }
  void doEmitProjectConfigWidget(KDialogBase *base) { emit projectConfigWidget(base); }
  void doEmitConfigWidget(KDialogBase *base) { emit configWidget(base); }
  void doEmitStopButtonPressed(KDevPlugin* which = 0) { emit stopButtonClicked( which ); }

  bool queryClose();

signals:

  void activeProcessChanged(KDevPlugin* which, bool runs);

protected:

  Core();
  
private:
  static Core *s_instance;

};


#endif
