/***************************************************************************
 *   Copyright (C) 2003 by Julian Rockey                                   *
 *   linux@jrockey.com                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef __FILECREATE_FILETYPE_H__
#define __FILECREATE_FILETYPE_H__

#include <tqstring.h>
#include <tqptrlist.h>

namespace FileCreate {

class FileType {

public:

  FileType() : m_enabled(false) {
    m_subtypes.setAutoDelete(true);
  }

  void setName(const TQString & name) { m_name = name; }
  TQString name() const { return m_name; }
  void setExt(const TQString & ext) { m_ext = ext; }
  TQString ext() const { return m_ext; }
  void setCreateMethod(const TQString & createMethod) { m_createMethod = createMethod; }
  TQString createMethod() const { return m_createMethod; }
  void setSubtypeRef(const TQString & subtypeRef) { m_subtypeRef = subtypeRef; }
  TQString subtypeRef() const { return m_subtypeRef; }
  void setIcon(const TQString & iconName) { m_iconName = iconName; }
  TQString icon() const { return m_iconName; }
  void setDescr(const TQString & descr) { m_descr = descr; }
  TQString descr() const { return m_descr; }
  void setEnabled(bool on) { m_enabled = on; }
  bool enabled() const { return m_enabled; }

  void setSubtypesEnabled(bool enabled = true);

  void addSubtype(const FileType * subtype) { m_subtypes.append(subtype); }
  TQPtrList<FileType> subtypes() const { return m_subtypes; }

  void setId(int id) { m_id = id; }
  int id() const { return m_id; }

private:
  TQString m_name;
  TQString m_ext;
  TQString m_createMethod;
  TQString m_subtypeRef;
  TQString m_iconName;
  TQString m_descr;

  bool m_enabled;

  TQPtrList<FileType> m_subtypes;

  int m_id;
};

}

#endif
