/***************************************************************************
 *   Copyright (C) 2003-2004 by Alexander Dymo                             *
 *   cloudtemple@mskat.net                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU Library General Public     *
 *   License along with this program; if not, write to the                 *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.             *
 ***************************************************************************/
#include "pstringlistedit.h"

#include <tqlayout.h>
#include <tqdialog.h>
#include <tqpainter.h>
#include <klineedit.h>

#ifndef PURE_QT
#include <keditlistbox.h>
#include <kpushbutton.h>
#include <kstdguiitem.h>
#else
#include "tqeditlistbox.h"
#include <tqpushbutton.h>
#include "compat_tools.h"
#endif

namespace PropertyLib{

PStringListEdit::PStringListEdit(MultiProperty *property, TQWidget *parent, const char *name)
     :PropertyWidget(property, parent, name)
{
    l = new TQHBoxLayout(this);

    edit = new KLineEdit(this);
    edit->setReadOnly(true);
    edit->setSizePolicy(TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding);
    l->addWidget(edit);
    pbSelect = new TQPushButton("...", this);
    pbSelect->setSizePolicy(TQSizePolicy::Maximum, TQSizePolicy::MinimumExpanding);
    l->addWidget(pbSelect);

    connect(pbSelect, TQT_SIGNAL(clicked()), this, TQT_SLOT(showEditor()));
}

TQVariant PStringListEdit::value() const
{
    return TQVariant(m_list);
}

void PStringListEdit::setValue(const TQVariant &value, bool emitChange)
{
    m_list = value.toStringList();
    edit->setText(value.toStringList().join(", "));
    if (emitChange)
        emit propertyChanged(m_property, value);
}

void PStringListEdit::showEditor()
{
    TQDialog* dia = new TQDialog(this, "stringlist_dialog", true);
    TQVBoxLayout *dv = new TQVBoxLayout(dia, 2);

#ifdef PURE_QT
    TQEditListBox *select = new TQEditListBox(dia, "select_char");
#else
    KEditListBox *select = new KEditListBox(dia, "select_char");
#endif
    dv->addWidget(select);

    TQHBoxLayout *dh = new TQHBoxLayout(dv, 6);
#ifndef PURE_QT
    KPushButton *pbOk = new KPushButton(KStdGuiItem::ok(), dia);
    KPushButton *pbCancel = new KPushButton(KStdGuiItem::cancel(), dia);
#else
    TQPushButton *pbOk = new TQPushButton(i18n("Ok"), dia);
    TQPushButton *pbCancel = new TQPushButton(i18n("Cancel"), dia);
#endif
    TQSpacerItem *si = new TQSpacerItem(30, 0, TQSizePolicy::Expanding, TQSizePolicy::Expanding);

    connect(pbOk, TQT_SIGNAL(clicked()), dia, TQT_SLOT(accept()));
    connect(pbCancel, TQT_SIGNAL(clicked()), dia, TQT_SLOT(reject()));

    dh->addItem(si);
    dh->addWidget(pbOk);
    dh->addWidget(pbCancel);

    select->insertStringList(m_list);

    if (dia->exec() == TQDialog::Accepted)
    {
        m_list = select->items();
        edit->setText(select->items().join(", "));
    }
    delete dia;

    emit propertyChanged(m_property, m_list);
}

void PStringListEdit::drawViewer(TQPainter *p, const TQColorGroup &cg, const TQRect &r, const TQVariant &value)
{
    p->setPen(TQt::NoPen);
    p->setBrush(cg.background());
    p->drawRect(r);
    p->drawText(r, TQt::AlignLeft | TQt::AlignVCenter | TQt::SingleLine, value.toStringList().join(", "));
}

}

#ifndef PURE_QT
#include "pstringlistedit.moc"
#endif
