/***************************************************************************
*   Copyright (C) 2006 by Andras Mantia                                   *
*   amantia@kde.org                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************/

#include "blockingkprocess.h"

#include <tqapplication.h>
#include <tqtimer.h>

BlockingTDEProcess::BlockingTDEProcess(TQObject *parent, const char *name)
  : TDEProcess(parent, name)
{
  m_stdOut = "";
  m_stdErr = "";
  m_timeoutValue = 60;
  m_timer = 0L;
  
  connect(this, TQT_SIGNAL(receivedStdout(TDEProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdOut(TDEProcess *, char *, int)));
  connect(this, TQT_SIGNAL(receivedStderr(TDEProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdErr(TDEProcess *, char *, int)));
  connect(this, TQT_SIGNAL(processExited(TDEProcess *)),
          this, TQT_SLOT(slotProcessExited(TDEProcess *)));  
}

BlockingTDEProcess::BlockingTDEProcess()
 : TDEProcess()
{
  m_stdOut = "";
  m_stdErr = "";
  m_timeoutValue = 60;
  m_timer = 0L;
  connect(this, TQT_SIGNAL(receivedStdout(TDEProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdOut(TDEProcess *, char *, int)));
  connect(this, TQT_SIGNAL(receivedStderr(TDEProcess *, char *, int)),
          this, TQT_SLOT(slotReceivedStdErr(TDEProcess *, char *, int)));
  connect(this, TQT_SIGNAL(processExited(TDEProcess *)),
          this, TQT_SLOT(slotProcessExited(TDEProcess *)));  
}


BlockingTDEProcess::~BlockingTDEProcess()
{
}
bool BlockingTDEProcess::start(RunMode runmode, Communication comm)
{
  if (TDEProcess::start(runmode, comm))
  {
    m_timeout = false;
    m_timer = new TQTimer();
    connect(m_timer, TQT_SIGNAL(timeout()), this, TQT_SLOT(slotTimeOut()));
    m_timer->start(m_timeoutValue*1000, true);
    enter_loop();
    delete m_timer;
    m_timer = 0L;
    return !m_timeout;
  } else
    return false;
}


void BlockingTDEProcess::slotReceivedStdOut(TDEProcess *, char *buffer, int buflen)
{
  m_stdOut += TQString::fromLatin1(buffer, buflen);
}

void BlockingTDEProcess::slotReceivedStdErr(TDEProcess *, char *buffer, int buflen)
{
  m_stdErr += TQString::fromLatin1(buffer, buflen);
}

void BlockingTDEProcess::slotProcessExited(TDEProcess *)
{
  tqApp->exit_loop();
}

void BlockingTDEProcess::slotTimeOut()
{
  m_timeout = true;
  kill();
  tqApp->exit_loop();
}


void tqt_enter_modal( TQWidget *widget );
void tqt_leave_modal( TQWidget *widget );

void BlockingTDEProcess::enter_loop()
{
  TQWidget dummy(0,0,WType_Dialog | WShowModal);
  dummy.setFocusPolicy( TQWidget::NoFocus );
  tqt_enter_modal(&dummy);
  tqApp->enter_loop();
  tqt_leave_modal(&dummy);
}


#include "blockingkprocess.moc"
