// *************************************************************************
//                          gdboutputwidget.cpp  -  description
//                             -------------------
//    begin                : 10th April 2003
//    copyright            : (C) 2003 by John Birch
//    email                : jbb@kdevelop.org
//	
//                          Adapted for ruby debugging
//                          --------------------------
//    begin                : Mon Nov 1 2004
//    copyright            : (C) 2004 by Richard Dale
//    email                : Richard_Dale@tipitina.demon.co.uk
// **************************************************************************
//
// **************************************************************************
// *                                                                        *
// *   This program is free software; you can redistribute it and/or modify *
// *   it under the terms of the GNU General Public License as published by *
// *   the Free Software Foundation; either version 2 of the License, or    *
// *   (at your option) any later version.                                  *
// *                                                                        *
// **************************************************************************

#ifndef _RDBOUTPUTWIDGET_H_
#define _RDBOUTPUTWIDGET_H_

#include <tqwidget.h>

class KHistoryCombo;

class TQTextEdit;
class TQToolButton;

namespace RDBDebugger
{

class RDBOutputWidget : public TQWidget
{
    TQ_OBJECT
  

public:
    RDBOutputWidget( TQWidget *parent=0, const char *name=0 );
    ~RDBOutputWidget();

    void clear();

public slots:
    void slotReceivedStdout(const char* line);
    void slotReceivedStderr(const char* line);
    void slotDbgStatus     (const TQString &status, int statusFlag);

    void slotRDBCmd();

protected:
    virtual void focusInEvent(TQFocusEvent *e);

signals:
    void userRDBCmd(const TQString &cmd);
    void breakInto();

private:
    KHistoryCombo*  m_userRDBCmdEditor;
    TQToolButton*    m_Interrupt;
    TQTextEdit*      m_rdbView;
};

}

#endif
