%{CPP_TEMPLATE}

#include "plugin_%{APPNAMELC}.h"

#include <tdeaction.h>
#include <tdelocale.h>
#include <kstandarddirs.h>
#include <tdefiledialog.h>

#include <tqlayout.h>
#include <tqlabel.h>

class PluginView : public KXMLGUIClient
{
    friend class KatePlugin%{APPNAME};

public:
    Kate::MainWindow *win;
};

extern "C"
{
    void* init_lib%{APPNAMELC}plugin()
    {
        TDEGlobal::locale()->insertCatalogue("kate%{APPNAMELC}");
        return new KatePluginFactory;
    }
}

KatePluginFactory::KatePluginFactory()
{
    s_instance = new TDEInstance( "kate" );
}

KatePluginFactory::~KatePluginFactory()
{
    delete s_instance;
}

TQObject* KatePluginFactory::createObject( TQObject* parent, const char* name, const char*, const TQStringList & )
{
    return new KatePlugin%{APPNAME}( parent, name );
}

TDEInstance* KatePluginFactory::s_instance = 0L;

KatePlugin%{APPNAME}::KatePlugin%{APPNAME}( TQObject* parent, const char* name )
    : Kate::Plugin ( (Kate::Application*)parent, name )
{
}

KatePlugin%{APPNAME}::~KatePlugin%{APPNAME}()
{
}

void KatePlugin%{APPNAME}::addView(Kate::MainWindow *win)
{
    /// @todo doesn't this have to be deleted?
    PluginView *view = new PluginView ();

    (void) new TDEAction ( i18n("Insert Hello World"), 0, this,
                         TQT_SLOT( slotInsertHello() ), view->actionCollection(),
                         "edit_insert_%{APPNAMELC}" );

    view->setInstance (new TDEInstance("kate"));
    view->setXMLFile("plugins/%{APPNAMELC}/plugin_%{APPNAMELC}.rc");
    win->guiFactory()->addClient (view);
    view->win = win;

    m_views.append (view);
}

void KatePlugin%{APPNAME}::removeView(Kate::MainWindow *win)
{
    for (uint z=0; z < m_views.count(); z++)
        if (m_views.at(z)->win == win)
        {
            PluginView *view = m_views.at(z);
            m_views.remove (view);
            win->guiFactory()->removeClient (view);
            delete view;
        }
}

void KatePlugin%{APPNAME}::slotInsertHello()
{
    Kate::View *kv = application()->activeMainWindow()->viewManager()->activeView();

    if (kv)
        kv->insertText ("Hello World");
}

Kate::PluginConfigPage* KatePlugin%{APPNAME}::configPage (uint, TQWidget *w, const char* name)
{
    %{APPNAME}ConfigPage* p = new %{APPNAME}ConfigPage(this, w);
    initConfigPage( p );
    connect( p, TQT_SIGNAL(configPageApplyRequest(%{APPNAME}ConfigPage*)), this, TQT_SLOT(slotApplyConfig(%{APPNAME}ConfigPage*)) );
    return (Kate::PluginConfigPage*)p;
}

void KatePlugin%{APPNAME}::initConfigPage( %{APPNAME}ConfigPage* p )
{
    // TODO: initialize %{APPNAME}ConfigPage here
    // NOTE: KatePlugin%{APPNAME} is friend of %{APPNAME}ConfigPage
}

void KatePlugin%{APPNAME}::slotApplyConfig( %{APPNAME}ConfigPage* p )
{
    // TODO: save %{APPNAME}ConfigPage here
    // NOTE: KatePlugin%{APPNAME} is friend of %{APPNAME}ConfigPage
}


/**
 * %{APPNAME}ConfigPage
 */
%{APPNAME}ConfigPage::%{APPNAME}ConfigPage (TQObject* parent /*= 0L*/, TQWidget *parentWidget /*= 0L*/)
    : Kate::PluginConfigPage( parentWidget )
{
    TQVBoxLayout* lo = new TQVBoxLayout( this, 0, 0, "config_page_layout" );
    lo->setSpacing(KDialogBase::spacingHint());

    TQLabel* lab = new TQLabel("KatePlugin%{APPNAME}'s config page", this);

    lo->addWidget(lab);

    // TODO: add connection to emit TQT_SLOT( changed() )
}

%{APPNAME}ConfigPage::~%{APPNAME}ConfigPage()
{
}

void %{APPNAME}ConfigPage::apply()
{
    emit configPageApplyRequest( this );
}

#include "plugin_%{APPNAMELC}.moc"

